<?php 
	if( !defined('ABSPATH') ) exit('Restricted Access');
	$tabs = array();
	$tab_content = '';
	$uniqid = uniqid();
?>

<section class="accordion_area">
	<div class="container">
		<div class="row">
			<div class="col-md-12 col-sm-12 col-xs-12">
				<div class="accordion">
					<h2><?php echo balanceTags($title_main); ?></h2>
				</div>
						
				<div class="accordion_total">
					<div aria-multiselectable="true" role="tablist" id="accordion" class="panel-group">
						<?php $fields = json_decode(urldecode($multi_fields)); ?>
						<?php foreach( (array)$fields as $index => $field ): $collapse = ( $index == 0 ) ? 'collapse in' : 'collapse';
							$area = ( $index == 0 ) ? 'true' : 'false';  
						?>
						<div class="panel panel-default">
							<div class="panel-heading" role="tab">
								<div class="panel-title">
									<a class="collapsed <?php echo esc_attr($area);?>" data-toggle="collapse"data-parent="#accordion" href="#collapse<?php echo esc_attr($uniqid.$index);?>" aria-expanded="<?php echo esc_attr($area);?>">
										<div class="acc_head">
											<div class="acc_head_plus">
												<i class="fa fa-plus"></i>
											</div>
											<div class="acc_head_text">
												<?php echo wooland_wow_themes_set( $field, 'title' ) ; ?>
											</div>
										</div>
									</a>
								</div>
							</div>
							<div id="collapse<?php echo esc_attr($uniqid.$index);?>" class="panel-collapse <?php echo esc_attr($collapse);?>" role="tabpanel">
								<div class="panel-body">
									<?php echo wooland_wow_themes_set( $field, 'text' ); ?>
								</div>
							</div>
						</div>
						<?php endforeach; ?>
					</div>
				</div>
			</div>
		</div>
	</div>
</section>