<?php 
class wooland_wow_themes_About_Us extends WP_Widget
{
	function __construct()
	{
		parent::__construct( /* Base ID */'wooland_wow_themes_About_Us', /* Name */esc_html__('wooland About us ','wooland'), array(      'description' => esc_html__('About us widget ', 'wooland' )) );
	}
	
	/** @see WP_Widget::widget */
    
	 function widget($args, $instance)
	 {
	    extract( $args );
		echo balanceTags($before_widget);
	
    $options = wooland_WSH()->option();

?>
         
            <div class="footer_wid">
                <h3><?php echo balanceTags($instance['title']);?></h3>
                <p><?php echo balanceTags($instance['box_text']);?></p>
            	
			   		 <?php if($socials = wooland_wow_sh_set($options, 'social_media_widget')): //print_r($socials);exit; ?>
                        <div class="footer_social_icon">
                            <ul id="foot_social_icon">
                             <?php foreach($socials as $social):
                                    if(wooland_wow_sh_set($social, 'tocopy')) continue;
                                        $social_color = wooland_wow_sh_set($social, 'social_color');
                                        //if($social_color):
                                        //print_r($social_color);exit;
                                ?>
                                <li><a href="<?php echo wooland_wow_sh_set($social, 'social_link');?>" title="<?php echo wooland_wow_sh_set($social, 'social_title');?>" target="_blank"><i class="fa <?php echo wooland_wow_sh_set($social, 'social_icon');?>"></i> </a></li>
                               
                                <?php endforeach;?>
                            </ul>
                            <?php endif;?>
			   
		    			</div>
       		 </div>  
 
<?php echo balanceTags($after_widget);
		
		 
	}
	/** @see WP_Widget::update */
	function update($new_instance, $old_instance)
	{
		$instance = $old_instance;
		$instance['title'] = $new_instance['title'];
		$instance['box_text'] = $new_instance['box_text'];
		$instance['show'] = $new_instance['show'];
	
		return $instance;
	}
	
	 function form($instance)
	{	
		$title = ( $instance ) ? esc_attr($instance['title']) : '';
		$box_text = ( $instance ) ? esc_attr($instance['box_text']) : '';
		$show = ( $instance ) ? esc_attr($instance['show']) : '';?>

		
<p>
	<label for="<?php echo esc_attr($this->get_field_id('title')); ?>">
		<?php esc_html_e('Title:', 'wooland'); ?>
	</label>
	<input class="widefat" id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
</p>
<p>
	<label for="<?php echo esc_attr($this->get_field_id('box_text')); ?>">
		<?php esc_html_e('Enter the text:', 'wooland'); ?>
	</label>
	<textarea id="<?php echo esc_attr($this->get_field_id('box_text')); ?>" class='widefat' name='<?php echo esc_attr($this->get_field_name('box_text')); ?>' rows="5" cols="5">
				<?php echo esc_textarea($box_text); ?>
			</textarea>
</p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('show')); ?>"><?php esc_html_e('Show Social Icons:', 'wooland'); ?></label>
			<?php $selected = ( $show ) ? ' checked="checked"' : ''; ?>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id('show')); ?>"<?php echo balancetags($selected); ?> name="<?php echo esc_attr($this->get_field_name('show')); ?>" type="checkbox" value="true" />
        </p> 

<?php 
	}
} 

// end about widget



// contact us
class wooland_wow_themes_ContactUs extends WP_Widget
{
	/** constructor */
	function __construct()
	{
		parent::__construct( /* Base ID */'wooland_wow_themes_ContactUs', /* Name */esc_html__('wooland Contact us','wooland'), array( 'description' => esc_html__('Contact us', 'wooland' )) );
	}

	/** @see WP_Widget::widget */
	function widget($args, $instance)
	{
		extract( $args );
		echo balanceTags($before_widget);
?>

										<div class="footer_wid">
											<h3><?php echo balanceTags($instance['title']);?></h3>
											<p><?php echo balanceTags($instance['address']);?></p>
											<div class="footer_ph_contact">
												<p><span><?php esc_html_e( 'Phone :', 'wooland' ); ?></span><a href=""><?php echo balanceTags($instance['phone']);?>
												</a></p>
												<p><span>Email :</span><a href="<?php echo balanceTags($instance['email']);?>"> info@wooland.com
												</a></p>
											</div>
										</div>
									

<?php
		echo balanceTags($after_widget);
	}
	/** @see WP_Widget::update */
	function update($new_instance, $old_instance)
	{
		$instance = $old_instance;

		$instance['title'] = strip_tags($new_instance['title']);
		$instance['address'] = $new_instance['address'];
		$instance['phone'] = $new_instance['phone'];
		$instance['email'] = $new_instance['email'];

		return $instance;
	}

	/** @see WP_Widget::form */
	function form($instance)
	{
		$title = ($instance) ? esc_attr($instance['title']) : esc_html__('Contact', 'wooland');
		$address = ( $instance ) ? esc_attr($instance['address']) : '';
		$phone = ( $instance ) ? esc_attr($instance['phone']) : '';
		$email = ( $instance ) ? esc_attr($instance['email']) : '';
		
		?>
<p>
	<label for="<?php echo esc_attr($this->get_field_id('title')); ?>">
		<?php esc_html_e('Title:', 'wooland'); ?>
	</label>
	<input class="widefat" id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
</p>
<p>
	<label for="<?php echo esc_attr($this->get_field_id('address')); ?>">
		<?php esc_html_e('Address:', 'wooland'); ?>
	</label>
	<textarea id="<?php echo esc_attr($this->get_field_id('address')); ?>" class='widefat' name='<?php echo esc_attr($this->get_field_name('address')); ?>' rows="5" cols="5">
				<?php echo esc_textarea($address); ?>
			</textarea>
</p>
<p>
	<label for="<?php echo esc_attr($this->get_field_id('phone')); ?>">
		<?php esc_html_e('Phone: ', 'wooland'); ?>
	</label>
	<input class="widefat" id="<?php echo esc_attr($this->get_field_id('phone')); ?>" name="<?php echo esc_attr($this->get_field_name('phone')); ?>" type="text" value="<?php echo esc_attr($phone); ?>" />
</p>
<p>
	<label for="<?php echo esc_attr($this->get_field_id('email')); ?>">
		<?php esc_html_e('Email: ', 'wooland'); ?>
	</label>
	<input class="widefat" id="<?php echo esc_attr($this->get_field_id('email')); ?>" name="<?php echo esc_attr($this->get_field_name('email')); ?>" type="text" value="<?php echo esc_attr($email); ?>" />
</p>
<?php 
	}
}

 
/*-----pages widget for footer------------------------------------------------------    */
 class wooland_wow_themes_Pages extends WP_Widget
{
 function __construct()
 {
  parent::__construct( /* Base ID */'wooland_wow_themes_Pages', /* Name */esc_html__('wooland Pages ','wooland'), array(      'description' => esc_html__('Pages widget ', 'wooland' )) );
 }
 
 /* @see WP_Widget::widget */
    
  function widget($args, $instance)
  {
     extract( $args );
  echo balanceTags($before_widget);
  $title = apply_filters( 'widget_title', $instance['title'] );
?>
 <div class="footer_wid">
  	<h3><?php echo balanceTags($before_title . $title . $after_title); ?></h3>
  	<div class="footer_wid_lists">
		<ul id="footer_wid_list">
 			<?php
  				foreach($instance['pages'] as $pag):
 			?>
  			<li>
  				<a class="black-6c" href="<?php echo get_permalink( $pag);  ?>">
   					<?php echo get_the_title( $pag);   ?>
  				</a>
  			</li>
  		
 	<?php
  		endforeach;
 	?>
 </ul>
 </div>
</div> 
<?php echo balanceTags($after_widget);
  
   
 }
 /* @see WP_Widget::update */
 function update($new_instance, $old_instance)
 {
  $instance = $old_instance;
  $instance['title'] = $new_instance['title'];
  $instance['pages'] = $new_instance['pages'];

  
  return $instance;
 }
 
  function form($instance)
 { 
  $title = ( $instance ) ? esc_attr($instance['title']) : '';
  $pages = ( $instance ) ? $instance['pages'] : ''; //print_r($pages);
 
  ?>

<p>
 <label for="<?php echo esc_attr($this->get_field_id('title')); ?>">
  <?php esc_html_e('Title:', 'wooland'); ?>
 </label>
 <input class="widefat" id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
</p>
  

<p>
 <label for="<?php echo esc_attr($this->get_field_id('pages')); ?>">
  <?php esc_html_e('Choose Pages: ', 'wooland'); ?>
 </label>

 <?php wooland_get_pages(array('id'=>$this->get_field_id('pages'), 'name'=>$this->get_field_name('pages'), 'selected'=>$pages, 'multiple'=>1)); ?>
</p>

  <?php 
 }
}



/** mail chimp wooland */
class wooland_wow_themes_NewsLetter extends WP_Widget
{
	/** constructor */
	function __construct()
	{
		parent::__construct( /* Base ID */'wooland_wow_themes_NewsLetter', /* Name */__('wooland News Letter','wooland'), array( 'description' => esc_html__('News Letter', 'wooland' )) );
	}

	/** @see WP_Widget::widget */
	function widget($args, $instance)
	{
		extract( $args );
		//$title = apply_filters( 'widget_title', $instance['title'] );
		
		echo wp_kses_post($before_widget);
		?>
		
			<div class="footer_wid">
				 <h3><?php echo esc_attr( $instance['title'] ); ?></h3>
				<p><?php echo esc_attr( $instance['text'] ); ?></p>
				<div class="footer_email_input">
						<?php echo do_shortcode('[mc4wp_form id=" '.esc_attr( $instance['mailchimps_forms'] ) .' "]'); ?>
				</div>
			</div>
		
		<?php
		
		echo wp_kses_post($after_widget);
	}
	
	
	/** @see WP_Widget::update */
	function update($new_instance, $old_instance)
	{
		$instance = $old_instance;

		$instance['title'] = strip_tags($new_instance['title']);
		$instance['text'] = $new_instance['text'];
		$instance['mailchimps_forms'] = $new_instance['mailchimps_forms'];

		return $instance;
	}

	/** @see WP_Widget::form */
	function form($instance)
	{
		$title = ($instance) ? esc_attr($instance['title']) : esc_html__('Newsletter', 'wooland');
		$text = ( $instance ) ? esc_attr($instance['text']) : 'Sign up to hear and get our daily new update via email.';
		$mailchimps_forms = ($instance) ? esc_attr($instance['mailchimps_forms']) : '';
		?>
        
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('title')); ?>"><?php esc_html_e('Title:', 'wooland'); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('text')); ?>"><?php esc_html_e('Text:', 'wooland'); ?></label>
            <textarea class="widefat" id="<?php echo esc_attr($this->get_field_id('text')); ?>" name="<?php echo esc_attr($this->get_field_name('text')); ?>"><?php echo wp_kses_post($text); ?></textarea>
        </p>
		<p>
			 <label for="icons">
			  <?php esc_html_e('Choose Mailchimp Form:', 'wooland'); ?>
			 </label>
			 <select class="widefat" name="<?php echo esc_attr($this->get_field_name('mailchimps_forms')); ?>">
			  <option value=""><?php esc_html_e( 'Choose Mailchimp Form', 'wooland' );  ?></option>
			  <?php
			   $mailchimp_form  = mailchimp_forms();
			   
			   foreach ($mailchimp_form as $key => $value):
			  
		
			    $selected = ( $key == $mailchimps_forms ) ? ' selected="selected"' : '';?>
			   <option value="<?php echo esc_attr($key);  ?>"<?php echo balancetags($selected);?>><?php echo balanceTags($value);  ?></option>
			  <?php
			   endforeach;
			  ?>
			 </select>
</p>



              
		<?php 
	}
}





///sidebar widgets--------------------------------------------------/
class wooland_wow_themes_Recent_Posts extends WP_Widget
{
	/** constructor */
	function __construct()
	{
		parent::__construct( /* Base ID */'wooland_wow_themes_Recent_Posts', /* Name */esc_html__('wooland Recent Posts ','wooland'), array( 'description' => esc_html__('New items with images', 'wooland' )) );
	}
	
	/** @see WP_Widget::widget */
	function widget($args, $instance)
	{
		extract( $args );
		$title = apply_filters( 'widget_title', $instance['title'] );
		echo balanceTags($before_widget);
		echo balanceTags($before_title.$title.$after_title);
		
		$query_string = 'posts_per_page='.$instance['number'].'&post_type=post';
		if( $instance['cat'] ) $query_string .= '&cat='.$instance['cat'];
		$query = new WP_Query( $query_string ); 
	
		$this->posts($query);
		wp_reset_postdata();
		
		echo balanceTags($after_widget);
	}
 
	/** @see WP_Widget::update */
	function update($new_instance, $old_instance)
	{
		$instance = $old_instance;
		
		$instance['title'] = $new_instance['title'];
		$instance['number'] = $new_instance['number'];
		$instance['cat'] = $new_instance['cat'];
		return $instance;
	}
	/** @see WP_Widget::form */
	function form($instance)
	{
		$title = ( $instance ) ? esc_attr($instance['title']) : esc_html__('Recent Posts', 'wooland');
		$number = ( $instance ) ? esc_attr($instance['number']) : 3;
		$cat = ( $instance ) ? esc_attr($instance['cat']) : '';	
		?>
		<p>
			<label for="<?php echo esc_attr($this->get_field_id('title')); ?>">
				<?php esc_html_e('Title: ', 'wooland'); ?>
			</label>
			<input class="widefat" id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text" value="<?php echo esc_attr($title); ?>" />
		</p>
		<p>
			<label for="<?php echo esc_attr($this->get_field_id('number')); ?>">
				<?php esc_html_e('No. of Posts:', 'wooland'); ?>
			</label>
			<input class="widefat" id="<?php echo esc_attr($this->get_field_id('number')); ?>" name="<?php echo esc_attr($this->get_field_name('number')); ?>" type="text" value="<?php echo esc_attr($number); ?>" />
		</p>
		<p>
			<label for="<?php echo esc_attr($this->get_field_id('cat')); ?>">
				<?php esc_html_e('Category', 'wooland'); ?>
			</label>
			<?php wp_dropdown_categories( array('show_option_all'=>esc_html__('All Categories', 'wooland'), 'selected'=>$cat, 'class'=>'widefat', 'name'=>$this->get_field_name('cat')) ); ?>
		</p>
		<?php 
	}
	
	function posts($query)
	{
		if( $query->have_posts() ):?>
		
		<?php $count = 0; ?>
		

			<div class="recent_post_content">
				<?php while( $query->have_posts() ): $query->the_post(); ?>
					<div class="single_recent_post">
						<div class="recent_post_img"> 
							<a href="<?php the_permalink();?>">
								<?php the_post_thumbnail('wooland_wow_themes_70x65');?>
							</a> 
						</div>
						<div class="recent_post_text">
							<h4><a href="<?php the_permalink(); ?>"><?php the_title();?></a></h4>
							<div class="recent_post_icon"><i class="fa fa-calendar-o"></i></div>
							<div class="recent_post_date">
								<span><?php echo get_the_date('M d, Y');?></span>
							</div>
					
						</div>
					</div>
				<?php endwhile;?>
			</div>


		<?php endif;
    
    }
}


class wooland_wow_themes_Brands extends WP_Widget
{
	function __construct()
	{
		parent::__construct( /* Base ID */'wooland_wow_themes_Brands', /* Name */esc_html__('wooland Brands','wooland'), array(

			'description' => esc_html__('Brands widget ', 'wooland' )) );
	}
	
	/** @see WP_Widget::widget */
    
	 function widget($args, $instance)
	 {
	    extract( $args );
		echo balanceTags($before_widget);
		
?>
<?php
    $options = wooland_WSH()->option();

?>
         
                           
               <div class="b_cat_heading">
									<h3><?php echo balanceTags($instance['title']);?></h3>
								</div>
               <div class="b_cat_contents">
               		<ul> 
            			<?php wooland_wow_themes_get_brands(); ?>
            		</ul>
            	</div>	
           
 
<?php echo balanceTags($after_widget);
		
		 
	}
	/** @see WP_Widget::update */
	function update($new_instance, $old_instance)
	{
		$instance = $old_instance;
		$instance['title'] = $new_instance['title'];
	
	
	
		return $instance;
	}
	
	 function form($instance)
	{	
		$title = ( $instance ) ? esc_attr($instance['title']) : '';
		
		?>

		
<p>
	<label for="<?php echo esc_attr($this->get_field_id('title')); ?>">
		<?php esc_html_e('Title:', 'wooland'); ?>
	</label>
	<input class="widefat" id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
</p>

         

<?php 
	}
} 








	
			
