<?php
class wooland_Enqueue
{
	
	function __construct()
	{
		add_action( 'wp_enqueue_scripts', array( $this, 'sh_enqueue_scripts' ) );
		add_action( 'wp_head', array( $this, 'wp_head' ) );
		add_action( 'wp_footer', array( $this, 'wp_footer' ) );
		
	}


	function sh_enqueue_scripts()
	{
		global $post;
		$options = wooland_WSH()->option();
		$rtl = wooland_wow_sh_set($options,'rtl');
		$color = wooland_wow_sh_set($options, 'custom_color_scheme', '#fb724e');
		$color = str_replace('#', '', $color);

		$protocol = is_ssl() ? 'https' : 'http';
		$styles = array(

						
						 'wow_themes_google_fonts' => wooland_wow_themes_fonts_url(),
						 'font-awesome'	=> 'css/font-awesome.css',
						 'bootstrap'	=> 'css/bootstrap.css',
						 'bootstrap-select'	=> 'css/bootstrap-select.min.css',
						 'jquery-ui'	=> 'css/jquery-ui.css',
						 'glasscase'	=> 'css/glasscase.css',
						 'glasscase-min'	=> 'css/glasscase.minf195.css',
						 'owl-carousel'	=> 'css/owl.carousel.css',
						 'hover-effect'	=> 'css/hover-effect.css',
						 'woocommerce'	=> 'css/woocommerce.css',
						 'css-style'	=> 'css/style.css',
						 'main-style'	=> 'style.css',
						 'responsive'	=> 'css/responsive.css',

					   );
		
		//$styles = $this->custom_fonts($styles); //Load google fonts that user choose from theme options
		
		if ($rtl){
		   $styles['rtl-style'] = 'css/rtl.css';
		}

		foreach( $styles as $name => $style )
		{

			if(strstr($style, 'http') || strstr($style, 'https') || strstr($style, '//fonts.googleapis.com') ) 
			{
				wp_enqueue_style( $name, $style);
			}

			else wp_enqueue_style( $name, wooland_WOW_THEMES_URL.$style);
		}

		$scripts = array( 
						  	'bootstrap'				=> 'js/bootstrap.min.js',
						  	'owl_carousel'  		=> 'js/owl.carousel.min.js',
						    
						    'modernizer'	        => 'js/modernizr-2.6.2.min.js',
						    'glasscase'	        => 'js/jquery.glasscase.minf195.js',
						    'ie-opacity-polyfill'	=> 'js/ie-opacity-polyfill.js',
						    'jquery-dropdown-boxes' => 'js/jquery.dropdown-boxes.js',
						    'main-scripts'	        => 'js/main.js',
						     'maps.googleapis'	        =>$protocol.'://maps.googleapis.com/maps/api/js?key=AIzaSyB1Xb7_gmvBsbO9Kqnx3sxYBZEaeTZFuRI');





						 
		foreach( $scripts as $name => $js )
		{

			if(strstr($js, 'http') || strstr($js, 'https') || strstr($js, '//fonts.googleapis.com') ) 
			{
				wp_register_script( $name, $js, '', '', true);
			}

			else wp_register_script( $name, wooland_WOW_THEMES_URL.$js, '', '', true);
		}
		
		wp_enqueue_script( array( 'jquery', 'modernizer', 'bootstrap', 'glasscase', 'main-scripts', 'owl_carousel', 'ie-opacity-polyfill', 'jquery-dropdown-boxes'));

		if( is_singular() ) wp_enqueue_script('comment-reply');

	}
	
	function wp_head()
	{
		$options = wooland_WSH()->option();

		echo '<script type="text/javascript"> if( ajaxurl === undefined ) var ajaxurl = "'.admin_url('admin-ajax.php').'";</script>';?>
		<style type="text/css">
		<?php
			
			if( wooland_wow_themes_set( $options, 'body_custom_font' ) )
			echo wooland_wow_themes_font_settings( array( 'body_font_family' => 'font-family', 'body_font_color' => 'color' ), 'body, p { ', ' }' );
			
			if( wooland_wow_themes_set( $options, 'use_custom_font' ) ) {
				
				echo wooland_wow_themes_font_settings( array( 'h1_font_family' => 'font-family', 'h1_font_color' => 'color' ), 'h1 { ', ' }' );
				echo wooland_wow_themes_font_settings( array( 'h2_font_family' => 'font-family', 'h2_font_color' => 'color'  ), 'h2 { ', ' }' );
				echo wooland_wow_themes_font_settings( array( 'h3_font_family' => 'font-family', 'h3_font_color' => 'color'  ), 'h3 { ', ' }' );
				echo wooland_wow_themes_font_settings( array( 'h4_font_family' => 'font-family', 'h4_font_color' => 'color'  ), 'h4 { ', ' }' );
				echo wooland_wow_themes_font_settings( array( 'h5_font_family' => 'font-family', 'h5_font_color' => 'color'  ), 'h5 { ', ' }' );
				echo wooland_wow_themes_font_settings( array( 'h6_font_family' => 'font-family', 'h6_font_color' => 'color'  ), 'h6 { ', ' }' );
			}
		?>
			<?php if( $banner_image = wooland_wow_sh_set( $options, 'subpages_banner' ) ): ?>
				.info-section-parallax-path {
					background: url("<?php echo esc_url($banner_image); ?>") repeat fixed center top rgba(0, 0, 0, 0);
				}
			<?php endif; ?>
		</style>
		<?php 

		$custom_css = wooland_wow_themes_set($options , 'custom_css');
		
	}
	
	function wp_footer()

	{

		$theme_options = wooland_WSH()->option();
		
		if( wooland_wow_themes_set( $theme_options, 'footer_analytics' ) ): ?>
			<script type="text/javascript">
                <?php echo wooland_wow_sh_set( $theme_options, 'footer_analytics' );?>
            </script>
        <?php endif;

	}

	function custom_fonts( $styles )
	{
		$opt = wooland_WSH()->option();
		$protocol = ( is_ssl() ) ? 'https' : 'http';
		$font = array();
		//$font_options = array('h1_font_family', 'h2_font_family', 'h3_font_family');
		
		if( wooland_wow_themes_set( $opt, 'use_custom_font' ) ){
			
			if( $h1 = wooland_wow_themes_set( $opt, 'h1_font_family' ) ) $font[$h1] = urlencode( $h1 ).':400,300,600,700,800';
			if( $h2 = wooland_wow_themes_set( $opt, 'h2_font_family' ) ) $font[$h2] = urlencode( $h2 ).':400,300,600,700,800';
			if( $h3 = wooland_wow_themes_set( $opt, 'h3_font_family' ) ) $font[$h3] = urlencode( $h3 ).':400,300,600,700,800';
		}
		
		if( wooland_wow_themes_set( $opt, 'body_custom_font' ) ){
			if( $body = wooland_wow_themes_set( $opt, 'body_font_family' ) ) $font[$body] = urlencode( $body ).':400,300,600,700,800';
		}
		
		if( $font ) $styles['sh_google_custom_font'] = $protocol.'://fonts.googleapis.com/css?family='.implode('|', $font);
		
		return $styles;
	}
	
	

}