<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class wooland_Custom_menu_field extends Walker_Nav_Menu_Edit {
	
	
	function start_el(&$output, $item, $depth = 0, $args = array(), $id = 0) {
           
		// append next menu element to $output
		parent::start_el($output, $item, $depth, $args);
		// now let's add a custom form field
		
		if ( ! class_exists( 'phpQuery') ) {
			// load phpQuery at the last moment, to minimise chance of conflicts (ok, it's probably a bit too defensive)
			require_once wooland_WOW_THEMES_ROOT.'includes/helpers/phpQuery-onefile.php';
		}
		libxml_use_internal_errors(true);
		$_doc = phpQuery::newDocumentHTML( $output );
		$_li = phpQuery::pq( 'li.menu-item:last' );
		// ":last" is important, because $output will contain all the menu elements before current element
		
		// if the last <li>'s id attribute doesn't match $item->ID something is very wrong, don't do anything
		// just a safety, should never happen...
		$menu_item_id = str_replace( 'menu-item-', '', $_li->attr( 'id' ) );
		
		if( $menu_item_id != $item->ID ) {
			return;
		}
		
		// fetch previously saved meta for the post (menu_item is just a post type)
		$mega_val = esc_attr( get_post_meta( $menu_item_id, 'sh_menu_icon_field', TRUE ) );
                
                //echo '<pre>';print_r($mega_val);exit;
                
               
		// by means of phpQuery magic, inject a new input field
		if($depth == 0){
                       
			$_li->find( '.menu-item-actions.submitbox' )
			->before(  '<p class=" description-wide"><label>'.__('Menu Icon Image URL', 'wooland').'</label><br /><input class="widefat" type="text" value="'.esc_attr($mega_val).'" name="sh_menu_icon_field_'.$menu_item_id.'" /></p><p class="description-wide">'.__('Please enter menu icon image link here.', 'wooland').'</p>' );
		}
		
		// swap the $output
		$output = $_doc->html();
		
	}

}



new wooland_Custom_menu_field();
