<?php

add_action('after_setup_theme', 'wooland_wow_themes_theme_setup');

function wooland_wow_themes_theme_setup()
{
	
	global $wp_version;

	define( 'CS_ACTIVE_SHORTCODE',  false ); // default true
	define( 'CS_ACTIVE_CUSTOMIZE',  false ); // default true

	if(!defined('wooland_WOW_THEMES_VERSION')) define('wooland_WOW_THEMES_VERSION', '1.0');
	if( !defined( 'wooland_WOW_THEMES_NAME' ) ) define( 'wooland_WOW_THEMES_NAME', 'wp_wooland' );
	if( !defined( 'wooland_WOW_THEMES_ROOT' ) ) define('wooland_WOW_THEMES_ROOT', get_template_directory().'/');
	if( !defined( 'wooland_WOW_THEMES_URL' ) ) define('wooland_WOW_THEMES_URL', get_template_directory_uri().'/');	
	include_once( get_template_directory().'/includes/loader.php' );
	
	
	load_theme_textdomain('wooland', get_template_directory() . '/languages');
	add_editor_style(array('style.css'));

	//ADD THUMBNAIL SUPPORT
	add_theme_support('post-thumbnails');
	add_theme_support( 'post-formats', array( 'gallery', 'image', 'quote', 'video', 'audio' ) );
	add_theme_support('menus'); //Add menu support
	add_theme_support('automatic-feed-links'); //Enables post and comment RSS feed links to head.
	add_theme_support('widgets'); //Add widgets and sidebar support
	add_theme_support( "title-tag" );
	//add_theme_support( "custom-background");
	add_theme_support('woocommerce');
	
	// Header logo settings
	$header_args = array(
            'flex-width'    => true,
            'width'         => 980,
            'flex-height'    => true,
            'height'        => 200,
            'default-image' => get_template_directory_uri() . '/images/logo.png',
	);
	add_theme_support( 'custom-header', $header_args );

    /*
     * Switch default core markup for search form, comment form, and comments
     * to output valid HTML5.
     */
    add_theme_support('html5', array(
        'search-form', 'comment-form', 'comment-list', 'gallery', 'caption'
    ));


    // This theme uses its own gallery styles.
    add_filter('use_default_gallery_style', '__return_false');

	
	/** Register wp_nav_menus */
	if(function_exists('register_nav_menu'))
	{
		register_nav_menus(
			array(
				/** Register Main Menu location header */
				'main_menu' => esc_html__('Main Menu', 'wooland'),
				'sidebar_menu' => esc_html__('Sidebar Menu', 'wooland'),
				'mobile_menu' => esc_html__('Mobile Menu', 'wooland'),
			)
		);
	}
	if ( ! isset( $content_width ) ) $content_width = 960;
	
	add_image_size( 'wooland_wow_themes_214x142', 214, 142, true );
	add_image_size( 'wooland_wow_themes_244x370', 244, 270, true );
	add_image_size( 'wooland_wow_themes_360x216', 360, 216, true );
	add_image_size( 'wooland_wow_themes_492x768', 492, 768, true );
	add_image_size( 'wooland_wow_themes_848x326', 848, 326, true );
	add_image_size( 'wooland_wow_themes_70x65', 70, 65, true );
	add_image_size( 'wooland_wow_themes_244x370', 244, 370, true );
	

}


function wooland_wow_themes_widget_init()
{
	global $wp_registered_sidebars;
	$theme_options = wooland_WSH()->option();
	//print_r($theme_options);exit;
	if( class_exists( 'wooland_wow_themes_About_Us' ) )register_widget( 'wooland_wow_themes_About_Us' );
	if( class_exists( 'wooland_wow_themes_ContactUs' ) )register_widget( 'wooland_wow_themes_ContactUs' );
	if( class_exists( 'wooland_wow_themes_NewsLetter' ) ) register_widget( 'wooland_wow_themes_NewsLetter' );
	if( class_exists( 'wooland_wow_themes_Pages' ) ) register_widget( 'wooland_wow_themes_Pages' );
	if( class_exists( 'wooland_wow_themes_Recent_Posts' ) ) register_widget( 'wooland_wow_themes_Recent_Posts' );
	if( class_exists( 'wooland_wow_themes_Brands' ) ) register_widget( 'wooland_wow_themes_Brands' );


	register_sidebar(array(
	  'name' => esc_html__( 'Default Sidebar', 'wooland' ),
	  'id' => 'default-sidebar',
	  'description' => esc_html__( 'Widgets in this area will be shown on the right-hand side.', 'wooland' ),
	  'class'=>'',
	
	));
	
	register_sidebar(array(
	  'name' => esc_html__( 'Blog Sidebar', 'wooland' ),
	  'id' => 'blog-sidebar',
	  'description' => esc_html__( 'Widgets in this area will be shown on the Blog Page.', 'wooland' ),
	  'class'=>'',
	  'before_widget'=>'<div id="%1$s" class="widget home_sidebar %2$s blog_categories">',
	  'after_widget'=>'</div>',
	  'before_title' => '<div class="b_cat_heading"><h3>',
	  'after_title' => '</h3></div>'
	));

		register_sidebar(array(
	  'name' => esc_html__( 'Shop Sidebar', 'wooland' ),
	  'id' => 'shop-sidebar',
	  'description' => esc_html__( 'Widgets in this area will be shown on the Shop Page.', 'wooland' ),
	  'class'=>'',
	  'before_widget'=>'<div id="%1$s" class="widget home_sidebar %2$s blog_categories">',
	  'after_widget'=>'</div>',
	  'before_title' => '<div class="b_cat_heading"><h3>',
	  'after_title' => '</h3></div>'
	));
	
	
	register_sidebar(array(
	  'name' => esc_html__( 'Footer Sidebar Column', 'wooland' ),
	  'id' => 'footer-sidebar-1',
	  'description' => esc_html__( 'Widgets in this area will be shown on the footer Column one.', 'wooland' ),
	  'class'=>'',
	  'before_widget'=>'<div id="%1$s" class="col-md-3 col-sm-3 col-xs-12 widget %2$s">',
	  'after_widget'=>'</div>',
	  'before_title' => '',
	  'after_title' => ''
	));
		register_sidebar(array(
	  'name' => esc_html__( 'currency sidebar', 'wooland' ),
	  'id' => 'currency-sidebar',
	  'description' => esc_html__( 'Widgets in this area will be shown on the currency sidebar.', 'wooland' ),
	  'class'=>'',
	  'before_widget'=>'<div id="%1$s" class="col-md-3 widget %2$s">',
	  'after_widget'=>'</div>',
	  'before_title' => '',
	  'after_title' => ''
	));
	
	
	
	
	if( !is_object( wooland_WSH() )  )  return;
	$sidebars = wooland_wow_themes_set( $theme_options, 'dynamic_sidebar' ); 
	foreach( array_filter((array)$sidebars) as $sidebar)
	{
		if(wooland_wow_themes_set($sidebar , 'topcopy')) continue ;
		
		$name = wooland_wow_themes_set( $sidebar, 'sidebar_name' );
		if( ! $name ) continue;
		$slug = wooland_wow_themes_slug( $name ) ;
		
		register_sidebar( array(
			'name' => $name,
			'id' =>  $slug ,
		    'before_widget' => '<div class="widget">',
	        'after_widget' => "</div>",
	        'before_title' => '<div class="widget-title"><h3><span class="divider"></span>',
	        'after_title' => '</h3></div>',
		) );		
	}
	
	update_option('wp_registered_sidebars' , $wp_registered_sidebars) ;
}

add_action( 'widgets_init', 'wooland_wow_themes_widget_init' );



if( function_exists('vc_map')) {
	//vc_set_shortcodes_templates_dir( get_template_directory().'/includes/modules/shortcodes' );
	//vc_disable_frontend();
	
	add_action( 'vc_before_init', 'wooland_wow_themes_prefix_vcSetAsTheme' );
	function wooland_wow_themes_prefix_vcSetAsTheme() {
	    vc_set_as_theme(true);
	}
}


add_filter('add_to_cart_fragments', 'sh_woo_add_to_cart_ajax');
function sh_woo_add_to_cart_ajax( $fragments ) {
    
	global $woocommerce;
    
	
	ob_start(); ?>


	<div class="head_cart_text_top">
		<a href="<?php echo esc_url( $woocommerce->cart->get_cart_url() ); ?>" title="<?php esc_html_e('View Cart', 'wooland'); ?>"><p> <?php esc_html_e('SHOPPING CART', 'wooland'); ?>   (<?php echo balanceTags( $woocommerce->cart->cart_contents_count ); ?>)</p></a>
	</div>


	<?php $fragments['div.head_cart_text_top'] = ob_get_clean();	
	
	
	return $fragments;
}

add_filter( 'woocommerce_enqueue_styles', '__return_false' );

if ( ! function_exists( 'wooland_wow_themes_fonts_url' ) ) :
/**
 * Register Google fonts for Twenty Fifteen.
 *
 * @since Twenty Fifteen 1.0
 *
 * @return string Google fonts URL for the theme.
 */
function wooland_wow_themes_fonts_url() {
	$fonts_url = '';
	$fonts     = array();
	$subsets   = 'latin,latin-ext';

	
	$fonts[] = 'Exo:400,500,600,700';
	$fonts[] = 'Oxygen:400,300,700';
	$fonts[] = 'Lato:400,300,700,100';
	$fonts[] = 'Roboto:400,100,300,500,700';
	$fonts[] = 'Cabin:400,700,500italic,600';
	$fonts[] = 'Libre+Baskerville:400,400italic,700';
	$fonts[] = 'Karla:400,400italic,700,700italic';

	$opt = wooland_WSH()->option();
	
	if( wooland_wow_sh_set( $opt, 'use_custom_font' ) ){
		
		if( $h1 = wooland_wow_sh_set( $opt, 'h1_font_family' ) ) $fonts[$h1] = urlencode( $h1 ).':400,300,600,700,800';
		if( $h2 = wooland_wow_sh_set( $opt, 'h2_font_family' ) ) $fonts[$h2] = urlencode( $h2 ).':400,300,600,700,800';
		if( $h3 = wooland_wow_sh_set( $opt, 'h3_font_family' ) ) $fonts[$h3] = urlencode( $h3 ).':400,300,600,700,800';
	}
	
	if( wooland_wow_sh_set( $opt, 'body_custom_font' ) ){
		if( $body = wooland_wow_sh_set( $opt, 'body_font_family' ) ) $fonts[$body] = urlencode( $body ).':400,300,600,700,800';
	}
	

	if ( $fonts ) {
		$fonts_url = add_query_arg( array(
			'family' => urlencode( implode( '|', $fonts ) ),
			'subset' => urlencode( $subsets ),
		), '//fonts.googleapis.com/css' );
	}

	return $fonts_url;
}
endif;

