<?php
/**
 * The template for displaying search results pages.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#search-result
 *
 * @package weddingvendor
 */

get_header(); ?>
<div class="main-container">
    <div class="container">
        <div class="row">
        	<div class="col-md-8 content-left">
			<?php
            if ( have_posts() ) : ?>
        
                <header class="page-header">
                    <h1 class="page-title"><?php printf( esc_html__( 'Search Results for: %s', 'weddingvendor' ), '<span>' . get_search_query() . '</span>' ); ?></h1>
                </header><!-- .page-header -->
        
                <?php
                /* Start the Loop */
                while ( have_posts() ) : the_post();
        
                    /**
                     * Run the loop for the search to output the results.
                     * If you want to overload this in a child theme then include a file
                     * called content-search.php and that will be used instead.
                     */
                    get_template_part( 'template-parts/content', 'search' );
        
                endwhile;
        
				wedding_pagination(); 
        
            else :
        
                get_template_part( 'template-parts/content', 'none' );
        
            endif; ?>
            </div>
            <div class="col-md-4">
                <div class="left-sidebar"><!--sidebar-->
                    <?php if ( is_active_sidebar( 'sidebar-1' ) ) { ?>
                        <?php dynamic_sidebar( 'sidebar-1' ); ?>
                    <?php } ?>          
                </div>
          		<!--/.sidebar--> 
        	</div>
        </div>
    </div>
</div>
<?php
get_footer();
?>
