<?php
/**
 * The template for displaying archive pages.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package weddingvendor
 */

get_header(); ?>
<div class="main-container">
  <div class="container">
    <div class="row">
     <div class="col-md-8 content-left"><!-- content left -->
		<?php
		if ( have_posts() ) : ?>

			<header class="page-header">
				<?php
					the_archive_title( '<h1 class="page-title">', '</h1>' );
					the_archive_description( '<div class="taxonomy-description">', '</div>' );
				?>
			</header><!-- .page-header -->

			<?php
			/* Start the Loop */
			while ( have_posts() ) : the_post();

				/*
				 * Include the Post-Format-specific template for the content.
				 * If you want to override this in a child theme, then include a file
				 * called content-___.php (where ___ is the Post Format name) and that will be used instead.
				 */
				get_template_part( 'template-parts/content', get_post_format() );

			endwhile;

			wedding_pagination();

		else :

			get_template_part( 'template-parts/content', 'none' );

		endif; ?>
	    </div>
          <!-- /.content left -->
       <div class="col-md-4 right-sidebar"><!-- right sidebar -->
			<?php if ( is_active_sidebar( 'sidebar-1' ) ) { ?>
                <?php dynamic_sidebar( 'sidebar-1' ); ?>
            <?php } ?>         
       </div>
      <!-- /.right sidebar -->  
    </div>
  </div>		
</div><!-- /.main-container -->
<?php
get_footer();
