<?php
/**
 * Related Products
 *
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     3.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

global $product, $woocommerce_loop, $venedor_settings;

if ( empty( $product ) || ! $product->exists() ) {
    return;
}

$related = wc_get_related_products( $product->get_id(), $venedor_settings['product-related-count'] );

if ( sizeof( $related ) === 0 ) return;

$args = apply_filters('woocommerce_related_products_args', array(
	'post_type'				=> 'product',
	'ignore_sticky_posts'	=> 1,
	'no_found_rows' 		=> 1,
	'posts_per_page' 		=> $venedor_settings['product-related-count'],
	'orderby' 				=> $orderby,
	'post__in' 				=> $related,
	'post__not_in'			=> array($product->get_id())
) );

$products = new WP_Query( $args );

$woocommerce_loop['columns'] 	= $columns;

global $venedor_product_slider;

$venedor_product_slider = true;

if ( $products->have_posts() ) : ?>

	<div class="related products product-slider">

		<h2 class="entry-title"><?php _e( 'Related Products', 'woocommerce' ); ?></h2>

		<?php woocommerce_product_loop_start(); ?>

			<?php while ( $products->have_posts() ) : $products->the_post(); ?>

				<?php wc_get_template_part( 'content', 'product' ); ?>

			<?php endwhile; // end of the loop. ?>

		<?php woocommerce_product_loop_end(); ?>

	</div>

<?php endif;

$venedor_product_slider = false;

wp_reset_postdata();
