<?php
/**
 * Order tracking form
 *
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     3.2.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

global $post;

?>

<form action="<?php echo esc_url( get_permalink($post->ID) ); ?>" method="post" class="track_order">

	<p><?php _e( 'To track your order please enter your Order ID in the box below and press the "Track" button. This was given to you on your receipt and in the confirmation email you should have received.', 'venedor' ); ?></p>

	<p class="form-row form-row-first input-field"><label for="orderid"><span class="fa fa-link"></span><?php _e( 'Order ID', 'venedor' ); ?></label> <input class="input-text" type="text" name="orderid" id="orderid" value="<?php echo isset( $_REQUEST['orderid'] ) ? esc_attr( $_REQUEST['orderid'] ) : ''; ?>" placeholder="<?php esc_attr_e( 'Found in your order confirmation email.', 'venedor' ); ?>" /></p>
	<p class="form-row form-row-last input-field"><label for="order_email"><span class="fa fa-envelope"></span><?php _e( 'Billing Email', 'venedor' ); ?></label> <input class="input-text" type="text" name="order_email" id="order_email" value="<?php echo isset( $_REQUEST['order_email'] ) ? esc_attr( $_REQUEST['order_email'] ) : ''; ?>" placeholder="<?php esc_attr_e( 'Email you used during checkout.', 'venedor' ); ?>" /></p>
	<div class="clear"></div>

	<p class="form-row button-row"><input type="submit" class="button btn-lg" name="track" value="<?php esc_attr_e( 'Track', 'venedor' ); ?>" /></p>
	<?php wp_nonce_field( 'woocommerce-order_tracking' ); ?>

</form>