<?php
/**
 * Show error messages
 *
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     1.6.4
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

if ( ! $messages ){
	return;
}

?>
<div class="woocommerce-error alert alert-danger">
    <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
    <ul>
	    <?php foreach ( $messages as $message ) : ?>
			<?php $message = preg_replace("/<span[^>]+\>/i", "", html_entity_decode( $message )); ?>
		    <li><?php echo wp_kses_post( $message ); ?></li>
	    <?php endforeach; ?>
    </ul>
</div>