<?php
/**
 * Login Form
 *
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     3.2.0
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

?>

<?php wc_print_notices(); ?>

<?php do_action('woocommerce_before_customer_login_form'); ?>

<?php if ( get_option( 'woocommerce_enable_myaccount_registration' ) === 'yes' ) : ?>

<div class="u-columns row" id="customer_login">

	<div class="u-column1 col-sm-6">

<?php endif; ?>

		<h2><?php _e( 'Login', 'venedor' ); ?></h2>

		<form method="post" class="login">

			<?php do_action( 'woocommerce_login_form_start' ); ?>

			<p class="woocommerce-FormRow woocommerce-FormRow--wide form-row form-row-first input-field">
				<label for="username"><span class="fa fa-user"></span><?php _e( 'Username', 'venedor' ); ?> <span class="required">*</span></label>
				<input type="text" class="input-text" name="username" id="username" placeholder="<?php _e( 'Username or email', 'venedor' ); ?>" value="<?php if ( ! empty( $_POST['username'] ) ) echo esc_attr( $_POST['username'] ); ?>" />
			</p>
			<p class="woocommerce-FormRow woocommerce-FormRow--wide form-row form-row-last input-field">
				<label for="password"><span class="fa fa-lock"></span><?php _e( 'Password', 'venedor' ); ?> <span class="required">*</span></label>
				<input class="input-text" type="password" name="password" id="password" placeholder="<?php _e( 'Password', 'venedor' ); ?>" />
			</p>
			<div class="clear"></div>

			<p class="form-row button-row">
				<?php wp_nonce_field( 'woocommerce-login', 'woocommerce-login-nonce' ); ?>
				<input type="submit" class="button btn-lg" name="login" value="<?php esc_attr_e( 'Login', 'venedor' ); ?>" />
				<label for="rememberme" class="inline">
					<input name="rememberme" type="checkbox" id="rememberme" value="forever" /> <?php _e( 'Remember me', 'venedor' ); ?>
				</label>
			</p>
			<p class="lost_password">
				<a href="<?php echo esc_url( wp_lostpassword_url() ); ?>"><?php _e( 'Lost your password?', 'venedor' ); ?></a>
			</p>

			<?php do_action( 'woocommerce_login_form_end' ); ?>

		</form>

<?php if ( get_option( 'woocommerce_enable_myaccount_registration' ) === 'yes' ) : ?>

	</div>

	<div class="u-column1 col-sm-6">

		<h2><?php _e( 'Register', 'venedor' ); ?></h2>

		<form method="post" class="register">

			<?php do_action( 'woocommerce_register_form_start' ); ?>

			<?php if ( 'no' === get_option( 'woocommerce_registration_generate_username' ) ) : ?>

				<p class="woocommerce-FormRow woocommerce-FormRow--wide form-row form-row-first input-field">
					<label for="reg_username"><span class="fa fa-user"></span><?php _e( 'Username', 'venedor' ); ?> <span class="required">*</span></label>
					<input type="text" class="woocommerce-Input woocommerce-Input--text input-text" name="username" id="reg_username" value="<?php if (isset($_POST['username'])) echo esc_attr($_POST['username']); ?>" placeholder="<?php _e( 'Username', 'venedor' ); ?>" />
				</p>


			<?php endif; ?>

			<p class="woocommerce-FormRow woocommerce-FormRow--wide form-row form-row-last input-field">

				<label for="reg_email"><span class="fa fa-envelope"></span><?php _e( 'Email', 'venedor' ); ?> <span class="required">*</span></label>
				<input type="email" class="woocommerce-Input woocommerce-Input--text input-text" name="email" id="reg_email" value="<?php if (isset($_POST['email'])) echo esc_attr($_POST['email']); ?>" placeholder="<?php _e( 'Email', 'venedor' ); ?>" />
			</p>

			<div class="clear"></div>

            <?php if ( 'no' === get_option( 'woocommerce_registration_generate_password' ) ) : ?>
            
			    <p class="woocommerce-FormRow woocommerce-FormRow--wide form-row form-row-first input-field">
				    <label for="reg_password"><span class="fa fa-lock"></span><?php _e( 'Password', 'venedor' ); ?> <span class="required">*</span></label>
				    <input type="password" class="woocommerce-Input woocommerce-Input--text input-text" name="password" id="reg_password" />
			    </p>
                
            <?php endif; ?>
            
			<div class="clear"></div>
			
			<?php do_action( 'woocommerce_register_form' ); ?>
			<?php do_action( 'register_form' ); ?>

			<p class="woocommerce-FormRow form-row button-row">
				<?php wp_nonce_field( 'woocommerce-register', 'woocommerce-register-nonce' ); ?>
				<input type="submit" class="woocommerce-Button button btn-lg" name="register" value="<?php esc_attr_e( 'Register', 'venedor' ); ?>" />
			</p>

			<?php do_action( 'woocommerce_register_form_end' ); ?>

		</form>

	</div>

</div>
<?php endif; ?>

<?php do_action('woocommerce_after_customer_login_form'); ?>