<?php
/**
 * Checkout coupon form
 *
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     2.2
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

global $venedor_woo_version;

if ( ! (version_compare($venedor_woo_version, '2.5', '<') ? WC()->cart->coupons_enabled() : wc_coupons_enabled()) ) {
	return;
}

if ( ! WC()->cart->applied_coupons ) {
    $info_message = apply_filters( 'woocommerce_checkout_coupon_message', __( 'Have a coupon?', 'venedor' ) . ' <a href="#" class="showcoupon">' . __( 'Click here to enter your code', 'venedor' ) . '</a>' );
    wc_print_notice( $info_message, 'notice' );
}
?>

<form class="checkout_coupon" method="post" style="display:none">

	<p class="form-row form-row-first input-field">
        <label for="coupon_code"><span class="fa fa-cut"></span><?php _e( 'Coupon code', 'venedor' ); ?> <span class="required">*</span></label>
		<input type="text" name="coupon_code" class="input-text" placeholder="<?php esc_attr_e( 'Coupon code', 'venedor' ); ?>" id="coupon_code" value="" />
	</p>

	<p class="form-row button-row form-row-last">
		<input type="submit" class="button btn-lg" name="apply_coupon" value="<?php esc_attr_e( 'Apply Coupon', 'venedor' ); ?>" />
	</p>

	<div class="clear"></div>
</form>