<?php
add_action('widgets_init', 'venedor_flickr_load_widgets');

function venedor_flickr_load_widgets() {
	register_widget('Venedor_Flickr_Widget');
}

class Venedor_Flickr_Widget extends WP_Widget {
	
	function Venedor_Flickr_Widget() {
		$widget_ops = array('classname' => 'flickr', 'description' => __('The most recent photos from flickr.', 'venedor'));

		$control_ops = array('id_base' => 'flickr-widget');

        parent::__construct('flickr-widget', __('Venedor: Flickr', 'venedor'), $widget_ops, $control_ops);
	}
	
	function widget($args, $instance) {
		extract($args);

		$title = apply_filters('widget_title', $instance['title']);
		$user_id = $instance['user_id'];
        $photoset_id = $instance['photoset_id'];
		$number1 = $instance['number1'];
        $number2 = $instance['number2'];
        $popup = $instance['popup'];
		$api = $instance['api'];
		if(empty($api)) {
			$api = 'dd14978e9347319cdc672f3336cfdf9f';
		}
		
        if ( ( ($user_id && $number1) || ($photoset_id && $number2) ) && $api ) {
		    echo $before_widget;

		    if ($title) {
			    echo $before_title.$title.$after_title;
		    } ?>
		    <script type="text/javascript">
		    function jsonFlickrApi(rsp) {
			    if (rsp.stat != "ok"){
				    // If this executes, something broke!
				    return;
			    }

			    //variable "s" is going to contain 
			    //all the markup that is generated by the loop below
			    var s = "";

			    //this loop runs through every item and creates HTML 
                if (typeof rsp.photoset !== 'undefined') {
			        for (var i=0; i < rsp.photoset.photo.length; i++) {
				        photo = rsp.photoset.photo[ i ];

				        //notice that "t.jpg" is where you change the
				        //size of the image
				        t_url = "http://farm" + photo.farm + 
				        ".static.flickr.com/" + photo.server + "/" + 
				        photo.id + "_" + photo.secret + "_" + "s.jpg";

                        <?php if (!$popup) : ?>
				        p_url = "http://www.flickr.com/photos/" + 
				        rsp.photoset.owner + "/" + photo.id;
                        <?php else : ?>
                        p_url = "http://farm" + photo.farm +
                        ".static.flickr.com/" + photo.server + "/" +
                        photo.id + "_" + photo.secret + ".jpg";
                        <?php endif; ?>

				        s +=  '<div class="flickr-image"><a target="_blank" href="' + p_url + '">' + '<img alt="'+ 
				        photo.title + '"src="' + t_url + '"/>' + '</a></div>';
			        }
                }
                if (typeof rsp.photos !== 'undefined') {
                    for (var i=0; i < rsp.photos.photo.length; i++) {
                        photo = rsp.photos.photo[ i ];

                        //notice that "t.jpg" is where you change the
                        //size of the image
                        t_url = "http://farm" + photo.farm + 
                        ".static.flickr.com/" + photo.server + "/" + 
                        photo.id + "_" + photo.secret + "_" + "s.jpg";

                        <?php if (!$popup) : ?>
                        p_url = "http://www.flickr.com/photos/" + 
                        photo.owner + "/" + photo.id;
                        <?php else : ?>
                        p_url = "http://farm" + photo.farm +
                        ".static.flickr.com/" + photo.server + "/" +
                        photo.id + "_" + photo.secret + ".jpg";
                        <?php endif; ?>

                        s +=  '<div class="flickr-image"><a href="' + p_url + '">' + '<img alt="'+ 
                        photo.title + '"src="' + t_url + '"/>' + '</a></div>';
                    }
                }

                $flickr_box = jQuery('#<?php echo $args['widget_id'] ?> .flickr-box');
                $flickr_box.append(s);

                <?php if ($popup) : ?>
                var $links = $flickr_box.find('a');
                $links.unbind('click').click(function(event) {
                    var options = {index: $links.index(jQuery(this)), event: event};
                    blueimp.Gallery($links, options);
                });
                <?php endif; ?>
            }
            </script>
            <div class="flickr-box clearfix"></div>
            <?php if ($user_id && $number1) : ?>
                <script type="text/javascript" src="https://api.flickr.com/services/rest/?format=json&amp;method=flickr.photos.search&amp;user_id=<?php echo $user_id; ?>&amp;api_key=<?php echo $api; ?>&amp;media=photos&amp;per_page=<?php echo $number1; ?>&amp;privacy_filter=1"></script>
            <?php endif; ?>
            <?php if ($photoset_id && $number2) : ?>
                <script type="text/javascript" src="https://api.flickr.com/services/rest/?format=json&amp;method=flickr.photosets.getPhotos&amp;photoset_id=<?php echo $photoset_id; ?>&amp;api_key=<?php echo $api; ?>&amp;media=photos&amp;per_page=<?php echo $number2; ?>&amp;privacy_filter=1"></script>
            <?php endif; ?>
            <?php 
            echo $after_widget;
        }
	}
	
	function update($new_instance, $old_instance) {
		$instance = $old_instance;

		$instance['title'] = strip_tags($new_instance['title']);
		$instance['user_id'] = $new_instance['user_id'];
        $instance['photoset_id'] = $new_instance['photoset_id'];
		$instance['number1'] = $new_instance['number1'];
        $instance['number2'] = $new_instance['number2'];
        $instance['popup'] = $new_instance['popup'];
		$instance['api'] = $new_instance['api'];
		
		return $instance;
	}

	function form($instance) {
		$defaults = array('title' => __('Flickr', 'venedor'), 'user_id' => '', 'photoset_id' => '', 'number1' => 6, 'number2' => 6, 'api' => 'dd14978e9347319cdc672f3336cfdf9f', 'popup' => 'on');
		$instance = wp_parse_args((array) $instance, $defaults); ?>
		
		<p>
			<label for="<?php echo $this->get_field_id('title'); ?>"><?php echo __('Title', 'venedor') ?>:</label>
			<input class="widefat" style="width: 216px;" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" value="<?php echo $instance['title']; ?>" />
		</p>
		
		<p>
			<label for="<?php echo $this->get_field_id('user_id'); ?>"><?php echo __('Flickr User ID', 'venedor') ?>(<a href="http://idgettr.com/"><?php echo __('Get your flickr ID', 'venedor') ?></a>):</label>
			<input class="widefat" style="width: 216px;" id="<?php echo $this->get_field_id('user_id'); ?>" name="<?php echo $this->get_field_name('user_id'); ?>" value="<?php echo $instance['user_id']; ?>" />
		</p>
        
        <p>
			<label for="<?php echo $this->get_field_id('number1'); ?>"><?php echo __('Number of photos to show', 'venedor') ?>:</label>
			<input class="widefat" style="width: 30px;" id="<?php echo $this->get_field_id('number1'); ?>" name="<?php echo $this->get_field_name('number1'); ?>" value="<?php echo $instance['number1']; ?>" />
		</p>
        
        <p><?php echo __(' - OR - ', 'venedor') ?></p>
        
        <p>
            <label for="<?php echo $this->get_field_id('photoset_id'); ?>"><?php echo __('Flickr Photoset ID', 'venedor') ?>:</label>
            <input class="widefat" style="width: 216px;" id="<?php echo $this->get_field_id('photoset_id'); ?>" name="<?php echo $this->get_field_name('photoset_id'); ?>" value="<?php echo $instance['photoset_id']; ?>" />
        </p>

        <p>
            <label for="<?php echo $this->get_field_id('number2'); ?>"><?php echo __('Number of photos to show', 'venedor') ?>:</label>
            <input class="widefat" style="width: 30px;" id="<?php echo $this->get_field_id('number2'); ?>" name="<?php echo $this->get_field_name('number2'); ?>" value="<?php echo $instance['number2']; ?>" />
        </p>

        <p>
            <input class="checkbox" type="checkbox" <?php checked($instance['popup'], 'on'); ?> id="<?php echo $this->get_field_id('popup'); ?>" name="<?php echo $this->get_field_name('popup'); ?>" />
            <label for="<?php echo $this->get_field_id('popup'); ?>"><?php echo __('Show popup', 'venedor') ?></label>
        </p>

		<p>
			<label for="<?php echo $this->get_field_id('api'); ?>"><?php echo __('API key (Use default or get your own from <a href="http://www.flickr.com/services/apps/create/apply">Flickr APP Garden</a>)', 'venedor') ?>:</label>
			<input class="widefat" id="<?php echo $this->get_field_id('api'); ?>" name="<?php echo $this->get_field_name('api'); ?>" value="<?php echo $instance['api']; ?>" />
			<small><?php echo __('Default key is', 'venedor') ?>: dd14978e9347319cdc672f3336cfdf9f</small>
		</p>
		
	<?php
	}
}
?>