<?php

/**
 * This theme requires WordPress 5.3 or later.
 */
if ( version_compare( $GLOBALS['wp_version'], '5.3', '<' ) ) {
	require get_template_directory() . '/inc/back-compat.php';
}

/**
 * Sets up theme defaults and registers support for various WordPress features
 */
function themerain_setup() {
	load_theme_textdomain( 'themerain', get_template_directory() . '/languages' );
	add_theme_support( 'automatic-feed-links' );
	add_theme_support( 'title-tag' );
	register_nav_menu( 'primary', esc_html__( 'Primary Menu', 'themerain' ) );
	add_theme_support(
		'html5',
		array(
			'search-form',
			'comment-form',
			'comment-list',
			'gallery',
			'caption',
			'script',
			'style'
		)
	);
	add_theme_support( 'post-thumbnails' );
	add_theme_support( 'responsive-embeds' );
	add_theme_support( 'align-wide' );

	// Add custom editor font sizes.
	add_theme_support( 'editor-font-sizes', array(
		array(
			'name' => esc_html__( 'Normal', 'themerain' ),
			'size' => 14,
			'slug' => 'normal'
		),
		array(
			'name' => esc_html__( 'Medium', 'themerain' ),
			'size' => 18,
			'slug' => 'medium'
		),
		array(
			'name' => esc_html__( 'Large', 'themerain' ),
			'size' => 24,
			'slug' => 'large'
		),
		array(
			'name' => esc_html__( 'Huge', 'themerain' ),
			'size' => 32,
			'slug' => 'huge'
		)
	) );
}
add_action( 'after_setup_theme', 'themerain_setup' );

/**
 * Set content-width.
 */
if ( ! isset( $content_width ) ) {
	$content_width = 1400;
}

/**
 * Enqueues Scripts and Styles.
 */
function themerain_enqueue_scripts() {
	// Enqueue styles
	wp_enqueue_style( 'themerain-style', get_theme_file_uri( '/assets/css/main.css' ) );

	// Enqueue scripts
	wp_enqueue_script( 'comment-reply' );
	wp_enqueue_script( 'gsap', get_theme_file_uri( '/assets/js/gsap.min.js' ), array(), null, true );
	wp_enqueue_script( 'scroll-trigger', get_theme_file_uri( '/assets/js/scrolltrigger.min.js' ), array(), null, true );
	wp_enqueue_script( 'lazysizes', get_theme_file_uri( '/assets/js/lazysizes.min.js' ), array(), null, true );
	wp_enqueue_script( 'ls-unveilhooks', get_theme_file_uri( '/assets/js/ls.unveilhooks.min.js' ), array(), null, true );
	wp_enqueue_script( 'swup', get_theme_file_uri( '/assets/js/swup.min.js' ), array(), null, true );
	wp_enqueue_script( 'swup-body-class-plugin', get_theme_file_uri( '/assets/js/SwupBodyClassPlugin.min.js' ), array(), null, true );
	wp_enqueue_script( 'swup-head-plugin', get_theme_file_uri( '/assets/js/SwupHeadPlugin.min.js' ), array(), null, true );
	wp_enqueue_script( 'swup-scroll-plugin', get_theme_file_uri( '/assets/js/SwupScrollPlugin.min.js' ), array(), null, true );
	wp_enqueue_script( 'themerain-functions', get_theme_file_uri( '/assets/js/functions.js' ), array(), null, true );

	// Localize scripts
	wp_localize_script( 'themerain-functions', 'themerain', array(
		'ajaxurl' => admin_url( 'admin-ajax.php' )
	) );
}
add_action( 'wp_enqueue_scripts', 'themerain_enqueue_scripts' );

/**
 * Enqueue Block Editor Styles.
 */
function themerain_block_editor_styles() {
	wp_enqueue_style( 'themerain-style-editor', get_theme_file_uri( '/assets/css/editor.css' ) );
}
add_action( 'enqueue_block_editor_assets', 'themerain_block_editor_styles', 1, 1 );

/**
 * REQUIRED FILES
 * Include required files.
 */
require get_template_directory() . '/inc/template-tags.php';
require get_template_directory() . '/inc/template-functions.php';

// Customizer.
require get_template_directory() . '/inc/customizer.php';

// Meta boxes.
require get_template_directory() . '/inc/meta-boxes.php';

// SVG icons.
require get_template_directory() . '/inc/svg-icons.php';

// Plugins.
require get_template_directory() . '/inc/plugins.php';

// Demo import.
require get_template_directory() . '/inc/demo.php';
