<?php
/**
 * Product loop sale flash
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/loop/sale-flash.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see         https://docs.woocommerce.com/document/template-structure/
 * @package     WooCommerce/Templates
 * @version     1.6.4
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

if ( 'widget' === wc_get_loop_prop( 'product_type' ) || 'rotate' == riode_get_single_product_layout() ) {
	return;
}

$show_labels = wc_get_loop_prop( 'show_labels', array( 'top', 'stock', 'sale', 'new' ) );

if ( ! is_array( $show_labels ) || 0 == count( $show_labels ) ) {
	return;
}

if ( ! riode_wc_show_info_for_role( 'label' ) ) {
	return;
}

global $post, $product;

$html = '';

// Featured Product

if ( $product->is_featured() && in_array( 'top', $show_labels ) ) {
	$html .= '<label class="product-label label-new">' . esc_html__( 'Top', 'riode' ) . '</label>';
}

// Sale Product
if ( $product->is_on_sale() && in_array( 'sale', $show_labels ) ) {
	$reg_p = floatval( $product->get_regular_price() );
	if ( $reg_p ) {
		$percentage = round( ( ( $reg_p - $product->get_sale_price() ) / $reg_p ) * 100 );
	} elseif ( 'variable' == $product->get_type() && $product->get_variation_regular_price() ) {
		$percentage = round( ( ( $product->get_variation_regular_price() - $product->get_variation_sale_price() ) / $product->get_variation_regular_price() ) * 100 );
	}

	if ( ! empty( $percentage ) ) {
		$html .= '<label class="product-label label-sale">' . $percentage . '% ' . esc_html__( 'off', 'riode' ) . '</label>';
	}
}

// Out of Stock
if ( in_array( 'stock', $show_labels ) && 'outofstock' == $product->get_stock_status() ) {
	$html .= '<label class="product-label label-stock">' . esc_html__( 'Out of Stock', 'riode' ) . '</label>';
}

// Finally, print labels

if ( $html ) {
	$html = '<div class="product-label-group' . esc_attr( apply_filters( 'riode_product_label_group_class', '' ) ) . '">' . $html . '</div>';

	echo apply_filters( 'woocommerce_sale_flash', $html, $post, $product );
}

/* Omit closing PHP tag at the end of PHP files to avoid "headers already sent" issues. */
