<?php
if ( ! defined( 'ABSPATH' ) ) {
	die();
}

/**
 * element-wishlist.php
 */

if ( class_exists( 'YITH_WCWL' ) ) :
	$wc_link  = YITH_WCWL()->get_wishlist_url();
	$wc_count = yith_wcwl_count_products();

	$type       = isset( $type ) ? ( $type ? $type : '' ) : riode_get_option( 'wish_type' );
	$show_icon  = isset( $show_icon ) ? $show_icon : (bool) riode_get_option( 'wish_icon_show' );
	$show_count = isset( $show_count ) ? $show_count : (bool) riode_get_option( 'wish_count' );
	$show_label = isset( $show_label ) ? $show_label : (bool) riode_get_option( 'wish_title' );
	$icon       = isset( $icon ) ? $icon : ( riode_get_option( 'wish_icon' ) ? riode_get_option( 'wish_icon' ) : 'd-icon-heart' );
	$label      = isset( $label ) ? $label : ( riode_get_option( 'wish_title_text' ) ? riode_get_option( 'wish_title_text' ) : esc_html__( 'Wishlist', 'riode' ) );
	?>
	<a class="wishlist <?php echo esc_attr( $type . '-type' ); ?>" href="<?php echo esc_url( $wc_link ); ?>">
		<?php if ( $show_icon ) : ?>
		<i class="<?php echo esc_attr( $icon ); ?>">
			<?php if ( $show_count ) : ?>
				<span class="wish-count"><?php echo esc_attr( $wc_count ); ?></span>
			<?php endif; ?>
		</i>
		<?php endif; ?>
		<?php if ( $show_label ) : ?>
		<span><?php echo esc_html( $label ); ?></span>
		<?php endif; ?>
	</a>
	<?php
else:
	?>
	<span class="no-plugin d-flex align-items-center"><i class="d-icon-alert mr-1" style="font-size: 22px;"></i><?php echo sprintf( esc_html__( '%1$sYith Wishlist Plugin%2$s is not installed.', 'riode' ), '<b class="mr-1">', '</b>' ); ?></span>
	<?php
endif;
