<?php
if ( ! defined( 'ABSPATH' ) ) {
	die();
}

/**
 * element-compare.php
 */

if ( class_exists( 'YITH_Woocompare' ) ) :

	global $yith_woocompare;

	$count = isset( $yith_woocompare->obj->products_list ) ? sizeof( $yith_woocompare->obj->products_list ) : 0;

	$type       = isset( $type ) ? ( $type ? $type : '' ) : riode_get_option( 'compare_type' );
	$show_icon  = isset( $show_icon ) ? $show_icon : (bool) riode_get_option( 'compare_icon_show' );
	$show_count = isset( $show_count ) ? $show_count : (bool) riode_get_option( 'compare_count' );
	$show_label = isset( $show_label ) ? $show_label : (bool) riode_get_option( 'compare_title' );
	$icon       = isset( $icon ) ? $icon : ( riode_get_option( 'compare_icon' ) ? riode_get_option( 'compare_icon' ) : 'd-icon-refresh' );
	$label      = isset( $label ) ? $label : ( riode_get_option( 'compare_title_text' ) ? riode_get_option( 'compare_title_text' ) : esc_html( 'Compare', 'riode' ) );
	?>
	<a class="compare-open yith-woocompare-open <?php echo esc_attr( $type . '-type' ); ?>" href="#">
		<?php if ( $show_icon ) : ?>
		<i class="<?php echo esc_attr( $icon ); ?>">
			<?php if ( $show_count ) : ?>
				<span class="compare-count"><?php echo esc_attr( $count ); ?></span>
			<?php endif; ?>
		</i>
		<?php endif; ?>
		<?php if ( $show_label ) : ?>
		<span><?php echo esc_html( $label ); ?></span>
		<?php endif; ?>
	</a>
	<?php
else:
	?>
	<span class="no-plugin d-flex align-items-center"><i class="d-icon-alert mr-1" style="font-size: 22px;"></i><?php echo sprintf( esc_html__( '%1$sYith Compare Plugin%2$s is not installed.', 'riode' ), '<b class="mr-1">', '</b>' ); ?></span>
	<?php
endif;
