<?php
if ( ! defined( 'ABSPATH' ) ) {
	die();
}

/**
 * Elementor Compatibilities
 */
if ( defined( 'ELEMENTOR_VERSION' ) ) {
	include RIODE_COMPATIBILITY . '/elementor/elementor-compatibility.php';
}

/**
 * VC Compatabilities
 */
if ( defined( 'VCV_VERSION' ) ) {
	include RIODE_COMPATIBILITY . '/vc/vc-compatibility.php';
}

/**
 * Dokan Compatabilities
 */

if ( defined( 'DOKAN_PLUGIN_VERSION' ) ) {
	include RIODE_COMPATIBILITY . '/dokan/dokan-compatibility.php';
}


/**
 * Gutenberg Compatibilities
 */
include RIODE_COMPATIBILITY . '/gutenberg/gutenberg-compatibility.php';

/**
 * WPBakery Compatabilities
 *
 * @since 1.1.0
 */
if ( defined( 'WPB_VC_VERSION' ) ) {
	include RIODE_COMPATIBILITY . '/wpb/wpb-compatibility.php';
}

/**
 * Child Theme Compatibility
 */
add_action( 'after_switch_theme', 'riode_child_theme_reset_options', 15 );
if ( ! function_exists( 'riode_child_theme_reset_options' ) ) {
	function riode_child_theme_reset_options() {
		if ( is_child_theme() && empty( get_theme_mod( 'container' ) ) ) {
			$parent_theme_options = get_option( 'theme_mods_riode' );
			update_option( 'theme_mods_' . get_option( 'stylesheet' ), $parent_theme_options );
		}
	}
}
