<?php

/**
 * Advanced Features
 */

Riode_Customizer::add_section(
	'wc_feature',
	array(
		'title' => esc_html__( 'Woo Features', 'riode' ),
		'panel' => 'woocommerce',
	)
);

Riode_Customizer::add_field(
	'option',
	array(
		'section'   => 'wc_feature',
		'type'      => 'custom',
		'settings'  => 'cs_wc_feature_swatch',
		'label'     => '',
		'default'   => '<h3 class="options-custom-title">' . esc_html__( 'Image Swatch', 'riode' ) . '</h3>',
		'transport' => 'refresh',
	)
);

Riode_Customizer::add_field(
	'option',
	array(
		'type'      => 'toggle',
		'settings'  => 'image_swatch',
		'label'     => esc_html__( 'Enable Image Swatch', 'riode' ),
		'default'   => riode_get_option( 'image_swatch' ),
		'tooltip'   => esc_html__( 'Check this to use image swatches as well as color swatches and label swatches.', 'riode' ),
		'section'   => 'wc_feature',
		'transport' => 'refresh',
	)
);

Riode_Customizer::add_field(
	'option',
	array(
		'section'   => 'wc_feature',
		'type'      => 'custom',
		'settings'  => 'cs_wc_feature_notice',
		'label'     => '',
		'default'   => '<h3 class="options-custom-title">' . esc_html__( 'Notification', 'riode' ) . '</h3>',
		'transport' => 'refresh',
	)
);

Riode_Customizer::add_field(
	'option',
	array(
		'type'      => 'text',
		'settings'  => 'wc_alert_remove',
		'label'     => esc_html__( 'Auto remove alerts after (seconds)', 'riode' ),
		'default'   => riode_get_option( 'wc_alert_remove' ),
		'tooltip'   => esc_html__( 'Notifications from wishlist, checkout and other Woo pages will be removed automatically after below time.', 'riode' ),
		'section'   => 'wc_feature',
		'transport' => 'refresh',
	)
);

Riode_Customizer::add_field(
	'option',
	array(
		'section'   => 'wc_feature',
		'type'      => 'custom',
		'settings'  => 'cs_wc_feature_sales_popup',
		'label'     => '',
		'default'   => '<h3 class="options-custom-title">' . esc_html__( 'Sales Popup', 'riode' ) . '</h3>',
		'tooltip'   => esc_html__( 'Sales popup shows some products to the visitors including recently sold products, best selling products, featured products.', 'riode' ),
		'transport' => 'refresh',
	)
);

Riode_Customizer::add_field(
	'option',
	array(
		'type'      => 'select',
		'settings'  => 'sales_popup',
		'label'     => esc_html__( 'Popup Content', 'riode' ),
		'section'   => 'wc_feature',
		'default'   => riode_get_option( 'sales_popup' ),
		'tooltip'   => esc_html__( 'Select which products you want to show in sales popup.', 'riode' ),
		'choices'   => array(
			''         => esc_html__( 'Do not show', 'riode' ),
			'popular'  => esc_html__( 'Popular products', 'riode' ),
			'rating'   => esc_html__( 'Top rated products', 'riode' ),
			'sale'     => esc_html__( 'Sale products', 'riode' ),
			'featured' => esc_html__( 'Featured products', 'riode' ),
			'recent'   => esc_html__( 'Recent products', 'riode' ),
			'category' => esc_html__( 'Select a category', 'riode' ),
			'products' => esc_html__( 'Select products', 'riode' ),
		),
		'transport' => 'refresh',
	)
);

add_action(
	'init',
	function() {
		$categories = get_terms(
			array(
				'taxonomy'   => 'product_cat',
				'hide_empty' => false,
			)
		);

		$category_list = array();
		foreach ( $categories as $category ) {
			$category_list[ $category->term_id ] = $category->name;
		}

		Riode_Customizer::add_field(
			'option',
			array(
				'type'            => 'select',
				'settings'        => 'sales_popup_category',
				'label'           => esc_html__( 'Sales Popup Category', 'riode' ),
				'section'         => 'wc_feature',
				'choices'         => $category_list,
				'active_callback' => array(
					array(
						'setting'  => 'sales_popup',
						'operator' => '==',
						'value'    => 'category',
					),
				),
				'transport'       => 'refresh',
			)
		);

		Riode_Customizer::add_field(
			'option',
			array(
				'type'            => 'text',
				'settings'        => 'sales_popup_products',
				'label'           => esc_html__( 'Input Products Ids', 'riode' ),
				'tooltip'         => esc_html__( 'Input comma seperated product ids for sales popup. e.g) 18, 21, 120', 'riode' ),
				'section'         => 'wc_feature',
				'default'         => riode_get_option( 'sales_popup_products' ),
				'active_callback' => array(
					array(
						'setting'  => 'sales_popup',
						'operator' => '==',
						'value'    => 'products',
					),
				),
				'transport'       => 'refresh',
			)
		);

		Riode_Customizer::add_field(
			'option',
			array(
				'section'         => 'wc_feature',
				'type'            => 'slider',
				'settings'        => 'sales_popup_count',
				'label'           => esc_html__( 'Products Count', 'riode' ),
				'default'         => riode_get_option( 'sales_popup_count' ),
				'transport'       => 'refresh',
				'choices'         => array(
					'min'  => 1,
					'max'  => 30,
					'step' => 1,
				),
				'active_callback' => array(
					array(
						'setting'  => 'sales_popup',
						'operator' => '!=',
						'value'    => 'products',
					),
					array(
						'setting'  => 'sales_popup',
						'operator' => '!=',
						'value'    => '',
					),
				),
			)
		);

		Riode_Customizer::add_field(
			'option',
			array(
				'type'            => 'text',
				'settings'        => 'sales_popup_title',
				'label'           => esc_html__( 'Popup Title', 'riode' ),
				'default'         => riode_get_option( 'sales_popup_title' ),
				'section'         => 'wc_feature',
				'active_callback' => array(
					array(
						'setting'  => 'sales_popup',
						'operator' => '!=',
						'value'    => '',
					),
				),
				'transport'       => 'refresh',
			)
		);

		Riode_Customizer::add_field(
			'option',
			array(
				'section'         => 'wc_feature',
				'type'            => 'slider',
				'settings'        => 'sales_popup_start_delay',
				'label'           => esc_html__( 'Start Delay(seconds)', 'riode' ),
				'default'         => riode_get_option( 'sales_popup_start_delay' ),
				'tooltip'         => esc_html__( 'Change delay time to show the first popup after page loading.', 'riode' ),
				'active_callback' => array(
					array(
						'setting'  => 'sales_popup',
						'operator' => '!=',
						'value'    => '',
					),
				),
				'transport'       => 'refresh',
				'choices'         => array(
					'min'  => 1,
					'max'  => 30,
					'step' => 1,
				),
			)
		);

		Riode_Customizer::add_field(
			'option',
			array(
				'section'         => 'wc_feature',
				'type'            => 'slider',
				'settings'        => 'sales_popup_interval',
				'label'           => esc_html__( 'Interval(seconds)', 'riode' ),
				'default'         => riode_get_option( 'sales_popup_interval' ),
				'tooltip'         => esc_html__( 'Change duration between popups. Each sales popup will be disappeared after 4 seconds.', 'riode' ),
				'active_callback' => array(
					array(
						'setting'  => 'sales_popup',
						'operator' => '!=',
						'value'    => '',
					),
				),
				'transport'       => 'refresh',
				'choices'         => array(
					'min'  => 1,
					'max'  => 600,
					'step' => 1,
				),
			)
		);

		Riode_Customizer::add_field(
			'option',
			array(
				'type'            => 'toggle',
				'settings'        => 'sales_popup_moile',
				'label'           => esc_html__( 'Enable on Mobile', 'riode' ),
				'default'         => riode_get_option( 'sales_popup_mobile' ),
				'section'         => 'wc_feature',
				'tooltip'         => esc_html__( 'Do you want to enable sales popup on mobile?', 'riode' ),
				'active_callback' => array(
					array(
						'setting'  => 'sales_popup',
						'operator' => '!=',
						'value'    => '',
					),
				),
				'transport'       => 'refresh',
			)
		);
	}
);
