<?php

/**
 * Advanced Features
 */

Riode_Customizer::add_section(
	'feature',
	array(
		'title' => esc_html__( 'Theme Features', 'riode' ),
		'panel' => 'advanced',
	)
);

Riode_Customizer::add_field(
	'option',
	array(
		'section'   => 'feature',
		'type'      => 'custom',
		'settings'  => 'cs_feature_title',
		'label'     => '',
		'default'   => '<h3 class="options-custom-title">' . esc_html__( 'Riode Features', 'riode' ) . '</h3>',
		'transport' => 'refresh',
	)
);

Riode_Customizer::add_field(
	'option',
	array(
		'section'   => 'feature',
		'type'      => 'toggle',
		'settings'  => 'lazyload',
		'label'     => esc_html__( 'Image LazyLoad', 'riode' ),
		'default'   => riode_get_option( 'lazyload' ),
		'tooltip'   => esc_html__( 'All images will be lazyloaded.', 'riode' ),
		'transport' => 'postMessage',
	)
);

Riode_Customizer::add_field(
	'option',
	array(
		'section'         => 'feature',
		'type'            => 'color',
		'settings'        => 'lazyload_bg',
		'label'           => esc_html__( 'Lazyload Image Initial Color', 'riode' ),
		'choices'         => array(
			'alpha' => true,
		),
		'default'         => riode_get_option( 'lazyload_bg' ),
		'transport'       => 'postMessage',
		'active_callback' => array(
			array(
				'setting'  => 'lazyload',
				'operator' => '==',
				'value'    => true,
			),
		),
	)
);

Riode_Customizer::add_field(
	'option',
	array(
		'section'   => 'feature',
		'type'      => 'toggle',
		'settings'  => 'lazyload_menu',
		'label'     => esc_html__( 'Menu Lazyload', 'riode' ),
		'default'   => riode_get_option( 'lazyload_menu' ),
		'tooltip'   => esc_html__( 'Menus will be lazyloaded. They will be saved in clients\' local storages for faster performance, and they will be updated when menu has been changed.', 'riode' ),
		'transport' => 'postMessage',
	)
);

Riode_Customizer::add_field(
	'option',
	array(
		'section'   => 'feature',
		'type'      => 'toggle',
		'settings'  => 'live_search',
		'label'     => esc_html__( 'Live Search', 'riode' ),
		'tooltip'   => esc_html__( 'Search boxes will show instant, quick and live search results in below dropdown.', 'riode' ),
		'default'   => riode_get_option( 'live_search' ),
		'transport' => 'postMessage',
	)
);

Riode_Customizer::add_field(
	'option',
	array(
		'section'     => 'feature',
		'type'        => 'toggle',
		'settings'    => 'skeleton_screen',
		'label'       => esc_html__( 'Skeleton Screen', 'riode' ),
		'tooltip'     => esc_html__( 'Beautiful skeleton screen will appear instead of preloading icon in all archive pages, single pages, quickview popup and any other ajax loading.', 'riode' ),
		'description' => esc_html__( 'NOTE: If you face into js compatibility problems with some plugins like dokan pro, please disable this feature.', 'riode' ),
		'default'     => riode_get_option( 'skeleton_screen' ),
		'transport'   => 'postMessage',
	)
);

Riode_Customizer::add_field(
	'option',
	array(
		'section'   => 'feature',
		'type'      => 'toggle',
		'settings'  => 'social_login',
		'label'     => esc_html__( 'Social Login', 'riode' ),
		'tooltip'   => esc_html__( 'Please activate Nextend Social Login plugin and enable social links.', 'riode' ),
		'transport' => 'postMessage',
		'default'   => riode_get_option( 'social_login' ),
	)
);

Riode_Customizer::add_field(
	'option',
	array(
		'section'   => 'feature',
		'type'      => 'custom',
		'settings'  => 'cs_feature_guide_title',
		'label'     => '',
		'default'   => '<h3 class="options-custom-title">' . esc_html__( 'Riode Starter Guides', 'riode' ) . '</h3>',
		'transport' => 'refresh',
	)
);

Riode_Customizer::add_field(
	'option',
	array(
		'section'   => 'feature',
		'type'      => 'toggle',
		'settings'  => 'elementor_starter_guide',
		'label'     => esc_html__( 'Show Elementor Guide', 'riode' ),
		'default'   => riode_get_option( 'elementor_starter_guide' ),
		'transport' => 'postMessage',
	)
);
