/**
 * Riode Product Data Addons Admin Library
 */
(function (wp, $) {
    'use strict';

    window.Riode = window.Riode || {};
    Riode.admin = Riode.admin || {};


    var productDataAddons = {
        init: function () {
            var self = this;

            // Datepicker fields
            $( '#riode_virtual_buy_time' ).datepicker({
                defaultDate:     '',
                dateFormat:      'yy-mm-dd',
                numberOfMonths:  1,
                showButtonPanel: true,
                maxDate: new Date()
            });

            $('#riode_image_change_hover, #riode_virtual_buy_time, #riode_virtual_buy_time_text').on('change', self.requireSave);
            $('#riode_data_addons .riode-data-addon-save').on('click', self.saveOptions);
        },

        /**
         * Require save
         */
        requireSave: function () {
            $('#riode_data_addons .riode-data-addon-save').prop('disabled', false);
        },
        /**
         * Event handler on save
         */
        saveOptions: function (e) {
            e.preventDefault();

            var $wrapper = $('#riode_data_addons');

            $wrapper.block({
                message: null,
                overlayCSS: {
                    background: '#fff',
                    opacity: 0.6
                }
            });

            $.ajax(
                {
                    type: 'POST',
                    dataType: 'json',
                    url: riode_product_data_addon_vars.ajax_url,
                    data: {
                        action: "riode_save_product_data_addon_options",
                        nonce: riode_product_data_addon_vars.nonce,
                        post_id: riode_product_data_addon_vars.post_id,
                        image_change_hover: $('#riode_image_change_hover').val(),
                        virtual_buy_time: $('#riode_virtual_buy_time').val(),
                        virtual_buy_time_text: $('#riode_virtual_buy_time_text').val()
                    },
                    success: function () {
                        $wrapper.unblock();
                    }
                }
            );
        },
    }
    /**
     * Product Data Addons Initializer
     */
    Riode.admin.productDataAddons = productDataAddons;

    $(document).ready(function () {
        Riode.admin.productDataAddons.init();
    });
})(wp, jQuery);
