<?php
if ( ! defined( 'ABSPATH' ) ) {
	die();
}

define( 'RIODE_ADDON', RIODE_INC . '/add-on' );
define( 'RIODE_ADDON_URI', RIODE_URI . '/inc/add-on' );

if ( ! isset( $_GET['action'] ) || 'yith-woocompare-view-table' != $_GET['action'] ) {
	$doing_ajax        = riode_doing_ajax();
	$customize_preview = is_customize_preview();
	$is_admin          = is_admin();
	$vc_preview        = function_exists( 'riode_is_vc_preview' ) && riode_is_vc_preview();
	$elementor_preview = function_exists( 'riode_is_elementor_preview' ) && riode_is_elementor_preview();
	$wpb_preview       = function_exists( 'riode_is_wpb_preview' ) && riode_is_wpb_preview();
	$is_preview        = $elementor_preview || $vc_preview || $wpb_preview;

	/**
	 * Skeleton Screen
	 */
	if ( ! $doing_ajax && ! $customize_preview && ! $is_preview && riode_get_option( 'skeleton_screen' ) ) {
		require_once( RIODE_ADDON . '/skeleton/skeleton.php' );
	}

	/**
	 * Lazyload
	 */
	add_filter(
		'wp_lazy_loading_enabled',
		function( $default, $tag_name ) {
			if ( 'img' === $tag_name ) {
				return false;
			}
			return $default;
		},
		10,
		2
	);

	if ( ! $is_admin && ! $customize_preview && ! $doing_ajax && riode_get_option( 'lazyload' ) ) {
		require_once RIODE_ADDON . '/lazyload-images/lazyload.php';
	}

	/**
	 * Lazyload Menu
	 */
	if ( $is_admin ) {
		if ( $customize_preview ) {
			add_action( 'customize_save_after', 'riode_lazyload_menu_update' );
		}

		global $pagenow;

		if ( 'post.php' == $pagenow ) {
			add_action( 'save_post', 'riode_lazyload_menu_update' );
		}
		add_action( 'wp_update_nav_menu_item', 'riode_lazyload_menu_update', 10, 3 );

		if ( ! function_exists( 'riode_lazyload_menu_update' ) ) {
			function riode_lazyload_menu_update() {
				set_theme_mod( 'menu_last_time', time() + ( get_option( 'gmt_offset' ) * HOUR_IN_SECONDS ) );
			}
		}
	}

	/**
	 * Live Search
	 */
	if ( ( ! $is_admin || $doing_ajax ) && riode_get_option( 'live_search' ) ) {
		require_once( RIODE_ADDON . '/live-search/live-search.php' );
	}

	/**
	 * WooCommerce Add-ons
	 */
	if ( class_exists( 'WooCommerce' ) ) {
		global $pagenow;

		$product_edit_page = ( 'post-new.php' == $pagenow && isset( $_GET['post_type'] ) && 'product' == $_GET['post_type'] ) ||
							( 'post.php' == $pagenow && isset( $_GET['post'] ) && 'product' == get_post_type( $_GET['post'] ) );

		// Product Image Swatch
		if ( riode_get_option( 'image_swatch' ) ) {
			if ( $is_admin && ( wp_doing_ajax() || $product_edit_page ) ) {
				require_once( RIODE_ADDON . '/image-swatch/admin-image-swatch-tab.php' );
			}

			require_once( RIODE_ADDON . '/image-swatch/image-swatch.php' );
		}

		// Product Custom Tabs
		if ( $is_admin && ( $doing_ajax || $product_edit_page ) ) {
			require_once( RIODE_ADDON . '/product-custom-tab/product-custom-tab-admin.php' );
			require_once( RIODE_ADDON . '/product-data-addons/product-data-addons-admin.php' );
		}

		// Sales Popup
		if ( riode_get_option( 'sales_popup' ) &&
			( ! wp_is_mobile() || riode_get_option( 'sales_popup_mobile' ) ) &&
			! $doing_ajax && ! $is_preview ) {
			require_once RIODE_ADDON . '/sales-popup/sales-popup.php';
		}

		// add-ons only in front-end
		add_action(
			'template_redirect',
			function() {
				// Video thumbnail
				if ( riode_is_product() ) {
					require_once RIODE_ADDON . '/video-thumbnail/video-thumbnail.php';
					require_once RIODE_ADDON . '/360-gallery/360-gallery.php';
				}
			}
		);
	}

	$template_edit_page = 'edit.php' == $GLOBALS['pagenow'] && isset( $_REQUEST['post_type'] ) && 'riode_template' == $_REQUEST['post_type'];
	/**
	 * Studio
	 */
	if ( defined( 'RIODE_CORE_VERSION' ) && ( current_user_can( 'edit_posts' ) || current_user_can( 'edit_pages' ) ) && 
		( $doing_ajax || $is_preview || $template_edit_page ) ) {
		require_once RIODE_ADDON . '/studio/studio.php';
	}
}

/**
 * Guide Tool tip
 */

if ( is_admin() && ( is_customize_preview() || ( function_exists( 'riode_is_elementor_preview' ) && riode_is_elementor_preview() ) || ( wp_doing_ajax() && isset( $_REQUEST['action'] ) ) ) ) {
	require_once( RIODE_ADDON . '/starter-guide/guide.php' );
}

/**
 * Breadcrumb
 */
require_once( RIODE_ADDON . '/breadcrumb/breadcrumb.php' );
