<?php
/**
 * Riode Product Image Swatch Tab for Admin
 */
defined( 'ABSPATH' ) || die;

if ( ! class_exists( 'Riode_Image_Swatch_Tab' ) ) {
	class Riode_Image_Swatch_Tab {

		public function __construct() {
			add_filter( 'woocommerce_product_data_tabs', array( $this, 'add_product_data_tab' ), 99 );
			add_action( 'woocommerce_product_data_panels', array( $this, 'add_product_data_panel' ), 99 );

			// Save Riode Swatch Options
			add_action( 'wp_ajax_riode_save_product_swatch_options', array( $this, 'save_swatch_options' ) );
			add_action( 'wp_ajax_nopriv_riode_save_product_swatch_options', array( $this, 'save_swatch_options' ) );

			add_action( 'admin_enqueue_scripts', array( $this, 'enqueue_scripts' ), 1001 );
		}

		public function add_product_data_tab( $tabs ) {
			$tabs['swatch'] = array(
				'label'    => esc_html__( 'Riode Image Change & Swatch', 'riode' ),
				'target'   => 'swatch_product_options',
				'class'    => array( 'show_if_variable' ),
				'priority' => 80,
			);
			return $tabs;
		}

		public function add_product_data_panel() {
			global $product_object;

			$attributes     = array_filter(
				$product_object->get_attributes(),
				function( $attr ) {
					return true === $attr->get_variation();
				}
			);
			$swatch_options = wc_get_product( $product_object->get_Id() )->get_meta( 'swatch_options', true );
			if ( $swatch_options ) {
				$swatch_options = json_decode( $swatch_options, true );
			}
			?>
			<div id="swatch_product_options" class="panel wc-metaboxes-wrapper woocommerce_options_panel hidden">
				<div class="wc-metaboxes">
				<?php
				if ( ! count( $attributes ) ) :
					?>

					<div id="message" class="inline notice riode-wc-message">
						<p><?php printf( esc_html__( 'Before you can add image swatch you need to add some %1$slist%2$s variation attributes on the %1$sAttributes%2$s tab.', 'riode' ), '<strong>', '</strong>' ); ?></p>
						<p><a class="button-primary" href="<?php echo esc_url( apply_filters( 'woocommerce_docs_url', 'https://docs.woocommerce.com/document/variable-product/', 'product-variations' ) ); ?>" target="_blank"><?php esc_html_e( 'Learn more', 'riode' ); ?></a></p>
					</div>

					<?php
				else :
					?>
					<div class="inline notice woocommerce-message"><p><?php esc_html_e( 'This will replace product image with following uploaded image when attribute button is clicked.', 'riode' ); ?></p></div>
					<?php
					foreach ( $attributes as $attribute ) :
						$attribute_obj = $attribute->get_taxonomy_object();

						$metabox_class = array();
						if ( $attribute->is_taxonomy() ) {
							$metabox_class[] = 'taxonomy';
							$metabox_class[] = $attribute->get_name();
						}

						$swatch_type = $swatch_options && isset( $swatch_options[ $attribute->get_name() ] ) ? $swatch_options[ $attribute->get_name() ]['type'] : 'label';
						?>
							<div data-taxonomy="<?php echo esc_attr( $attribute->get_taxonomy() ); ?>" class="woocommerce_attribute wc-metabox closed <?php echo esc_attr( implode( ' ', $metabox_class ) ); ?>" rel="<?php echo esc_attr( $attribute->get_position() ); ?>">
								<h3>
									<strong>
										<?php echo wc_attribute_label( $attribute->get_name() ); ?>
									</strong>
								</h3>
								<div class="woocommerce_attribute_data wc-metabox-content hidden">
									<p class="form-field">
										<label><?php esc_html_e( 'Button Type', 'riode' ); ?> </label>
										<select class="swatch-type">
											<option value="label" <?php selected( $swatch_type, 'label' ); ?>><?php esc_html_e( 'Default', 'riode' ); ?></option>
											<option value="image" <?php selected( $swatch_type, 'image' ); ?>><?php esc_html_e( 'Image', 'riode' ); ?></option>
										</select>
										<span class="woocommerce-help-tip" data-tip="<?php esc_attr_e( 'Select button type as image to show image on button.', 'riode' ); ?>"></span>
									</p>
									<table class="product_custom_swatches">
										<thead>
											<th><?php esc_html_e( 'Attribute', 'riode' ); ?></th>
											<th><?php esc_html_e( 'Image', 'riode' ); ?></th>
										</thead>

										<tbody>
										<?php
										foreach ( $attribute->get_options() as $option ) {
											$term = get_term( $option );
											if ( $term ) {
												$attr_label = $term->name;
											} else {
												$attr_label = $option;
												$option     = preg_replace( '/\s+/', '_', $option );
											}
											$src        = wc_placeholder_img_src();
												$src_id = $swatch_options && isset( $swatch_options[ $attribute->get_name() ] ) && isset( $swatch_options[ $attribute->get_name() ][ $option ] ) ? $swatch_options[ $attribute->get_name() ][ $option ] : '';
											if ( $src_id ) {
												$src = wp_get_attachment_image_src( $src_id )[0];
											}
											?>
												<tr data-term-id="<?php echo esc_attr( $option ); ?>">
													<td><?php echo esc_html( $attr_label ); ?></td>
													<td>
														<img src="<?php echo esc_url( $src ); ?>" alt="<?php esc_attr_e( 'Thumbnail Preview', 'riode' ); ?>" width="32" height="32">
														<input class="upload_image_url" type="hidden" value="<?php echo esc_attr( $src_id ); ?>" />
														<button class="button_upload_image button"><?php esc_html_e( 'Upload/Add image', 'riode' ); ?></button>
														<button class="button_remove_image button"><?php esc_html_e( 'Remove image', 'riode' ); ?></button>
													</td>
												</tr>
												<?php
										}
										?>
										</tbody>
									</table>
								</div>
							</div>
						<?php
					endforeach;
					?>
					<div class="toolbar">
						<span class="expand-close"><a href="#" class="expand_all"><?php esc_html_e( 'Expand', 'riode' ); ?></a> / <a href="#" class="close_all"><?php esc_html_e( 'Close', 'riode' ); ?></a></span>
						<button type="submit" class="button-primary riode-image-swatch-save" disabled="disabled"><?php esc_html_e( 'Save changes', 'riode' ); ?></button>
					</div>
					<?php
				endif;
				?>
				</div>
			</div>
			<?php
		}

		public function enqueue_scripts() {
			wp_enqueue_media();

			wp_enqueue_script( 'riode-swatch-admin', RIODE_ADDON_URI . '/image-swatch/swatch-admin.min.js', array(), RIODE_VERSION, true );

			wp_localize_script(
				'riode-swatch-admin',
				'riode_swatch_admin_vars',
				array(
					'placeholder'  => esc_url( wc_placeholder_img_src() ),
					'ajax_url'     => esc_url( admin_url( 'admin-ajax.php' ) ),
					'post_id'      => get_the_ID(),
					'product_type' => wc_get_product( get_the_ID() )->get_type(),
					'nonce'        => wp_create_nonce( 'riode-product-editor' ),
				)
			);
		}

		public function save_swatch_options() {
			if ( ! check_ajax_referer( 'riode-product-editor', 'nonce', false ) ) {
				wp_send_json_error( 'invalid_nonce' );
			}

			if ( 'variable' != $_POST['product_type'] ) {
				wp_send_json_error( 'not a variable product' );
			}

			$post_id        = $_POST['post_id'];
			$swatch_options = isset( $_POST['swatch_options'] ) ? $_POST['swatch_options'] : '';

			if ( count( $swatch_options ) ) {
				update_post_meta( $post_id, 'swatch_options', json_encode( $swatch_options ) );
			} else {
				delete_post_meta( $post_id, 'swatch_options' );
			}
			wp_send_json_success();
			die();
		}
	}
}

new Riode_Image_Swatch_Tab;
