/**
 * Riode Dependent Plugin - Product360Gallery
 *
 */

'use strict';

window.Riode || ( window.Riode = {} );

( function ( $ ) {

	var Product360Gallery = {
		openPopup: function(e) {
			e.preventDefault();

			var data = $(this).siblings('.riode-360-gallery-data').html();

			Riode.popup(
				{
					type: 'inline',
					mainClass: "riode-360-gallery-wrapper mfp-fade",
					preloader: false,
					items: {
						src: '<div class="riode-360-gallery-wrapper" style="max-width: 80rem;">' + data + '</div>'
					},
					callbacks: {
						open: function() {
							var images = $('.riode-360-gallery-wrap').attr('data-srcs').split(','),
								$degree_viewport = $('.mfp-content .riode-360-gallery-wrapper');

							$degree_viewport.addClass('not_loaded');

							$degree_viewport.ThreeSixty(
								{
									totalFrames: images.length, // Total no. of image you have for 360 slider
									endFrame: images.length, // end frame for the auto spin animation
									currentFrame: images.length - 1, // This the start frame for auto spin
									imgList: $degree_viewport.find( '.riode-360-gallery-wrap' ), // selector for image list
									progress: '.riode-degree-progress-bar', // selector to show the loading progress
									imgArray: images, // path of the image assets
									height: 500,
									width: 800,
									navigation: true
								}
							);

							$degree_viewport.find( '.riode-360-gallery-wrap' ).imagesLoaded(
								function () {
									setTimeout(function() {
										$degree_viewport.removeClass('not_loaded').css('height', '');
										$degree_viewport.find( '.nav_bar' ).removeClass( 'hide' );
									}, 200);
								}
							);
						},
						beforeClose: function () {
							this.container.empty();
						}
					}
				}
			);
		}
	};

	Riode.Product360Gallery = Product360Gallery;

	Riode.$window.on( 'riode_complete', function () {
		$('.woocommerce-product-gallery .riode-360-gallery-viewer').on('click', Riode.Product360Gallery.openPopup );
	} );
} )( jQuery );
