<?php
if ( ! defined( 'ABSPATH' ) ) {
	die();
}

if ( ! function_exists( 'riode_set_layout' ) ) {
	function riode_set_layout() {
		global $riode_layout;

		$riode_layout                = riode_get_layout();
		$riode_layout['used_blocks'] = riode_get_page_blocks();
	}
}

if ( ! function_exists( 'riode_add_body_class' ) ) {
	function riode_add_body_class( $classes ) {
		global $riode_layout;

		// Page Type
		$classes[] = str_replace( '_', '-', $riode_layout['slug'] );

		// Center Content Mode
		if ( isset( $riode_layout['general']['center_content'] ) && 'true' == $riode_layout['general']['center_content'] ) {
			$classes[] = 'center-with-sidebar';
		}

		// Left Sidebar Active?
		if ( isset( $riode_layout['left_sidebar'] ) && isset( $riode_layout['left_sidebar']['id'] ) && $riode_layout['left_sidebar']['id'] && -1 != $riode_layout['left_sidebar']['id'] ) {
			if ( isset( $riode_layout['left_sidebar']['type'] ) && 'control' == $riode_layout['left_sidebar']['type'] && isset( $riode_layout['left_sidebar']['place'] ) && 'out' == $riode_layout['left_sidebar']['place'] && isset( $riode_layout['left_sidebar']['first_show'] ) && 'true' == $riode_layout['left_sidebar']['first_show'] ) {
				$classes[] = ( is_rtl() ? 'right' : 'left' ) . '-sidebar-active';
			}
		}

		// Right Sidebar Active?
		if ( isset( $riode_layout['right_sidebar'] ) && isset( $riode_layout['right_sidebar']['id'] ) && $riode_layout['right_sidebar']['id'] && -1 != $riode_layout['right_sidebar']['id'] ) {
			if ( isset( $riode_layout['right_sidebar']['type'] ) && 'control' == $riode_layout['right_sidebar']['type'] && isset( $riode_layout['right_sidebar']['place'] ) && 'out' == $riode_layout['right_sidebar']['place'] && isset( $riode_layout['right_sidebar']['first_show'] ) && 'true' == $riode_layout['right_sidebar']['first_show'] ) {
				$classes[] = ( is_rtl() ? 'left' : 'right' ) . '-sidebar-active';
			}
		}

		// Disable Mobile Animation
		if ( riode_get_option( 'mobile_disable_animation' ) ) {
			$classes[] = 'riode-disable-mobile-animation';
		}

		// Rounded Border Skin
		if ( riode_get_option( 'rounded_skin' ) ) {
			$classes[] = 'riode-rounded-skin';
		}

		return $classes;
	}
}

if ( ! function_exists( 'riode_add_main_class' ) ) {
	function riode_add_main_class( $classes ) {
		if ( ( defined( 'YITH_WCWL' ) && function_exists( 'yith_wcwl_is_wishlist_page' ) && yith_wcwl_is_wishlist_page() ) ||
			( class_exists( 'WooCommerce' ) && ( is_cart() || is_checkout() || is_account_page() ) ) ) {
			$classes .= ' pt-lg';
		}
		return $classes;
	}
}


/*******************************
	*                          *
	*  Riode Theme Functions  *
	*                          *
	*******************************/

if ( ! function_exists( 'riode_print_title_bar' ) ) {
	function riode_print_title_bar() {
		global $riode_layout;

		if ( is_front_page() || 'product_single_layout' == $riode_layout['slug'] ) {
			return;
		}

		if ( class_exists( 'Woocommerce' ) && ( is_cart() || is_checkout() ) ) {
			?>
			<div class="woo-page-header">
				<div class="<?php echo esc_attr( 'full' == $riode_layout['general']['wrap'] ? 'container' : $riode_layout['general']['wrap'] ); ?>">
					<ul class="breadcrumb">
						<li class="<?php echo is_cart() ? esc_attr( 'current' ) : ''; ?>">
							<a href="<?php echo esc_url( wc_get_cart_url() ); ?>"><?php esc_html_e( '1. Shopping Cart', 'riode' ); ?></a>
							<i class="delimiter"></i>
						</li>
						<li class="<?php echo is_checkout() && ! is_order_received_page() ? esc_attr( 'current' ) : ''; ?>">
							<a href="<?php echo esc_url( wc_get_checkout_url() ); ?>"><?php esc_html_e( '2. Checkout', 'riode' ); ?></a>
							<i class="delimiter"></i>
						</li>
						<li class="<?php echo is_order_received_page() ? esc_attr( 'current' ) : esc_attr( 'disable' ); ?>">
							<a href="#"><?php esc_html_e( '3. Order Complete', 'riode' ); ?></a>
						</li>
					</ul>
				</div>
			</div>

			<?php
			return;
		}

		if ( ! ( isset( $riode_layout['ptb']['title'] ) || $riode_layout['ptb']['subtitle'] ) ) {
			return;
		}

		if ( isset( $riode_layout['ptb'] ) && isset( $riode_layout['ptb']['id'] ) && 'classic' != $riode_layout['ptb']['id'] && '' != $riode_layout['ptb']['id']
		) {
			if ( $riode_layout['ptb']['id'] > 0 ) {
				riode_print_template( $riode_layout['ptb']['id'] );
			}
		} else {
			$ptb_type = riode_get_option( 'ptb_type' );

			if ( riode_get_option( 'ptb_title_show' ) || riode_get_option( 'ptb_subtitle_show' ) ||
				( 'depart' != $ptb_type && riode_get_option( 'ptb_breadcrumb_show' ) ) ) {
				echo '<div class="page-header">';

				echo '<div class="page-title-bar type-' . $ptb_type . '">';

				echo '<div class="page-title-wrap">';
				if ( 'show' == riode_get_option( 'ptb_subtitle_show' ) && $riode_layout['ptb']['subtitle'] ) {
					echo '<h3 class="page-subtitle">' . $riode_layout['ptb']['subtitle'] . '</h3>';
				}
				if ( 'show' == riode_get_option( 'ptb_title_show' ) && $riode_layout['ptb']['title'] ) {
					echo '<h2 class="page-title">' . $riode_layout['ptb']['title'] . '</h2>';
				}
				echo '</div>';

				if ( 'depart' != $ptb_type && riode_get_option( 'ptb_breadcrumb_show' ) ) {
					do_action( 'riode_print_breadcrumb' );
				}

				echo '</div>';

				echo '</div>';
			}

			if ( 'depart' == $ptb_type && riode_get_option( 'ptb_breadcrumb_show' ) ) {

				echo '<div class="breadcrumb_wrapper">';

				if ( 'full' != $riode_layout['general']['wrap'] ) {
					echo '<div class="' . $riode_layout['general']['wrap'] . '">';
				} else {
					echo '<div class="container">';
				}

				do_action( 'riode_print_breadcrumb' );

				echo '</div>';
				echo '</div>';
			}
		}
	}
}

if ( ! function_exists( 'riode_func_add_block' ) ) {
	function riode_func_add_block( $arg = RIODE_BEFORE_CONTENT ) {
		$block_name = '';

		global $riode_layout;

		if ( RIODE_BEFORE_CONTENT == $arg ) {
			$single_type = riode_get_option( 'single_product_type' );

			if ( class_exists( 'WooCommerce' ) && is_product() ) {
				add_filter( 'riode_breadcrumb_args', 'riode_single_prev_next_product' );

				if ( 'gallery' != $single_type ) {
					remove_action( 'riode_before_content', 'riode_print_title_bar' );
				}
			}
		}

		if ( RIODE_BEFORE_CONTENT == $arg && isset( $riode_layout['top_block']['id'] ) && 0 < $riode_layout['top_block']['id'] ) {
			$block_name = sanitize_text_field( $riode_layout['top_block']['id'] );
			echo '<div class="top-block">';
		} elseif ( RIODE_BEFORE_INNER_CONTENT == $arg && isset( $riode_layout['inner_top_block']['id'] ) && 0 < $riode_layout['inner_top_block']['id'] ) {
			$block_name = sanitize_text_field( $riode_layout['inner_top_block']['id'] );
			echo '<div class="inner-top-block">';
		} elseif ( RIODE_AFTER_INNER_CONTENT == $arg && isset( $riode_layout['inner_bottom_block']['id'] ) && 0 < $riode_layout['inner_bottom_block']['id'] ) {
			$block_name = sanitize_text_field( $riode_layout['inner_bottom_block']['id'] );
			echo '<div class="inner-bottom-block">';
		} elseif ( RIODE_AFTER_CONTENT == $arg && isset( $riode_layout['bottom_block']['id'] ) && 0 < $riode_layout['bottom_block']['id'] ) {
			$block_name = sanitize_text_field( $riode_layout['bottom_block']['id'] );
			echo '<div class="bottom-block">';
		}

		riode_print_template( $block_name );

		if ( $block_name ) {
			echo '</div>';
		}
	}
}

if ( ! function_exists( 'riode_print_layout_before' ) ) {
	function riode_print_layout_before() {
		global $riode_layout;

		if ( 'full' != $riode_layout['general']['wrap'] ) {
			echo '<div class="' . esc_attr( 'container' == $riode_layout['general']['wrap'] ? 'container' : 'container-fluid' ) . '">';
		}

		do_action( 'riode_before_main_content' );

		$ls        = false; // state of left sidebar
		$rs        = false; // state of right sidebar
		$ls_canvas = false; // on_canvas/off_canvas
		$rs_canvas = false; // on_canvas/off_canvas

		if ( isset( $riode_layout['left_sidebar'] ) && isset( $riode_layout['left_sidebar']['id'] ) && is_active_sidebar( $riode_layout['left_sidebar']['id'] ) ) {
			$ls = true;
			if ( ! ( isset( $riode_layout['left_sidebar']['type'] ) && 'control' == $riode_layout['left_sidebar']['type'] ) || ( isset( $riode_layout['left_sidebar']['place'] ) && 'in' == $riode_layout['left_sidebar']['place'] ) ) {
				$ls_canvas = true;
			}
		}
		if ( isset( $riode_layout['right_sidebar'] ) && isset( $riode_layout['right_sidebar']['id'] ) && is_active_sidebar( $riode_layout['right_sidebar']['id'] ) ) {
			if ( ! ( isset( $riode_layout['right_sidebar']['type'] ) && 'control' == $riode_layout['right_sidebar']['type'] ) || ( isset( $riode_layout['right_sidebar']['place'] ) && 'in' == $riode_layout['right_sidebar']['place'] ) ) {
				$rs_canvas = true;
			}
		}

		if ( $ls ) {
			ob_start();

			riode_get_template_part(
				RIODE_PART . '/sidebar',
				null,
				array(
					'layout_slug' => $riode_layout['slug'],
					'sidebar'     => $riode_layout['left_sidebar'],
					'container'   => $riode_layout['general']['wrap'],
					'pos'         => 'left',
				)
			);

			$ls = ob_get_clean();
		}

		$col_class = '';

		if ( $ls && ! $ls_canvas ) {
			echo riode_escaped( $ls );
		}

		if ( $ls_canvas || $rs_canvas ) {
			if ( $ls_canvas && $rs_canvas ) {
				$col_class = ' col-lg-6';
			} else {
				$col_class = ' col-lg-9';
			}
			echo '<div class="row gutter-lg main-content-wrap">';
		}

		if ( $ls && $ls_canvas ) {
			echo riode_escaped( $ls );
		}

		echo '<div class="' . esc_attr( apply_filters( 'riode_main_content_class', 'main-content' . $col_class ) ) . '">';

		$ts = ( 'product_archive_layout' == $riode_layout['slug'] ) && isset( $riode_layout['top_sidebar'] ) && isset( $riode_layout['top_sidebar']['id'] ) && is_active_sidebar( $riode_layout['top_sidebar']['id'] );

		if ( ! $ts ) {
			do_action( 'riode_before_inner_content', RIODE_BEFORE_INNER_CONTENT );
		}
	}
}

if ( ! function_exists( 'riode_print_layout_after' ) ) {
	function riode_print_layout_after( $comment_template = true ) {
		global $riode_layout;

		$ts = 'product_archive_layout' == $riode_layout['slug'] && isset( $riode_layout['top_sidebar'] ) && isset( $riode_layout['top_sidebar']['id'] ) && is_active_sidebar( $riode_layout['top_sidebar']['id'] );

		do_action( 'riode_after_inner_content', RIODE_AFTER_INNER_CONTENT );

		echo '</div>'; // End of main content wrap

		$ls        = false; // state of left sidebar
		$rs        = false; // state of right sidebar
		$ls_canvas = false; // on_canvas/off_canvas
		$rs_canvas = false; // on_canvas/off_canvas

		if ( isset( $riode_layout['left_sidebar'] ) && isset( $riode_layout['left_sidebar']['id'] ) && is_active_sidebar( $riode_layout['left_sidebar']['id'] ) ) {
			$ls = true;

			if ( ! ( isset( $riode_layout['left_sidebar']['type'] ) && 'control' == $riode_layout['left_sidebar']['type'] ) || ( isset( $riode_layout['left_sidebar']['place'] ) && 'in' == $riode_layout['left_sidebar']['place'] ) ) {
				$ls_canvas = true;
			}
		}
		if ( isset( $riode_layout['right_sidebar'] ) && isset( $riode_layout['right_sidebar']['id'] ) && is_active_sidebar( $riode_layout['right_sidebar']['id'] ) ) {
			$rs = true;

			if ( ! ( isset( $riode_layout['right_sidebar']['type'] ) && 'control' == $riode_layout['right_sidebar']['type'] ) || ( isset( $riode_layout['right_sidebar']['place'] ) && 'in' == $riode_layout['right_sidebar']['place'] ) ) {
				$rs_canvas = true;
			}
		}

		if ( $rs ) {
			ob_start();

			riode_get_template_part(
				RIODE_PART . '/sidebar',
				null,
				array(
					'layout_slug' => $riode_layout['slug'],
					'sidebar'     => $riode_layout['right_sidebar'],
					'container'   => $riode_layout['general']['wrap'],
					'pos'         => 'right',
				)
			);

			$rs = ob_get_clean();
		}

		if ( $rs && $rs_canvas ) {
			echo riode_escaped( $rs );
		}
		if ( $ls_canvas || $rs_canvas ) {
			echo '</div>';
		}
		if ( $rs && ! $rs_canvas ) {
			echo riode_escaped( $rs );
		}

		do_action( 'riode_after_main_content' );

		if ( $comment_template && is_page() && ! riode_is_shop() ) {
			comments_template();
		}

		if ( 'full' != $riode_layout['general']['wrap'] ) { // end of container or container-fluid
			echo '</div>';
		}
	}
}


if ( ! function_exists( 'riode_comment_form_before_fields' ) ) {
	function riode_comment_form_before_fields() {
		echo '<div class="row">';
	}
}

if ( ! function_exists( 'riode_comment_form_after_fields' ) ) {
	function riode_comment_form_after_fields() {
		echo '</div>';
	}
}

if ( ! function_exists( 'riode_set_avatar_size' ) ) {
	function riode_set_avatar_size( $args ) {
		$args['size']   = 80;
		$args['width']  = 80;
		$args['height'] = 80;
		return $args;
	}
}

if ( ! function_exists( 'riode_author_date_pattern' ) ) {
	function riode_author_date_pattern( $date ) {
		return date( 'F j, Y \a\t g:s a', strtotime( $date ) );
	}
}

if ( ! function_exists( 'riode_set_cookies' ) ) {
	function riode_set_cookies() {
		// phpcs:disable WordPress.Security.NonceVerification.NoNonceVerification

		if ( ! empty( $_GET['top_filter'] ) ) {
			setcookie( 'top_filter', sanitize_title( $_GET['top_filter'] ), time() + ( 86400 ), '/' );
			$_COOKIE['riode_top_filter'] = esc_html( $_GET['top_filter'] );
		}

		// phpcs:enable
	}
}


/*******************************
	*                          *
	*   Riode Ajax Actions  *
	*                          *
	*******************************/

if ( ! function_exists( 'riode_loadmore' ) ) {
	function riode_loadmore() {

		// phpcs:disable WordPress.Security.NonceVerification.NoNonceVerification

		if ( isset( $_POST['args'] ) && isset( $_POST['props'] ) ) {
			$args  = $_POST['args'];
			$props = $_POST['props'];

			if ( 'post' === $args['post_type'] ) {
				/**
				 * Load more posts
				 */
				$posts = new WP_Query( $args );
				if ( $posts ) {

					ob_start();
					while ( $posts->have_posts() ) {
						$posts->the_post();
						if ( function_exists( 'riode_get_template_part' ) ) {
							riode_get_template_part(
								RIODE_PART . '/posts/post',
								null,
								$props
							);
						}
					}
					$html = ob_get_clean();

					if ( $_POST['pagination'] ) {
						echo json_encode(
							array(
								'html'       => $html,
								'pagination' => riode_get_pagination( $posts, 'pagination-load' ),
							)
						);
					} else {
						echo riode_escaped( $html );
					}
					wp_reset_postdata();
				}
			} else {
				/**
				 * Load more products
				 */
				$args  = $_POST['args'];
				$props = $_POST['props'];

				if ( isset( $args['paged'] ) && $args['paged'] ) {
					$args['page'] = $args['paged'];
					unset( $args['paged'] );
				}

				if ( isset( $args['total'] ) && $args['total'] ) {
					unset( $args['total'] );
				}

				wc_set_loop_prop( 'riode_ajax_load', true );

				foreach ( $props as $key => $prop ) {
					wc_set_loop_prop( $key, $prop );
				}

				$args_str = '';
				foreach ( $args as $key => $value ) {
					$args_str .= ' ' . $key . '=' . json_encode( $value );
				}

				$html = do_shortcode( '[products' . $args_str . ']' );

				echo riode_escaped( $html );
			}
		}

		exit;

		// phpcs:enable
	}
}


// ajax sign in / sign up form
if ( ! function_exists( 'riode_ajax_account_form' ) ) {
	function riode_ajax_account_form() {
		// phpcs:disable WordPress.Security.NonceVerification.NoNonceVerification

		echo wc_get_template_part( 'myaccount/form-login' );

		exit();

		// phpcs:enable
	}
}

// sign in ajax validate
function riode_account_signin_validate() {
	$nonce_value = wc_get_var( $_REQUEST['woocommerce-login-nonce'], wc_get_var( $_REQUEST['_wpnonce'], '' ) ); // @codingStandardsIgnoreLine.
	$result      = false;
	if ( wp_verify_nonce( $nonce_value, 'woocommerce-login' ) ) {
		try {
			$creds = array(
				'user_login'    => trim( $_POST['username'] ),
				'user_password' => $_POST['password'],
				'remember'      => isset( $_POST['rememberme'] ),
			);

			$validation_error = new WP_Error();
			$validation_error = apply_filters( 'woocommerce_process_login_errors', $validation_error, $_POST['username'], $_POST['password'] );

			if ( $validation_error->get_error_code() ) {
				echo json_encode(
					array(
						'loggedin' => false,
						'message'  => '<strong>' . esc_html__(
							'Error:',
							'riode'
						) . '</strong> ' . $validation_error->get_error_message(),
					)
				);
				die();
			}

			if ( empty( $creds['user_login'] ) ) {
				echo json_encode(
					array(
						'loggedin' => false,
						'message'  => '<strong>' . esc_html__(
							'Error:',
							'riode'
						) . '</strong> ' . esc_html__(
							'Username is required.',
							'riode'
						),
					)
				);
				die();
			}

			// On multisite, ensure user exists on current site, if not add them before allowing login.
			if ( is_multisite() ) {
				$user_data = get_user_by( is_email( $creds['user_login'] ) ? 'email' : 'login', $creds['user_login'] );

				if ( $user_data && ! is_user_member_of_blog( $user_data->ID, get_current_blog_id() ) ) {
					add_user_to_blog( get_current_blog_id(), $user_data->ID, 'customer' );
				}
			}

			// Perform the login
			$user = wp_signon( apply_filters( 'woocommerce_login_credentials', $creds ), is_ssl() );
			if ( ! is_wp_error( $user ) ) {
				$result = true;
			}
		} catch ( Exception $e ) {
		}
	}
	if ( $result ) {
		echo json_encode(
			array(
				'loggedin' => true,
				'message'  => esc_html__(
					'Login successful, redirecting...',
					'riode'
				),
			)
		);
	} else {
		echo json_encode(
			array(
				'loggedin' => false,
				'message'  => esc_html__(
					'Wrong username or password.',
					'riode'
				),
			)
		);
	}
	die();
}

// sign up ajax validate
function riode_account_signup_validate() {

	$nonce_value = isset( $_POST['_wpnonce'] ) ? $_POST['_wpnonce'] : '';
	$nonce_value = isset( $_POST['woocommerce-register-nonce'] ) ? $_POST['woocommerce-register-nonce'] : $nonce_value;
	$result      = true;

	if ( wp_verify_nonce( $nonce_value, 'woocommerce-register' ) ) {
		$username = 'no' === get_option( 'woocommerce_registration_generate_username' ) ? $_POST['username'] : '';
		$password = 'no' === get_option( 'woocommerce_registration_generate_password' ) ? $_POST['password'] : '';
		$email    = $_POST['email'];

		try {
			$validation_error = new WP_Error();
			$validation_error = apply_filters( 'woocommerce_process_registration_errors', $validation_error, $username, $password, $email );

			if ( $validation_error->get_error_code() ) {
				echo json_encode(
					array(
						'loggedin' => false,
						'message'  => $validation_error->get_error_message(),
					)
				);
				die();
			}

			$new_customer = wc_create_new_customer( sanitize_email( $email ), wc_clean( $username ), $password );

			if ( is_wp_error( $new_customer ) ) {
				echo json_encode(
					array(
						'loggedin' => false,
						'message'  => $new_customer->get_error_message(),
					)
				);
				die();
			}

			if ( apply_filters( 'woocommerce_registration_auth_new_customer', true, $new_customer ) ) {
				wc_set_customer_auth_cookie( $new_customer );
			}
		} catch ( Exception $e ) {
			$result = false;
		}
	}
	if ( $result ) {
		echo json_encode(
			array(
				'loggedin' => true,
				'message'  => esc_html__(
					'Register successful, redirecting...',
					'riode'
				),
			)
		);
	} else {
		echo json_encode(
			array(
				'loggedin' => false,
				'message'  => esc_html__(
					'Register failed.',
					'riode'
				),
			)
		);
	}
	die();
}

if ( ! function_exists( 'riode_load_mobile_menu' ) ) {
	function riode_load_mobile_menu() {
		// phpcs:disable WordPress.Security.NonceVerification.NoNonceVerification
		?>

		<!-- Search Form -->
		<div class="mobile-menu">
			<div class="search-wrapper hs-simple">
				<form action="<?php echo esc_url( home_url() ); ?>/" method="get" class="input-wrapper">
					<input type="hidden" name="post_type" value="<?php echo esc_attr( class_exists( 'WooCommerce' ) ? 'product' : 'post' ); ?>"/>
					<input type="search" class="form-control" name="s" placeholder="<?php esc_attr_e( 'Search your keywords...', 'riode' ); ?>" required="" autocomplete="off">

					<?php if ( riode_get_option( 'live_search' ) ) : ?>
						<div class="live-search-list"></div>
					<?php endif; ?>

					<button class="btn btn-search" type="submit">
						<i class="d-icon-search"></i>
					</button> 
				</form>
			</div>

		<?php

		$mobile_menus = riode_get_option( 'mobile_menu_items' );

		if ( ! empty( $mobile_menus ) ) {
			echo '<div class="nav-wrapper" data-menu-arrange="' . riode_get_option( 'mobile_menu_type' ) . '">';

			ob_start();
			foreach ( $mobile_menus as $menu ) {
				if ( empty( $menu ) ) {
					continue;
				}

				$menu_name = $menu;
				if ( is_numeric( $menu ) ) {
					$menu_obj = get_term( $menu, 'nav_menu' );
					if ( ! $menu_obj || is_wp_error( $menu_obj ) ) {
						continue;
					}
					$menu_name = $menu_obj->name;
				}

				wp_nav_menu(
					array(
						'menu'            => $menu,
						'container'       => 'nav',
						'container_class' => $menu_name,
						'items_wrap'      => '<ul id="%1$s" class="mobile-menu">%3$s</ul>',
						'walker'          => new Riode_Walker_Nav_Menu(),
						'theme_location'  => '',
						'fallback_cb'     => '__return_false',
					)
				);
			}
			$mobile_menu_html_escaped = ob_get_clean();

			if ( $mobile_menu_html_escaped ) {
				echo riode_strip_script_tags( $mobile_menu_html_escaped );
			} else {
				echo '<nav><ul class="mobile-menu"></ul></nav>';
			}

			echo '</div>';
		}

		echo '</div>';

		if ( riode_doing_ajax() && $_REQUEST['action'] && 'riode_load_mobile_menu' == $_REQUEST['action'] ) {
			die;
		}

		// phpcs:enable
	}
}

if ( ! function_exists( 'riode_load_menu' ) ) {
	function riode_load_menu() {
		// phpcs:disable WordPress.Security.NonceVerification.NoNonceVerification

		if ( ! shortcode_exists( 'vc_row' ) && class_exists( 'WPBMap' ) && method_exists( 'WPBMap', 'addAllMappedShortcodes' ) ) {
			WPBMap::addAllMappedShortcodes();
		}

		if ( isset( $_POST['menus'] ) && is_array( $_POST['menus'] ) ) {
			$menus = $_POST['menus'];
			if ( ! empty( $menus ) ) {
				$result = array();
				foreach ( $menus as $menu ) {
					$result[ $menu ] = wp_nav_menu(
						array(
							'menu'       => $menu,
							'container'  => '',
							'items_wrap' => '%3$s',
							'walker'     => new Riode_Walker_Nav_Menu(),
							'echo'       => false,
						)
					);
				}
				echo json_encode( $result );
			}
		}

		exit;

		// phpcs:enable
	}
}

// Riode Contact Form Functions
if ( ! function_exists( 'riode_wpcf7_add_form_tag_submit' ) ) {
	function riode_wpcf7_add_form_tag_submit() {
		wpcf7_remove_form_tag( 'submit' );
		wpcf7_add_form_tag( 'submit', 'riode_wpcf7_submit_form_tag_handler' );
	}
}
if ( ! function_exists( 'riode_wpcf7_submit_form_tag_handler' ) ) {
	function riode_wpcf7_submit_form_tag_handler( $tag ) {
		$class = wpcf7_form_controls_class( $tag->type );

		$atts = array();

		$atts['class']    = $tag->get_class_option( $class );
		$atts['id']       = $tag->get_id_option();
		$atts['tabindex'] = $tag->get_option( 'tabindex', 'signed_int', true );

		$value = isset( $tag->values[0] ) ? $tag->values[0] : '';

		if ( empty( $value ) ) {
			$value = esc_html__( 'Send', 'riode' );
		}

		$atts['type']  = 'submit';
		$atts['value'] = $value;

		$atts = wpcf7_format_atts( $atts );

		$html = sprintf( '<button %1$s>%2$s</button>', $atts, esc_html( $value ) );

		return $html;
	}
}
function riode_wpcf7_form_novalidate() {
	return '';
}

// Riode Widget Compatability Functions
if ( ! function_exists( 'riode_widget_nav_menu_args' ) ) {
	function riode_widget_nav_menu_args( $nav_menu_args, $menu, $args, $instance ) {
		$nav_menu_args['items_wrap'] = '<ul id="%1$s" class="menu collapsible-menu">%3$s</ul>';
		return $nav_menu_args;
	}
}


// comment feeling
if ( ! function_exists( 'riode_ajax_comment_feeling' ) ) {
	function riode_ajax_comment_feeling() {
		// check_ajax_referer( 'riode-nonce', 'nonce' );
		// phpcs:disable WordPress.Security.NonceVerification.NoNonceVerification
		$id = isset( $_POST['comment_id'] ) ? $_POST['comment_id'] : 0;
		if ( $id ) {
			$action        = $_POST['button'];
			$status        = isset( $_COOKIE[ 'riode_comment_feeling_' . $id ] ) ? (int) $_COOKIE[ 'riode_comment_feeling_' . $id ] : 0;
			$like_count    = get_comment_meta( $id, 'like_count', true );
			$dislike_count = get_comment_meta( $id, 'dislike_count', true );

			if ( 'like' == $action ) {
				if ( 1 == $status ) {
					$like_count --;
					$status = 0;
				} else {
					if ( -1 == $status ) {
						$dislike_count --;
					}

					$like_count ++;
					$status = 1;
				}
			} else {
				if ( -1 == $status ) {
					$dislike_count --;
					$status = 0;
				} else {
					if ( 1 == $status ) {
						$like_count --;
					}

					$dislike_count ++;
					$status = -1;
				}
			}

			$like_count    = max( 0, $like_count );
			$dislike_count = max( 0, $dislike_count );

			if ( 0 === $status ) {
				setcookie( 'comment_feeling_' . intval( $id ), '', time() - 360 * 24 * 60 * 60, '/' );
			} else {
				setcookie( 'comment_feeling_' . intval( $id ), $status, time() + 360 * 24 * 60 * 60, '/' );
			}

			update_comment_meta( $id, 'like_count', $like_count );
			update_comment_meta( $id, 'dislike_count', $dislike_count );

			echo json_encode( array( $status, intval( $like_count ), intval( $dislike_count ) ) );
		}

		// phpcs:enable
		exit();
	}
}

/**
 * Riode Comment Form Functions
 */
if ( ! function_exists( 'riode_comment_form_args' ) ) {
	function riode_comment_form_args( $args ) {
		global $riode_layout;
		$page_type = $riode_layout['slug'];

		$args['title_reply_before'] = '<h3 id="reply-title" class="comment-reply-title">';
		$args['title_reply_after']  = '</h3>';
		$args['fields']['author']   = '<div class="col-md-6"><input name="author" type="text" class="form-control" value="" placeholder="' . esc_attr__( 'Name', 'riode' ) . '*"> </div>';
		$args['fields']['email']    = '<div class="col-md-6"><input name="email" type="text" class="form-control" value="" placeholder="' . esc_attr__( 'Email', 'riode' ) . '*"> </div>';

		$args['comment_field']  = isset( $args['comment_field'] ) ? $args['comment_field'] : '';
		$args['comment_field']  = substr( $args['comment_field'], 0, strpos( $args['comment_field'], '<p class="comment-form-comment">' ) );
		$args['comment_field'] .= '<textarea name="comment" id="comment" class="form-control" rows="6" maxlength="65525" required="required" placeholder="' . esc_attr__( 'Comment', 'riode' ) . '*"></textarea>';
		$args['submit_button']  = '<button type="submit" class="btn btn-primary btn-submit">' .
			( 'product_single_layout' == $page_type ? esc_html__( 'Submit', 'riode' ) : esc_html__( 'Post Comment', 'riode' ) ) .
			'<i class="d-icon-arrow-' . ( is_rtl() ? 'left' : 'right' ) . '"></i>' . '</button>';

		return $args;
	}
}

// print popup template when specific selector is clicked
if ( ! function_exists( 'riode_ajax_print_popup' ) ) {
	function riode_ajax_print_popup() {
		//check_ajax_referer( 'riode-nonce', 'nonce' );
		// phpcs:disable WordPress.Security.NonceVerification.NoNonceVerification

		$id = isset( $_POST['popup_id'] ) ? $_POST['popup_id'] : 0;

		if ( $id ) {
			riode_print_popup_template( $id, '', '' );
		}

		// phpcs:enable
		exit();
	}
}
