<?php
/**
 * Dokan Seller registration form
 *
 * @since 2.4
 *
 * @package dokan
 */
?>

<div class="show_if_seller" style="<?php echo esc_attr( $role_style ); ?>">

	<div class="split-row form-row-wide">
		<p class="form-row form-group">
			<label for="first-name"><?php esc_html_e( 'First Name', 'dokan-lite' ); ?> <span class="required">*</span></label>
			<input type="text" class="input-text form-control" name="fname" id="first-name" value="
			<?php
			if ( ! empty( $postdata['fname'] ) ) {
				echo esc_attr( $postdata['fname'] );}
			?>
			" required="required" />
		</p>

		<p class="form-row form-group">
			<label for="last-name"><?php esc_html_e( 'Last Name', 'dokan-lite' ); ?> <span class="required">*</span></label>
			<input type="text" class="input-text form-control" name="lname" id="last-name" value="
			<?php
			if ( ! empty( $postdata['lname'] ) ) {
				echo esc_attr( $postdata['lname'] );}
			?>
			" required="required" />
		</p>
	</div>

	<p class="form-row form-group form-row-wide">
		<label for="company-name"><?php esc_html_e( 'Shop Name', 'dokan-lite' ); ?> <span class="required">*</span></label>
		<input type="text" class="input-text form-control" name="shopname" id="company-name" value="
		<?php
		if ( ! empty( $postdata['shopname'] ) ) {
			echo esc_attr( $postdata['shopname'] );}
		?>
		" required="required" />
	</p>

	<p class="form-row form-group form-row-wide">
		<label for="seller-url" class="pull-left"><?php esc_html_e( 'Shop URL', 'dokan-lite' ); ?> <span class="required">*</span></label>
		<strong id="url-alart-mgs" class="pull-right"></strong>
		<input type="text" class="input-text form-control" name="shopurl" id="seller-url" value="
		<?php
		if ( ! empty( $postdata['shopurl'] ) ) {
			echo esc_attr( $postdata['shopurl'] );}
		?>
		" required="required" />
		<small><?php echo esc_url( home_url() . '/' . dokan_get_option( 'custom_store_url', 'dokan_general', 'store' ) ); ?>/<strong id="url-alart"></strong></small>
	</p>

	<p class="form-row form-group form-row-wide">
		<label for="shop-phone"><?php esc_html_e( 'Phone Number', 'dokan-lite' ); ?><span class="required">*</span></label>
		<input type="text" class="input-text form-control" name="phone" id="shop-phone" value="
		<?php
		if ( ! empty( $postdata['phone'] ) ) {
			echo esc_attr( $postdata['phone'] );}
		?>
		" required="required" />
	</p>

	<?php
	$show_terms_condition = dokan_get_option( 'enable_tc_on_reg', 'dokan_general' );
	$terms_condition_url  = dokan_get_terms_condition_url();

	if ( 'on' === $show_terms_condition && $terms_condition_url ) {
		?>
		<p class="form-row form-group form-row-wide">
			<input class="tc_check_box" type="checkbox" id="tc_agree" name="tc_agree" required="required">
			<label style="display: inline" for="tc_agree">
			<?php
			echo wp_kses(
				/* translators: terms and conditions link */
				sprintf( esc_html__( 'I have read and agree to the <a target="_blank" href="%s">Terms &amp; Conditions</a>.', 'dokan-lite' ), esc_url( $terms_condition_url ) ),
				array(
					'a' => array(
						'href'   => array(),
						'target' => array(),
					),
				)
			);
			?>
			</label>
		</p>
		<?php
	}

	do_action( 'dokan_seller_registration_field_after' );
	?>
</div>

<?php do_action( 'dokan_reg_form_field' ); ?>

<p class="form-row form-group user-role">
	<input type="radio" name="role" value="customer"<?php checked( $role, 'customer' ); ?> id="login-as-customer">
	<label class="radio" for="login-as-customer"><?php esc_html_e( 'I am a customer', 'dokan-lite' ); ?></label>
	<br>
	<input type="radio" name="role" value="seller"<?php checked( $role, 'seller' ); ?> id="login-as-seller">
	<label class="radio" for="login-as-seller"><?php esc_html_e( 'I am a vendor', 'dokan-lite' ); ?></label>
	<?php do_action( 'dokan_registration_form_role', $role ); ?>
</p>
