<?php
/**
 * The template to display the site logo in the footer
 *
 * @package WordPress
 * @subpackage QUICKLOANS
 * @since QUICKLOANS 1.0.10
 */

// Logo
if (quickloans_is_on(quickloans_get_theme_option('logo_in_footer'))) {
	$quickloans_logo_image = '';
	if (quickloans_get_retina_multiplier(2) > 1)
		$quickloans_logo_image = quickloans_get_theme_option( 'logo_footer_retina' );
	if (empty($quickloans_logo_image)) 
		$quickloans_logo_image = quickloans_get_theme_option( 'logo_footer' );
	$quickloans_logo_text   = get_bloginfo( 'name' );
	if (!empty($quickloans_logo_image) || !empty($quickloans_logo_text)) {
		?>
		<div class="footer_logo_wrap">
			<div class="footer_logo_inner">
				<?php
				if (!empty($quickloans_logo_image)) {
					$quickloans_attr = quickloans_getimagesize($quickloans_logo_image);
					echo '<a href="'.esc_url(home_url('/')).'"><img src="'.esc_url($quickloans_logo_image).'" class="logo_footer_image"'.(!empty($quickloans_attr[3]) ? sprintf(' %s', $quickloans_attr[3]) : '').'></a>' ;
				} else if (!empty($quickloans_logo_text)) {
					echo '<h1 class="logo_footer_text"><a href="'.esc_url(home_url('/')).'">' . esc_html($quickloans_logo_text) . '</a></h1>';
				}
				?>
			</div>
		</div>
		<?php
	}
}
?>