<?php

class Customizer extends \Devmonsta\Libs\Customizer
{

    public function register_controls()
    {

        /**
         * Add parent panels
         */

        $this->add_panel([
            'id'             => 'xs_theme_option_panel',
            'priority'       => 0,
            'theme_supports' => '',
            'title'          => esc_html__('Theme settings', 'qoxag'),
            'description'    => esc_html__('Theme options panel', 'qoxag'),
        ]);


        /*******************************************
         * Header settings here
         ******************************************/
        $this->add_section([
            'id'       => 'xs_header_settings_section',
            'title'    => esc_html__('Header Settings', 'qoxag'),
            'panel'    => 'xs_theme_option_panel',
            'priority' => 1,
        ]);

        /**
         * Header builder switch here
         */
        $this->add_control([
            'id'      => 'header_builder_enable',
            'type'    => 'switcher',
            'default' => 'no',
            'label'   => esc_html__('Header builder Enable ?', 'qoxag'),
            'desc'    => esc_html__('Do you want to enable n in header ?', 'qoxag'),
            'section' => 'xs_header_settings_section',
            'attr'    => ['class' => 'xs_header_builder_switch'],
            'left-choice'  => [
                'no' => esc_html__('No', 'qoxag'),
            ],
            'right-choice' => [
                'yes' => esc_html__('Yes', 'qoxag'),
            ],
        ]);
        
        $this->add_control([
            'id'      => 'header_builder_select_html',
            'section' => 'xs_header_settings_section',
            'type'    => 'html',
            'value'   => '<h2 class="header_builder_edit"><a class="xs_builder_edit_link" style="text-transform: uppercase; color:green; margin: 0 0 10px;"  target="_blank" href="'.esc_url(admin_url('edit.php?post_type=elementskit_template')).'">'. esc_html('Go to Header Builder.'). '</a><h2><h3><a style="text-transform: uppercase; color:#17a2b8" target="_blank" href="https://support.xpeedstudio.com/knowledgebase/customize-carrental-header-and-footer-builder/">'. esc_html__('How to edit header', 'qoxag'). '</a><h3>',
            'attr'    => ['class' => 'xs_header_builder_html'],
            // 'conditions' => [
            //     [
            //         'control_name'  => 'header_builder_enable',
            //         'operator' => '==',
            //         'value'    => "yes",
            //     ]
            // ],
        ]);
        $this->add_control([
            'id'      => 'header_nav_search_section',
            'type'    => 'switcher',
            'default' => 'right-choice',
            'label'   => esc_html__('Search button show', 'qoxag'),
            'desc'    => esc_html__('Do you want to show search button in header?', 'qoxag'),
            'section' => 'xs_header_settings_section',
            'left-choice'  => [
                'no' => esc_html__('No', 'qoxag'),
            ],
            'right-choice' => [
                'yes' => esc_html__('Yes', 'qoxag'),
            ],
        ]);


      
        /*********************************************************
         * General settings
        *********************************************************/
    
        $this->add_section([
            'id'       => 'general_settings_section',
            'title'    => esc_html__( 'General settings', "qoxag" ),
            'panel'    => 'xs_theme_option_panel',
            'priority' => 0
        ]);

        $this->add_control([
            'id'          => 'main_logo',
            'type'        => 'media',
            'section'     => 'general_settings_section',
            'label'       => esc_html__('Main Logo', 'qoxag'),
            'description' => esc_html__('This is default logo. Our most of the menu built with elemnetsKit header builder. Go to header settings->Header builder enable->  and click "edit header content" to change the logo', 'qoxag'),
        ]);

        $this->add_control([
            'id'      => 'preloader_show',
            'type'    => 'switcher',
            'default' => 'no',
            'label'   => esc_html__( 'Preloader show', 'qoxag' ),
            'desc'    => esc_html__( 'Do you want to show preloader on your site ?', 'qoxag' ),
            'section' => 'general_settings_section',
            'left-choice'  => [
                'no' => esc_html__('No', 'qoxag'),
            ],
            'right-choice' => [
                'yes' => esc_html__('Yes', 'qoxag'),
            ],
        ]);

        $this->add_control([
            'id'      => 'preloader_logo',
            'type'    => 'media',
            'section' => 'general_settings_section',
            'label'   => esc_html__( 'Preloader logo', 'qoxag' ),
        ]);

        $this->add_control([
            'id'      => 'blog_reading_pregressbar',
            'type'    => 'switcher',
            'default' => 'no',
            'label'   => esc_html__( 'Reading progressbar', 'qoxag' ),
            'desc'    => esc_html__( 'Do you want to enable reading progressbar?', 'qoxag' ),
            'section' => 'general_settings_section',
            'left-choice'  => [
                'no' => esc_html__('No', 'qoxag'),
            ],
            'right-choice' => [
                'yes' => esc_html__('Yes', 'qoxag'),
            ],
        ]);

        $this->add_control([
            'id'      => 'progressbar_color',
            'label'   => esc_html__('Progressbar Color', 'qoxag'),
            'type'    => 'color-picker',
            'section' => 'general_settings_section',
            'default' => '#FFFFFF',
        ]);

        $this->add_control([
            'id'      => 'blog_reading_progressbar_area',
            'type'    => 'multiselect',
            'value'   => 'post',
            'label' => esc_html__('Reading progressbar area', 'qoxag'),
            'desc'  => esc_html__('Select option for reading progressbar on top ', 'qoxag'),
            'section' => 'general_settings_section',
            'choices' => [
                'post' => esc_html__('Blog Post', 'qoxag'),
                'page' => esc_html__('Blog Page', 'qoxag'),
                'category' => esc_html__('Blog Category', 'qoxag'),
                'all' => esc_html__('All', 'qoxag'),
            ],
        ]);
       
        $this->add_control([
            'id'      => 'general_container_width',
            'type'    => 'switcher',
            'default' => 'no',
            'label'   =>esc_html__( 'Custom Container Width', 'qoxag' ),
            'desc'    => esc_html__( 'Do you want to enable custom container width?', 'qoxag' ),
            'section' => 'general_settings_section',
            'left-choice'  => [
                'no' => esc_html__('No', 'qoxag'),
            ],
            'right-choice' => [
                'yes' => esc_html__('Yes', 'qoxag'),
            ],
        ]);
       
        $this->add_control([
            'id'      => 'container_width_laptop',
            'type'    => 'slider',
            'value' => 960,
            'label'   => esc_html__( 'Custom Container Width Laptop', 'qoxag' ),
            'desc'    => esc_html__( 'Do you want to enable custom container width?', 'qoxag' ),
            'section' => 'general_settings_section',
            'properties' => [
                'min' => 800,
                'max' => 3000,
                'step' => 1, 
            ],
        ]);
        
        $this->add_control([
            'id'      => 'container_width_desktop',
            'type'    => 'slider',
            'value' => 1200,
            'label'   => esc_html__('Custom Container Width Desktop', 'qoxag'),
            'section' => 'general_settings_section',
            'properties' => [
                'min' => 900,
                'max' => 3000,
                'step' => 1, 
            ],
        ]);


        /*********************************************************
         * banner settings
         *********************************************************/

        $this->add_panel([
            'id'             => 'banner_settings_section',
            'title'          => esc_html__( 'Banner settings', "qoxag" ),
            'panel'          => 'xs_theme_option_panel',
            'priority'       => 5,

        ]);


        $this->add_section([
            'id'       => 'banner_page_settings',
            'title'    => esc_html__( 'Page banner', "qoxag" ),
            'panel'    => 'banner_settings_section',

        ]);


        /**
         * page banner control start here
         */

        $this->add_control([
            'id'      => 'page_show_banner',
            'type'    => 'switcher',
            'default' => 'yes',
            'label'   => esc_html__('Show banner?', 'qoxag'),
            'desc'    => esc_html__('Show or hide the banner', 'qoxag'),
            'section' => 'banner_page_settings',
            'left-choice'  => [
                'no' => esc_html__('No', 'qoxag'),
            ],
            'right-choice' => [
                'yes' => esc_html__('Yes', 'qoxag'),
            ],
        ]);

        $this->add_control([
            'id'      => 'page_show_breadcrumb',
            'type'    => 'switcher',
            'default' => 'right-choice',
            'label'   => esc_html__('Show Breadcrumb?', 'qoxag'),
            'desc'    => esc_html__('Show or hide the Breadcrumb', 'qoxag'),
            'section' => 'banner_page_settings',
            'left-choice'  => [
                'no' => esc_html__('No', 'qoxag'),
            ],
            'right-choice' => [
                'yes' => esc_html__('Yes', 'qoxag'),
            ],
        ]);

        $this->add_control([
            'id'    => 'page_banner_title',
            'type'  => 'text',
            'label' => esc_html__('Banner Title', 'qoxag'),
            'section' => 'banner_page_settings',
        ]);

        $this->add_control([
            'id'      => 'banner_page_image',
            'type'    => 'media',
            'section' => 'banner_page_settings',
            'label'   => esc_html__('Banner Background', 'qoxag'),
        ]);
        $this->add_control([
            'id'       => 'page_banner_title_color',
            'section'  => 'banner_page_settings',
            'type'     => 'color-picker',
            'default' => '#fff',

            'label'    => esc_html__('Title Color', 'qoxag'),
        ]);
        
        /**
         * blog banner panel
         */

        $this->add_section([
            'id'       => 'banner_blog_settings',
            'title'    => esc_html__( 'Blog banner', "qoxag" ),
            'panel'    => 'banner_settings_section',
        ]);

        /**
         * blog banner control start here
         */

        $this->add_control([
            'id'      => 'blog_show_banner',
            'type'    => 'switcher',
            'default' => 'yes',
            'label'   => esc_html__('Show banner?', 'qoxag'),
            'desc'    => esc_html__('Show or hide the banner', 'qoxag'),
            'section' => 'banner_blog_settings',
            'left-choice'  => [
                'no' => esc_html__('No', 'qoxag'),
            ],
            'right-choice' => [
                'yes' => esc_html__('Yes', 'qoxag'),
            ],
        ]);

        $this->add_control([
            'id'      => 'blog_show_breadcrumb',
            'type'    => 'switcher',
            'default' => 'right-choice',
            'label'   => esc_html__('Show Breadcrumb?', 'qoxag'),
            'desc'    => esc_html__('Show or hide the Breadcrumb', 'qoxag'),
            'section' => 'banner_blog_settings',
            'left-choice'  => [
                'no' => esc_html__('No', 'qoxag'),
            ],
            'right-choice' => [
                'yes' => esc_html__('Yes', 'qoxag'),
            ],
        ]);

        $this->add_control([
            'id'    => 'blog_banner_title',
            'type'  => 'text',
            'default' => esc_html__( 'Blog', 'qoxag' ),
            'label' => esc_html__('Banner Title', 'qoxag'),
            'section' => 'banner_blog_settings',
        ]);
        
        $this->add_control([
            'id'      => 'banner_blog_image',
            'type'    => 'media',
            'section' => 'banner_blog_settings',
            'label'   => esc_html__('Banner Background', 'qoxag'),
        ]);


        $this->add_control([
            'id'       => 'banner_title_color',
            'section'  => 'banner_blog_settings',
            'type'     => 'color-picker',
            'default' => '#fff',

            'label'    => esc_html__('Title Color', 'qoxag'),
        ]);
        
       

        /**
         * blog single banner panel
         */

        $this->add_section([
            'id'       => 'banner_blog_single_settings',
            'title'    => esc_html__( 'Blog single banner', "qoxag" ),
            'panel'    => 'banner_settings_section',
        ]);

        /**
         * blog banner single control start here
         */

        $this->add_control([
            'id'      => 'blog_single_show_banner',
            'type'    => 'switcher',
            'default' => 'no',
            'label'   => esc_html__('Show banner?', 'qoxag'),
            'desc'    => esc_html__('Show or hide the banner', 'qoxag'),
            'section' => 'banner_blog_single_settings',
            'left-choice'  => [
                'no' => esc_html__('No', 'qoxag'),
            ],
            'right-choice' => [
                'yes' => esc_html__('Yes', 'qoxag'),
            ],
        ]);

        $this->add_control([
            'id'      => 'blog_single_show_breadcrumb',
            'type'    => 'switcher',
            'default' => 'right-choice',
            'label'   => esc_html__('Show Breadcrumb?', 'qoxag'),
            'desc'    => esc_html__('Show or hide the Breadcrumb', 'qoxag'),
            'section' => 'banner_blog_single_settings',
            'left-choice'  => [
                'no' => esc_html__('No', 'qoxag'),
            ],
            'right-choice' => [
                'yes' => esc_html__('Yes', 'qoxag'),
            ],
        ]);

        $this->add_control([
            'id'      => 'banner_blog_single_image',
            'type'    => 'media',
            'section' => 'banner_blog_single_settings',
            'label'   => esc_html__('Banner Background', 'qoxag'),
        ]);

        $this->add_control([
            'id'       => 'details_banner_title_color',
            'section'  => 'banner_blog_single_settings',
            'type'     => 'color-picker',
            'default' => '#fff',
            'label'    => esc_html__('Title Color', 'qoxag'),
        ]);        

         /**
         * woo banner panel
         */

        $this->add_section([
            'id'       => 'banner_woo_settings',
            'title'    => esc_html__( 'WooCommerce banner', "qoxag" ),
            'panel'    => 'banner_settings_section',
        ]);

        /**
         * blog banner control start here
         */

        $this->add_control([
            'id'      => 'woo_show_banner',
            'type'    => 'switcher',
            'default' => 'yes',
            'label'   => esc_html__('Show banner?', 'qoxag'),
            'desc'    => esc_html__('Show or hide the banner', 'qoxag'),
            'section' => 'banner_woo_settings',
            'left-choice'  => [
                'no' => esc_html__('No', 'qoxag'),
            ],
            'right-choice' => [
                'yes' => esc_html__('Yes', 'qoxag'),
            ],
        ]);

        $this->add_control([
            'id'      => 'woo_show_breadcrumb',
            'type'    => 'switcher',
            'default' => 'right-choice',
            'label'   => esc_html__('Show Breadcrumb?', 'qoxag'),
            'desc'    => esc_html__('Show or hide the Breadcrumb', 'qoxag'),
            'section' => 'banner_woo_settings',
            'left-choice'  => [
                'no' => esc_html__('No', 'qoxag'),
            ],
            'right-choice' => [
                'yes' => esc_html__('Yes', 'qoxag'),
            ],
        ]);

        $this->add_control([
            'id'    => 'woo_banner_title',
            'type'  => 'text',
            'default' => esc_html__( 'Products', 'qoxag' ),
            'label' => esc_html__('Banner Title', 'qoxag'),
            'section' => 'banner_woo_settings',
        ]);
        
        $this->add_control([
            'id'      => 'banner_woo_image',
            'type'    => 'media',
            'section' => 'banner_woo_settings',
            'label'   => esc_html__('Banner Background', 'qoxag'),
        ]);


        $this->add_control([
            'id'       => 'woo_banner_title_color',
            'section'  => 'banner_woo_settings',
            'type'     => 'color-picker',
            'default' => '#fff',

            'label'    => esc_html__('Title Color', 'qoxag'),
        ]);
        
    

        /***********************************
         * Typography settings here
         ************************************/
        
        $this->add_section([
            'id'       => 'typography_settings_section',
            'title'    => esc_html__('Style settings', 'qoxag'),
            'panel'    => 'xs_theme_option_panel',
            'priority' => 0,

        ]);

        $this->add_control([
            'id'      => 'body_box_layout',
            'type'    => 'switcher',
            'default' => 'no',
            'label'   => esc_html__('Body box layout?', 'qoxag'),
            'desc'    => esc_html__('Do you want to turn on box layout?', 'qoxag'),
            'section' => 'typography_settings_section',
            'attr'    => '',
            'left-choice'  => [
                'no' => esc_html__('No', 'qoxag'),
            ],
            'right-choice' => [
                'yes' => esc_html__('Yes', 'qoxag'),
            ],
        ]);
       
        $this->add_control([
            'id'      => 'body_box_bg_image',
            'type'    => 'media',
            'section' => 'typography_settings_section',
            'label'   => esc_html__('Background image', 'qoxag'),
            'desc'    => esc_html__('Background image for box layout', 'qoxag'),
        ]);

        $this->add_control([
            'id'      => 'style_theme_setting',
            'type'    => 'switcher',
            'default' => 'no',
            'label'   => esc_html__( 'Theme dark style?', 'qoxag' ),
            'desc'    =>esc_html__( 'Do you want to use theme style?', 'qoxag' ),
            'section' => 'typography_settings_section',
            'left-choice'  => [
                'no' => esc_html__('No', 'qoxag'),
            ],
            'right-choice' => [
                'yes' => esc_html__('Yes', 'qoxag'),
            ],
        ]);

        $this->add_control([
            'id'      => 'style_darklight_mode',
            'type'    => 'switcher',
            'default' => 'no',
            'label'   => esc_html__( 'Show Dark/Light Icon?', 'qoxag' ),
            'desc'    => esc_html__( 'Do you want to show dark/light icon?', 'qoxag' ),
            'section' => 'typography_settings_section',
            'left-choice'  => [
                'no' => esc_html__('No', 'qoxag'),
            ],
            'right-choice' => [
                'yes' => esc_html__('Yes', 'qoxag'),
            ],
        ]);

        /**
         * body background control
         */
        $this->add_control([
            'id'      => 'style_body_bg',
            'label'   => esc_html__('Body background', 'qoxag'),
            'type'    => 'color-picker',
            'section' => 'typography_settings_section',
            'default' => '#FFFFFF',
        ]);

        /**
         * primary color control
         */
        $this->add_control([
            'id'      => 'style_primary',
            'label'      => esc_html__('Primary color', 'qoxag'),
            'type'    => 'color-picker',
            'section' => 'typography_settings_section',
            'default' => '#4e65ff',
        ]);

        /**
         * secondary color control
         */
        $this->add_control([
            'id'      => 'secondary_color',
            'label'      => esc_html__('Secondary color', 'qoxag'),
            'type'    => 'color-picker',
            'section' => 'typography_settings_section',
            'default' => '#041A57',
        ]);

        /**
         * Control for body Typography Input
         */
        $this->add_control([
            'id'         => 'body_font',
            'section'    => 'typography_settings_section',
            'type'       => 'typography',
            'value'      => [
                'family'         => 'Inter',
                'weight'         => 400,
                'size'           => 16,
                'line_height'    => 26,
                'color'          => '#3a3d43',
                'letter_spacing' => 0
            ],
            'components' => [
                'family'         => true,
                'size'           => true,
                'line-height'    => true,
                'letter-spacing' => true,
                'weight'         => true,
                'color'          => true,
            ],
            'label'      => esc_html__('Body Typhography', 'qoxag'),
        ]);

        /**
         * Control for H1 Typography Input
         */
        $this->add_control([
            'id'         => 'heading_font_one',
            'section'    => 'typography_settings_section',
            'type'       => 'typography',
            'value'      => [
                'family'         => 'Zilla Slab',
                'weight'         => 700,
                'size'           => 36,
            ],
            'components' => [
                'family'         => true,
                'size'           => true,
                'line-height'    => true,
                'letter-spacing' => true,
                'weight'         => true,
                'color'          => true,
            ],
            'label'      => esc_html__('Heading H1 Typhography', 'qoxag'),
        ]);

        /**
         * Control for H2 Typography Input
         */
        $this->add_control([
            'id'         => 'heading_font_two',
            'section'    => 'typography_settings_section',
            'type'       => 'typography',
            'value'      => [
                'family'         => 'Zilla Slab',
                'weight'         => 700,
                'size'           => 30,
            ],
            'components' => [
                'family'         => true,
                'size'           => true,
                'line-height'    => true,
                'letter-spacing' => true,
                'weight'         => true,
                'color'          => true,
            ],
            'label'      => esc_html__('Heading H2 Typhography', 'qoxag'),
        ]);

        /**
         * Control for H3 Typography Input
         */
        $this->add_control([
            'id'         => 'heading_font_three',
            'section'    => 'typography_settings_section',
            'type'       => 'typography',
            'value'      => [
                'family'         => 'Zilla Slab',
                'weight'         => 700,
                'size'           => 24,
            ],
            'components' => [
                'family'         => true,
                'size'           => true,
                'line-height'    => true,
                'letter-spacing' => true,
                'weight'         => true,
                'color'          => true,
            ],
            'label'      => esc_html__('Heading H3 Typhography', 'qoxag'),
        ]);

        /**
         * Control for H4 Typography Input
         */
        $this->add_control([
            'id'         => 'heading_font_four',
            'section'    => 'typography_settings_section',
            'type'       => 'typography',
            'value'      => [
                'family'         => 'Zilla Slab',
                'weight'         => 700,
                'size'           => 18,
            ],
            'components' => [
                'family'         => true,
                'size'           => true,
                'line-height'    => true,
                'letter-spacing' => true,
                'weight'         => true,
                'color'          => true,
            ],
            'label'      => esc_html__('Heading H4 Typhography', 'qoxag'),
        ]);

        /**
         * Control for H5 Typography Input
         */
        $this->add_control([
            'id'         => 'heading_font_five',
            'section'    => 'typography_settings_section',
            'type'       => 'typography',
            'value'      => [
                'family'         => 'Zilla Slab',
                'weight'         => 700,
                'size'           => 16,
            ],
            'components' => [
                'family'         => true,
                'size'           => true,
                'line-height'    => true,
                'letter-spacing' => true,
                'weight'         => true,
                'color'          => true,
            ],
            'label'      => esc_html__('Heading H5 Typhography', 'qoxag'),
        ]);

        /**
         * Control for H6 Typography Input
         */
        $this->add_control([
            'id'         => 'heading_font_six',
            'section'    => 'typography_settings_section',
            'type'       => 'typography',
            'value'      => [
                'family'         => 'Zilla Slab',
                'weight'         => 700,
                'size'           => 14,
            ],
            'components' => [
                'family'         => true,
                'size'           => true,
                'line-height'    => true,
                'letter-spacing' => true,
                'weight'         => true,
                'color'          => true,
            ],
            'label'      => esc_html__('Heading H6 Typhography', 'qoxag'),
        ]);


        /**
         * Blog settings here
         */
        $this->add_section([
            'id'       => 'blog_settings_section',
            'title'    => esc_html__('Blog settings', 'qoxag'),
            'panel'    => 'xs_theme_option_panel',
            'priority' => 10,
        ]);

        /**
         * Blog settings body controls here
         */
        $this->add_control([
            'id'      => 'blog_sidebar',
            'type'    => 'select',
            'value'   => 'right-sidebar',
            'label' => esc_html__('Sidebar', 'qoxag'),
            'section' => 'blog_settings_section',
            'choices' => [
                'no-sidebar' => esc_html__('No sidebar', 'qoxag'),
                'left-sidebar' => esc_html__('Left Sidebar', 'qoxag'),
                'right-sidebar' => esc_html__('Right Sidebar', 'qoxag'),
            ],
        ]);

        

        $this->add_control([
            'id'      => 'blog_sticky_sidebar',
            'type'    => 'switcher',
            'default' => 'no',
            'label'   => esc_html__( 'Blog sticky sidebar', 'qoxag' ),
            'desc'    => esc_html__( 'Do you want to enable sticky sidebar?', 'qoxag' ),
            'section' => 'blog_settings_section',
            'left-choice'  => [
                'no' => esc_html__('No', 'qoxag'),
            ],
            'right-choice' => [
                'yes' => esc_html__('Yes', 'qoxag'),
            ],
        ]);
        

        $this->add_control([
            'id'      => 'blog_author_show',
            'type'    => 'switcher',
            'default' => 'yes',
            'label'   => esc_html__('Blog author', 'qoxag'),
            'desc'    => esc_html__('Do you want to show blog author?', 'qoxag'),
            'section' => 'blog_settings_section',
            'left-choice'  => [
                'no' => esc_html__('No', 'qoxag'),
            ],
            'right-choice' => [
                'yes' => esc_html__('Yes', 'qoxag'),
            ],
        ]);

        $this->add_control([
            'id'      => 'blog_date_show',
            'type'    => 'switcher',
            'default' => 'yes',
            'label'   => esc_html__('Blog Date Show', 'qoxag'),
            'desc'    => esc_html__('Do you want to show blog Date?', 'qoxag'),
            'section' => 'blog_settings_section',
            'left-choice'  => [
                'no' => esc_html__('No', 'qoxag'),
            ],
            'right-choice' => [
                'yes' => esc_html__('Yes', 'qoxag'),
            ],
        ]);

        $this->add_control([
            'id'      => 'blog_category_show',
            'type'    => 'switcher',
            'default' => 'yes',
            'label'   => esc_html__('Category Show', 'qoxag'),
            'desc'    => esc_html__('Do you want to show blog Category?', 'qoxag'),
            'section' => 'blog_settings_section',
            'left-choice'  => [
                'no' => esc_html__('No', 'qoxag'),
            ],
            'right-choice' => [
                'yes' => esc_html__('Yes', 'qoxag'),
            ],
        ]);

        $this->add_control([
            'id'      => 'blog_view_count_show',
            'type'    => 'switcher',
            'default' => 'no',
            'label'   => esc_html__('View Count Show', 'qoxag'),
            'desc'    => esc_html__('Do you want to show blog view count?', 'qoxag'),
            'section' => 'blog_settings_section',
            'left-choice'  => [
                'no' => esc_html__('No', 'qoxag'),
            ],
            'right-choice' => [
                'yes' => esc_html__('Yes', 'qoxag'),
            ],
        ]);

        $this->add_control([
            'id'      => 'blog_reading_time_show',
            'type'    => 'switcher',
            'default' => 'no',
            'label'   => esc_html__('Reading Time Show', 'qoxag'),
            'desc'    => esc_html__('Do you want to show blog reading time?', 'qoxag'),
            'section' => 'blog_settings_section',
            'left-choice'  => [
                'no' => esc_html__('No', 'qoxag'),
            ],
            'right-choice' => [
                'yes' => esc_html__('Yes', 'qoxag'),
            ],
        ]);

        $this->add_control([
            'id'      => 'qoxag_categry_title_lenght',
            'type'    => 'text',
            'default' => 35,
            'label'   => esc_html__('Title Length (Archive Page)', 'qoxag'),
            'desc'    => esc_html__('You can limit post title in category and tag page', 'qoxag'),

            'section' => 'blog_settings_section',
        ]);
        $this->add_control([
            'id'      => 'qoxag_blog_post_desc_show',
            'type'    => 'switcher',
            'default' => 'yes',
            'label'   => esc_html__('Show Description?', 'qoxag'),
            'desc'    => esc_html__('Show or hide the description', 'qoxag'),
            'section' => 'blog_settings_section',
            'left-choice'  => [
                'no' => esc_html__('No', 'qoxag'),
            ],
            'right-choice' => [
                'yes' => esc_html__('Yes', 'qoxag'),
            ],
        ]);

        $this->add_control([
            'id'      => 'qoxag_categry_post_desc_lenght',
            'type'    => 'text',
            'default' => 20,
            'label'   => esc_html__('Description Length (Archive page)', 'qoxag'),
            'desc'    => esc_html__('You can limit post desc in category and tag page', 'qoxag'),
            'section' => 'blog_settings_section',
        ]);

        $this->add_control([
            'id'      => 'qoxag_number_of_categries',
            'type'    => 'text',
            'default' => 100,
            'label'   => esc_html__('Number of Categories', 'qoxag'),
            'desc'    => esc_html__('You can set number of categories', 'qoxag'),
            'section' => 'blog_settings_section',
        ]);

        $this->add_control([
            'id'      => 'show_review_rating',
            'type'    => 'switcher',
            'default' => 'no',
            'label'   => esc_html__('Show Review Rating', 'qoxag'),
            'desc'    => esc_html__('Do you want to show blog review rating?', 'qoxag'),
            'section' => 'blog_settings_section',
            'left-choice'  => [
                'no' => esc_html__('No', 'qoxag'),
            ],
            'right-choice' => [
                'yes' => esc_html__('Yes', 'qoxag'),
            ],
        ]);


        /**
         * Blog settings here
         */
        $this->add_section([
            'id'       => 'blog_details_settings_section',
            'title'    => esc_html__('Blog Details settings', 'qoxag'),
            'panel'    => 'xs_theme_option_panel',
            'priority' => 10,
        ]);

        $this->add_control( [
            'name'    => 'qoxag_blog_details_layout',
            'id'      => 'qoxag_blog_details_layout',
            'section' => 'blog_details_settings_section',
            'type'    => 'image-picker',
            'value'   => 'style1',
            'attr'    => [
                'class'    => 'custom-class',
                'data-foo' => 'bar',
            ],
            'label'   => esc_html__( 'Post Header Layout', 'qoxag' ),
            'desc'    => esc_html__( 'Select single post header layout', 'qoxag' ),
            'choices' => [
                'style1' => [
                    'small' => get_template_directory_uri() . '/assets/images/admin/post-header/min-style1.png',
                    'large' => get_template_directory_uri() . '/assets/images/admin/post-header/min-style1.png',
                ],
                'style2' => [
                    'small' => get_template_directory_uri() . '/assets/images/admin/post-header/min-style1.png',
                    'large' => get_template_directory_uri() . '/assets/images/admin/post-header/min-style1.png',
                ],
                'style3' => [
                    'small' => get_template_directory_uri() . '/assets/images/admin/post-header/min-style2.png',
                    'large' => get_template_directory_uri() . '/assets/images/admin/post-header/min-style2.png',
                ],
                'style4' => [
                    'small' => get_template_directory_uri() . '/assets/images/admin/post-header/min-style2.png',
                    'large' => get_template_directory_uri() . '/assets/images/admin/post-header/min-style2.png',
                ],
            ],
        ] );

        /**
         * Blog settings body controls here
         */
        $this->add_control([
            'id'      => 'blog_details_sidebar',
            'type'    => 'select',
            'value'   => 'no-sidebar',
            'label' => esc_html__('Sidebar', 'qoxag'),
            'section' => 'blog_details_settings_section',
            'choices' => [
                'no-sidebar' => esc_html__('No sidebar', 'qoxag'),
                'left-sidebar' => esc_html__('Left Sidebar', 'qoxag'),
                'right-sidebar' => esc_html__('Right Sidebar', 'qoxag'),
            ],
        ]);


        $this->add_control([
            'id'      => 'blog_details_author_show',
            'type'    => 'switcher',
            'default' => 'yes',
            'label'   => esc_html__('Blog author', 'qoxag'),
            'desc'    => esc_html__('Do you want to show blog author?', 'qoxag'),
            'section' => 'blog_details_settings_section',
            'left-choice'  => [
                'no' => esc_html__('No', 'qoxag'),
            ],
            'right-choice' => [
                'yes' => esc_html__('Yes', 'qoxag'),
            ],
        ]);

        $this->add_control([
            'id'      => 'blog_details_date_show',
            'type'    => 'switcher',
            'default' => 'yes',
            'label'   => esc_html__('Blog Date Show', 'qoxag'),
            'desc'    => esc_html__('Do you want to show blog Date?', 'qoxag'),
            'section' => 'blog_details_settings_section',
            'left-choice'  => [
                'no' => esc_html__('No', 'qoxag'),
            ],
            'right-choice' => [
                'yes' => esc_html__('Yes', 'qoxag'),
            ],
        ]);

        $this->add_control([
            'id'      => 'blog_details_category_show',
            'type'    => 'switcher',
            'default' => 'yes',
            'label'   => esc_html__('Category Show', 'qoxag'),
            'desc'    => esc_html__('Do you want to show blog Category?', 'qoxag'),
            'section' => 'blog_details_settings_section',
            'left-choice'  => [
                'no' => esc_html__('No', 'qoxag'),
            ],
            'right-choice' => [
                'yes' => esc_html__('Yes', 'qoxag'),
            ],
        ]);
        $this->add_control([
            'id'      => 'blog_details_Comments_show',
            'type'    => 'switcher',
            'default' => 'yes',
            'label'   => esc_html__('Comments Show', 'qoxag'),
            'desc'    => esc_html__('Do you want to show blog Comments?', 'qoxag'),
            'section' => 'blog_details_settings_section',
            'left-choice'  => [
                'no' => esc_html__('No', 'qoxag'),
            ],
            'right-choice' => [
                'yes' => esc_html__('Yes', 'qoxag'),
            ],
        ]);

        $this->add_control([
            'id'      => 'blog_single_view_count_show',
            'type'    => 'switcher',
            'default' => 'no',
            'label'   => esc_html__('View Count Show', 'qoxag'),
            'desc'    => esc_html__('Do you want to show blog view count?', 'qoxag'),
            'section' => 'blog_details_settings_section',
            'left-choice'  => [
                'no' => esc_html__('No', 'qoxag'),
            ],
            'right-choice' => [
                'yes' => esc_html__('Yes', 'qoxag'),
            ],
        ]);

        $this->add_control([
            'id'      => 'blog_single_reading_time_show',
            'type'    => 'switcher',
            'default' => 'no',
            'label'   => esc_html__('Reading Time Show', 'qoxag'),
            'desc'    => esc_html__('Do you want to show blog reading time?', 'qoxag'),
            'section' => 'blog_details_settings_section',
            'left-choice'  => [
                'no' => esc_html__('No', 'qoxag'),
            ],
            'right-choice' => [
                'yes' => esc_html__('Yes', 'qoxag'),
            ],
        ]);
        
        $this->add_control([
            'id'      => 'blog_single_font_zoom',
            'type'    => 'switcher',
            'default' => 'no',
            'label'   => esc_html__('Font Zoom In/Out', 'qoxag'),
            'desc'    => esc_html__('Do you want to show blog details font zoom?', 'qoxag'),
            'section' => 'blog_details_settings_section',
            'left-choice'  => [
                'no' => esc_html__('No', 'qoxag'),
            ],
            'right-choice' => [
                'yes' => esc_html__('Yes', 'qoxag'),
            ],
        ]);

        $this->add_control([
            'id'      => 'blog_single_print',
            'type'    => 'switcher',
            'default' => 'no',
            'label'   => esc_html__('Print Option', 'qoxag'),
            'desc'    => esc_html__('Do you want to show blog details print option?', 'qoxag'),
            'section' => 'blog_details_settings_section',
            'left-choice'  => [
                'no' => esc_html__('No', 'qoxag'),
            ],
            'right-choice' => [
                'yes' => esc_html__('Yes', 'qoxag'),
            ],
        ]);

        $this->add_control([
            'id'      => 'category_on_top',
            'type'    => 'switcher',
            'default' => 'no',
            'label'   => esc_html__('Category on Top', 'qoxag'),
            'desc'    => esc_html__('Do you want to show category on top of meta?', 'qoxag'),
            'section' => 'blog_details_settings_section',
            'left-choice'  => [
                'no' => esc_html__('No', 'qoxag'),
            ],
            'right-choice' => [
                'yes' => esc_html__('Yes', 'qoxag'),
            ],
        ]);

        $this->add_control([
            'id'      => 'qoxag_single_number_of_categries',
            'type'    => 'text',
            'default' => 100,
            'label'   => esc_html__('Number of Categories', 'qoxag'),
            'desc'    => esc_html__('You can set number of categories', 'qoxag'),
            'section' => 'blog_details_settings_section',
        ]);

        $this->add_control([
            'id'      => 'blog_related_post',
            'type'    => 'switcher',
            'default' => 'no',
            'label'      => esc_html__('Blog related post', 'qoxag'),
            'desc'      => esc_html__('Do you want to show single blog related post?', 'qoxag'),
            'section' => 'blog_details_settings_section',
            'left-choice'  => [
                'no' => esc_html__('No', 'qoxag'),
            ],
            'right-choice' => [
                'yes' => esc_html__('Yes', 'qoxag'),
            ],
        ]);

        $this->add_control([
            'id'      => 'blog_related_heading',
            'type'    => 'text',
            'label'   => esc_html__('Related title', 'qoxag'),
            'default' => 'Related',
            'section' => 'blog_details_settings_section',            
        ]);

        $this->add_control([
            'id'      => 'blog_related_subheading',
            'type'    => 'text',
            'label'   => esc_html__('Related subtitle', 'qoxag'),
            'default' => 'Stories for you',
            'section' => 'blog_details_settings_section',            
        ]);

        $this->add_control([
            'id'      => 'blog_related_post_number',
            'type'    => 'text',
            'label'   => esc_html__('Related post count', 'qoxag'),
            'default' => '3',
            'section' => 'blog_details_settings_section',            
        ]);

        $this->add_control([
            'id'      => 'blog_details_social_share_show',
            'type'    => 'switcher',
            'default' => 'yes',
            'label'   => esc_html__('Blog Social Share', 'qoxag'),
            'desc'    => esc_html__('Do you want to show blog social share?', 'qoxag'),
            'section' => 'blog_details_settings_section',
            'left-choice'  => [
                'no' => esc_html__('No', 'qoxag'),
            ],
            'right-choice' => [
                'yes' => esc_html__('Yes', 'qoxag'),
            ],
        ]);

        $this->add_control([
            'id'      => 'blog_single_infinite_scroll',
            'type'    => 'switcher',
            'default' => 'left-choice',
            'label'   => esc_html__('Infinite Scroll?', 'qoxag'),
            'desc'    => esc_html__('Do you want to turn on infinite scroll in Single post', 'qoxag'),
            'section' => 'blog_details_settings_section',
            'left-choice'  => [
                'no' => esc_html__('No', 'qoxag'),
            ],
            'right-choice' => [
                'yes' => esc_html__('Yes', 'qoxag'),
            ],
        ]);

        $this->add_control([
            'id'    => 'blog_single_infinite_scroll_items',
            'type'  => 'text',
            'default' => '3',
            'label' => esc_html__('Number of Posts to show', 'qoxag'),
            'section' => 'blog_details_settings_section',
        ]);

        $this->add_control([
            'id'      => 'show_review_rating_single',
            'type'    => 'switcher',
            'default' => 'no',
            'label'   => esc_html__('Show Review Rating', 'qoxag'),
            'desc'    => esc_html__('Do you want to show blog review rating?', 'qoxag'),
            'section' => 'blog_settings_section',
            'left-choice'  => [
                'no' => esc_html__('No', 'qoxag'),
            ],
            'right-choice' => [
                'yes' => esc_html__('Yes', 'qoxag'),
            ],
        ]);

        $this->add_control([
            'id'      => 'blog_details_tags_show',
            'type'    => 'switcher',
            'default' => 'yes',
            'label'   => esc_html__('Tags Show', 'qoxag'),
            'desc'    => esc_html__('Do you want to show tags?', 'qoxag'),
            'section' => 'blog_details_settings_section',
            'left-choice'  => [
                'no' => esc_html__('No', 'qoxag'),
            ],
            'right-choice' => [
                'yes' => esc_html__('Yes', 'qoxag'),
            ],
        ]);

        /**
         * Category Settings here
         */

        $this->add_section([
            'id'       => 'category_details_settings_section',
            'title'    => esc_html__('Category Settings', 'qoxag'),
            'panel'    => 'xs_theme_option_panel',
            'priority' => 0,
        ]);

        $this->add_control( [
            'name'    => 'qoxag_blog_category_layout',
            'id'      => 'qoxag_blog_category_layout',
            'section' => 'category_details_settings_section',
            'type'    => 'image-picker',
            'value'   => 'style1',
            'attr'    => [
                'class'    => 'custom-class',
                'data-foo' => 'bar',
            ],
            'label'   => esc_html__( 'Category Layout', 'qoxag' ),
            'desc'    => esc_html__( 'Select category layout', 'qoxag' ),
            'choices' => [
                'style1' => [
                    'small' => get_template_directory_uri() . '/assets/images/admin/category/category_min1.png',
                    'large' => get_template_directory_uri() . '/assets/images/admin/category/category_min1.png',
                ],
                'style2' => [
                    'small' => get_template_directory_uri() . '/assets/images/admin/category/category_min2.png',
                    'large' => get_template_directory_uri() . '/assets/images/admin/category/category_min2.png',
                ],
                'style3' => [
                    'small' => get_template_directory_uri() . '/assets/images/admin/category/category_min2.png',
                    'large' => get_template_directory_uri() . '/assets/images/admin/category/category_min2.png',
                ],
                'style4' => [
                    'small' => get_template_directory_uri() . '/assets/images/admin/category/category_min2.png',
                    'large' => get_template_directory_uri() . '/assets/images/admin/category/category_min2.png',
                ],
                'style5' => [
                    'small' => get_template_directory_uri() . '/assets/images/admin/category/category_min2.png',
                    'large' => get_template_directory_uri() . '/assets/images/admin/category/category_min2.png',
                ],
                'style6' => [
                    'small' => get_template_directory_uri() . '/assets/images/admin/category/category_min1.png',
                    'large' => get_template_directory_uri() . '/assets/images/admin/category/category_min1.png',
                ],
            ],
        ] );


        /**
         * Footer Settings here
         */
        $this->add_section([
            'id'       => 'footer_settings_section',
            'title'    => esc_html__('Footer settings', 'qoxag'),
            'panel'    => 'xs_theme_option_panel',
            'priority' => 10,
        ]);

        /**
         * Header builder switch here
         */
        $this->add_control([
            'id'      => 'footer_builder_control_enable',
            'type'    => 'switcher',
            'default' => 'no',
            'label'   => esc_html__('Footer builder Enable ?', 'qoxag'),
            'desc'    => esc_html__('Do you want to enable footer builder ?', 'qoxag'),
            'section' => 'footer_settings_section',
            'attr'    => ['class' => 'xs_footer_builder_switch'],
            'left-choice'  => [
                'no' => esc_html__('No', 'qoxag'),
            ],
            'right-choice' => [
                'yes' => esc_html__('Yes', 'qoxag'),
            ],
        ]);

        $this->add_control([
            'id'      => 'footer_builder_select_html',
            'section' => 'footer_settings_section',
            'type'    => 'html',
            'value'   => '<h2 class="header_builder_edit"><a class="xs_builder_edit_link" style="text-transform: uppercase; color:green; margin: 0 0 10px;"  target="_blank" href="'.esc_url(admin_url('edit.php?post_type=elementskit_template')).'">'. esc_html('Go to Footer Builder.'). '</a><h2><h3><a style="text-transform: uppercase; color:#17a2b8" target="_blank" href="https://support.xpeedstudio.com/knowledgebase/customize-carrental-header-and-footer-builder/">'. esc_html__('How to edit footer', 'qoxag'). '</a><h3>',
            'attr'    => ['class' => 'xs_footer_builder_html'],
            // 'conditions' => [
            //     [
            //         'control_name'  => 'footer_builder_control_enable',
            //         'operator' => '==',
            //         'value'    => "yes",
            //     ]
            // ],
        ]);

        /**
         * Footer bg control
         * */
        $this->add_control([
            'id'       => 'footer_bg_color',
            'label'    => esc_html__('Background color', 'qoxag'),
            'type'     => 'color-picker',
            'section'  => 'footer_settings_section',
            'default'  => '#f8f8fc',
            'desc'     => esc_html__('Footer background color of rgba-color-picker goes here', 'qoxag'),
        ]);

        /**
         * Footer text control
         * */
        $this->add_control([
            'id'      => 'footer_text_color',
            'label'   => esc_html__('Text color', 'qoxag'),
            'type'    => 'color-picker',
            'section' => 'footer_settings_section',
            'default' => '#666',
            'desc'    => esc_html__('You can change the text color with rgba color or solid color', 'qoxag'),
        ]);

        /**
         * Footer link control
         * */
        $this->add_control([
            'id'         => 'footer_link_color',
            'label'      => esc_html__('Link Color', 'qoxag'),
            'type'       => 'color-picker',
            'section'    => 'footer_settings_section',
            'default'    => '#666',
            'desc'       => esc_html__('You can change the link color with rgba color or solid color', 'qoxag'),
        ]);

        /**
         * Footer widget title control
         * */
        $this->add_control([
            'id'        => 'footer_widget_title_color',
            'label'     => esc_html__('Widget Title Color', 'qoxag'),
            'type'      => 'color-picker',
            'section'   => 'footer_settings_section',
            'default'   => '#142355',
            'desc'      => esc_html__('You can change the widget title color with rgba color or solid color', 'qoxag'),
        ]);

        /**
         * Footer copyright bg control
         * */
        $this->add_control([
            'id'        => 'copyright_bg_color',
            'label'     => esc_html__('Copyright Background Color', 'qoxag'),
            'type'      => 'color-picker',
            'section'   => 'footer_settings_section',
            'default'   => '#09090a',
            'desc'      => esc_html__('You can change the copyright background color with rgba color or solid color', 'qoxag'),

        ]);

        /**
         * Footer copyright color control
         * */
        $this->add_control([
            'id'        => 'footer_copyright_color',
            'label'     => esc_html__('Copyright Text Color', 'qoxag'),
            'type'      => 'color-picker',
            'default'   => '#FFFFFF',
            'section'   => 'footer_settings_section',
            'desc'      => esc_html__('You can change the copyright tet color with rgba color or solid color', 'qoxag'),
        ]);

        /**
         * Footer copyright text control
         * */
        $this->add_control([
            'id'          => 'footer_copyright',
            'type'        => 'textarea',
            'section'     => 'footer_settings_section',
            'label'       => esc_html__('Copyright text', 'qoxag'),
            'description' => esc_html__('This text will be shown at the footer of all pages.', 'qoxag'),
        ]);

        /**
         * Footer spacing top control
         * */
        $this->add_control([
            'id'          => 'footer_padding_top',
            'label'       => esc_html__('Footer Padding Top', 'qoxag'),
            'description' => esc_html__('Use Footer Padding Top', 'qoxag'),
            'type'        => 'text',
            'section'     => 'footer_settings_section',
            'default'     => '100px',
        ]);

        /**
         * Footer spaceing bottom control
         * */
        $this->add_control([
            'id'          => 'footer_padding_bottom',
            'label'	      => esc_html__( 'Footer Padding Bottom', 'qoxag' ),
            'description' => esc_html__( 'Use Footer Padding Bottom', 'qoxag' ),
            'type'        => 'text',
            'section'     => 'footer_settings_section',
            'default'     => '100px',
        ]);

        /**
         * AMP Settings here
         */
         $this->add_section([
            'id'       => 'amp_settings_section',
            'title'    => esc_html__('AMP settings', 'qoxag'),
            'panel'    => 'xs_theme_option_panel',
            'priority' => 10,
        ]);

        $this->add_control([
            'id'      => 'amp_header_logo',
            'type'    => 'media',
            'section' => 'amp_settings_section',
            'label'   => esc_html__('Header Logo', 'qoxag'),
        ]);

        $this->add_control([
            'id'      => 'amp_header_menu',
            'type'    => 'select',
            'value'   => '',
            'label' => esc_html__('Header Menu', 'qoxag'),
            'section' => 'amp_settings_section',
            'choices' => $this->qoxag_amp_menus(),
        ]);

        $this->add_control([
            'id'      => 'amp_header_top_info_show',
            'type'    => 'switcher',
            'default' => 'no',
            'label'   => esc_html__('Show Topbar?', 'qoxag'),
            'desc'    => esc_html__('Do you want to show topbar?', 'qoxag'),
            'section' => 'amp_settings_section',
            'attr'    => ['class' => 'xs_header_builder_switch'],
            'left-choice'  => [
                'no' => esc_html__('No', 'qoxag'),
            ],
            'right-choice' => [
                'yes' => esc_html__('Yes', 'qoxag'),
            ],
        ]);

        $this->add_control([
            'id'    => 'amp_facebook_link',
            'type'  => 'text',
            'label' => esc_html__('Facebook link', 'qoxag'),
            'section' => 'amp_settings_section',
        ]);

        $this->add_control([
            'id'    => 'amp_twitter_link',
            'type'  => 'text',
            'label' => esc_html__('Twitter link', 'qoxag'),
            'section' => 'amp_settings_section',
        ]);

        $this->add_control([
            'id'    => 'amp_instagram_link',
            'type'  => 'text',
            'label' => esc_html__('Instagram link', 'qoxag'),
            'section' => 'amp_settings_section',
        ]);

        $this->add_control([
            'id'    => 'amp_linkedin_link',
            'type'  => 'text',
            'label' => esc_html__('LinkedIn link', 'qoxag'),
            'section' => 'amp_settings_section',
        ]);

        $this->add_control([
            'id'    => 'amp_footer_copyright',
            'type'  => 'text',
            'label' => esc_html__('Copyright text', 'qoxag'),
            'section' => 'amp_settings_section',
        ]);

        $this->add_control([
            'id'      => 'amp_back_to_top',
            'type'    => 'switcher',
            'default' => 'yes',
            'label'   => esc_html__('Show back to top?', 'qoxag'),
            'desc'    => esc_html__('Do you want to show back to top?', 'qoxag'),
            'section' => 'amp_settings_section',
            'attr'    => ['class' => 'xs_header_builder_switch'],
            'left-choice'  => [
                'no' => esc_html__('No', 'qoxag'),
            ],
            'right-choice' => [
                'yes' => esc_html__('Yes', 'qoxag'),
            ],
        ]);

        /**
         * Optimization Settings here
         */
        $this->add_section([
            'id'       => 'optimization_settings_section',
            'title'    => esc_html__('Optimization settings', 'qoxag'),
            'panel'    => 'xs_theme_option_panel',
            'priority' => 10,
        ]);

        /**
         * Font awesome icons here
         */
        $this->add_control([
            'id'      => 'optimization_fontawesome_enable',
            'type'    => 'switcher',
            'default' => 'yes',
            'label'   => esc_html__('Load Fontawesome icons ?', 'qoxag'),
            'desc'    => esc_html__('Do you want to load font awesome icons ?', 'qoxag'),
            'section' => 'optimization_settings_section',
            'attr'    => '',
            'left-choice'  => [
                'no' => esc_html__('No', 'qoxag'),
            ],
            'right-choice' => [
                'yes' => esc_html__('Yes', 'qoxag'),
            ],
        ]);

        $this->add_control([
            'id'      => 'optimization_blocklibrary_enable',
            'type'    => 'switcher',
            'default' => 'yes',
            'label'   => esc_html__('Load Block Library css files ?', 'qoxag'),
            'desc'    => esc_html__('Do you want to load block library css files ?', 'qoxag'),
            'section' => 'optimization_settings_section',
            'attr'    => '',
            'left-choice'  => [
                'no' => esc_html__('No', 'qoxag'),
            ],
            'right-choice' => [
                'yes' => esc_html__('Yes', 'qoxag'),
            ],
        ]);

        $this->add_control([
            'id'      => 'optimization_elementoricons_enable',
            'type'    => 'switcher',
            'default' => 'yes',
            'label'   => esc_html__('Load Elementor Icons?', 'qoxag'),
            'desc'    => esc_html__('Do you want to load elementor icons?', 'qoxag'),
            'section' => 'optimization_settings_section',
            'attr'    => '',
            'left-choice'  => [
                'no' => esc_html__('No', 'qoxag'),
            ],
            'right-choice' => [
                'yes' => esc_html__('Yes', 'qoxag'),
            ],
        ]);

        $this->add_control([
            'id'      => 'optimization_elementkitsicons_enable',
            'type'    => 'switcher',
            'default' => 'yes',
            'label'   => esc_html__('Load Elementskit Icons?', 'qoxag'),
            'desc'    => esc_html__('Do you want to load elementskit icons?', 'qoxag'),
            'section' => 'optimization_settings_section',
            'attr'    => '',
            'left-choice'  => [
                'no' => esc_html__('No', 'qoxag'),
            ],
            'right-choice' => [
                'yes' => esc_html__('Yes', 'qoxag'),
            ],
        ]);

        $this->add_control([
            'id'      => 'optimization_socialicons_enable',
            'type'    => 'switcher',
            'default' => 'yes',
            'label'   => esc_html__('Load WP Social Icons?', 'qoxag'),
            'desc'    => esc_html__('Do you want to load wp social icons?', 'qoxag'),
            'section' => 'optimization_settings_section',
            'attr'    => '',
            'left-choice'  => [
                'no' => esc_html__('No', 'qoxag'),
            ],
            'right-choice' => [
                'yes' => esc_html__('Yes', 'qoxag'),
            ],
        ]);

        $this->add_control([
            'id'      => 'optimization_dashicons_enable',
            'type'    => 'switcher',
            'default' => 'yes',
            'label'   => esc_html__('Load Dash Icons?', 'qoxag'),
            'desc'    => esc_html__('Do you want to load dash icons?', 'qoxag'),
            'section' => 'optimization_settings_section',
            'attr'    => '',
            'left-choice'  => [
                'no' => esc_html__('No', 'qoxag'),
            ],
            'right-choice' => [
                'yes' => esc_html__('Yes', 'qoxag'),
            ],
        ]);

        $this->add_control([
            'id'      => 'optimization_parallax_sticky',
            'type'    => 'switcher',
            'default' => 'yes',
            'label'   => esc_html__('Load Parallax and Sticky Module?', 'qoxag'),
            'desc'    => esc_html__('Do you want to load parallax and sticky Module from essential plugin?', 'qoxag'),
            'section' => 'optimization_settings_section',
            'attr'    => '',
            'left-choice'  => [
                'no' => esc_html__('No', 'qoxag'),
            ],
            'right-choice' => [
                'yes' => esc_html__('Yes', 'qoxag'),
            ],
        ]);

         /**
         * Instagram Settings here
         */
        $this->add_section([
            'id'       => 'instagram_settings_section',
            'title'    => esc_html__('Instagram settings', 'qoxag'),
            'panel'    => 'xs_theme_option_panel',
            'priority' => 10,
        ]);

        $this->add_control([
            'id'          => 'instagram_username',
            'label'       => esc_html__('Username', 'qoxag'),
            'description' => esc_html__('Your instagram username', 'qoxag'),
            'type'        => 'text',
            'section'     => 'instagram_settings_section',
            'default'     => '',
        ]);

        $this->add_control([
            'id'          => 'instagram_client_id',
            'label'       => esc_html__('Client ID', 'qoxag'),
            'description' => esc_html__('Your instagram client ID', 'qoxag'),
            'type'        => 'text',
            'section'     => 'instagram_settings_section',
            'default'     => '',
        ]);

        $this->add_control([
            'id'          => 'instagram_secret_key',
            'label'       => esc_html__('Access token', 'qoxag'),
            'description' => esc_html__('Your instagram access token', 'qoxag'),
            'type'        => 'text',
            'section'     => 'instagram_settings_section',
            'default'     => '',
        ]);

        /**
         * Google analytics Settings here
         */
        $this->add_section([
            'id'       => 'google_analytics_settings_section',
            'title'    => esc_html__('Google analytics settings', 'qoxag'),
            'panel'    => 'xs_theme_option_panel',
            'priority' => 10,
        ]);

        $this->add_control([
            'id'          => 'google_analytics_code',
            'label'       => esc_html__('Google Analytics Code', 'qoxag'),
            'description' => esc_html__('Your google analytics code here', 'qoxag'),
            'type'        => 'textarea',
            'section'     => 'google_analytics_settings_section',
            'default'     => '',
        ]);

        /**
         * Google analytics Settings here
         */
        $this->add_section([
            'id'       => 'ads_settings_section',
            'title'    => esc_html__('Ads settings', 'qoxag'),
            'panel'    => 'xs_theme_option_panel',
            'priority' => 10,
        ]);

        $this->add_control([
            'id'        => 'header_ads',
            'type'      => 'textarea',
            'default'   => '',
            'label'     => esc_html__('Header Ads', 'qoxag'),
            'desc'      => esc_html__( 'Only works when default header selected', 'qoxag' ),
            'section'   => 'ads_settings_section',
        ]);

        $this->add_control([
            'id'        => 'single_post_content_top_ads',
            'type'      => 'textarea',
            'default'   => '',
            'label'     => esc_html__('Single Post Content Top Ads', 'qoxag'),
            'desc'      => esc_html__( 'Paste the ads code here', 'qoxag' ),
            'section'   => 'ads_settings_section',
        ]);

        $this->add_control([
            'id'        => 'single_post_content_bottom_ads',
            'type'      => 'textarea',
            'default'   => '',
            'label'     => esc_html__('Single Post Content Bottom Ads', 'qoxag'),
            'desc'      => esc_html__( 'Paste the ads code here', 'qoxag' ),
            'section'   => 'ads_settings_section',
        ]);
    }

    // customize options value of menus
    public function qoxag_amp_menus(){
        $menus = [];
        $all_menus =get_terms('nav_menu', array('hide_empty'=>false));
        foreach($all_menus as $menu){
        $menus[$menu->slug] = $menu->name;
        }	
        return $menus;
    }
}
