<?php 

add_filter('woocommerce_add_to_cart_fragments', 'qoxag_woocommerce_header_add_to_cart_fragment');

function qoxag_woocommerce_header_add_to_cart_fragment( $fragments ) 
{
  
      ob_start(); ?>
      <a class="cart-contents" href="<?php echo wc_get_cart_url(); ?>" title="<?php esc_html_e('View your shopping cart', 'qoxag'); ?>">
      <span class="icon icon-tscart"></span>
      <sup><?php echo sprintf(_n('%d item', '%d', WC()->cart->cart_contents_count, 'qoxag'), WC()->cart->cart_contents_count);?></sup>
                           
      </a>

    <?php
    $fragments['a.cart-contents'] = ob_get_clean();
    return $fragments;
}

function qoxag_woocommerce_template_loop_product($product_id){
	$product = wc_get_product( $product_id );
	?>
	<div class="single-course">
		<div class="single-course-wrap">
			<div class="course-thumb">
			<a href="<?php echo esc_url(get_permalink($product_id)); ?>">
			<img class="img-fluid"  src="<?php echo esc_url(get_the_post_thumbnail_url( $product_id, 'large' )); ?>" alt="<?php echo get_the_title($product_id); ?>">
					<div class="lessons">
							<?php
							$args = array();
							if ( $product ) {
								$defaults = array(
									'quantity'   => 1,
									'class'      => implode(
										' ',
										array_filter(
											array(
												'button',
												'product_type_' . $product->get_type(),
												$product->is_purchasable() && $product->is_in_stock() ? 'add_to_cart_button' : '',
												$product->supports( 'ajax_add_to_cart' ) && $product->is_purchasable() && $product->is_in_stock() ? 'ajax_add_to_cart' : '',
											)
										)
									),
									'attributes' => array(
										'data-product_id'  => $product->get_id(),
										'data-product_sku' => $product->get_sku(),
										'aria-label'       => $product->add_to_cart_description(),
										'rel'              => 'nofollow',
									),
								);
					
								$args = apply_filters( 'woocommerce_loop_add_to_cart_args', wp_parse_args( $args, $defaults ), $product );
					
								if ( isset( $args['attributes']['aria-label'] ) ) {
									$args['attributes']['aria-label'] = wp_strip_all_tags( $args['attributes']['aria-label'] );
								}
					
								echo apply_filters(
									'woocommerce_loop_add_to_cart_link', // WPCS: XSS ok.
									sprintf(
										'<a href="%s" data-quantity="%s" class="%s" %s>%s</a>',
										esc_url( $product->add_to_cart_url() ),
										esc_attr( isset( $args['quantity'] ) ? $args['quantity'] : 1 ),
										esc_attr( isset( $args['class'] ) ? $args['class'] : 'button' ),
										isset( $args['attributes'] ) ? wc_implode_html_attributes( $args['attributes'] ) : '',
										esc_html( $product->add_to_cart_text() )
									),
									$product,
									$args
								);
							}
							?>
						</div><!-- ./lesson -->
					</a>
				


				<div class="meta-list">
					<?php
						$tags   = get_the_terms($product_id, 'product_tag');
						if (!empty($tags)) {
							foreach ($tags as $key => $value) {
								$term_link = get_term_link( $value, array( 'product_tag') );
								?>							
								<a href="<?php echo esc_url($term_link); ?>"><?php echo esc_html($value->name); ?></a>
								<?php
								if ($key >= 1)
								break;
							}
						}
					?>
				
					<?php if ( $product->get_sale_price() ) {
						$new_price  = $product->get_sale_price();
						$old_price 	= $product->get_regular_price();
						$percentage = round(100 - ($new_price / $old_price * 100)) . esc_html__('% off', 'qoxag');
						?>
						<a><?php echo esc_html($percentage); ?></a>
						<?php
					}
					?>
				</div><!-- ./meta-list -->


			</div>

			<div class="course-footer">
				<div class="lession-and-rating">						
					<?php
					$rating_count = $product->get_rating_count();
					$review_count = $product->get_review_count();
					$average      = $product->get_average_rating();
					?>
					<div class="xs-ratting-content woo-rate">
						<span><?php echo wc_get_rating_html( $average, $rating_count ); ?></span>
					</div>								
				</div>
			</div><!-- ./course-footer -->


			<div class="content-area">
				<h3 class="ts-course-el-title"> 
					<a href="<?php echo esc_url(get_permalink($product_id)); ?>">
						<?php echo esc_html(get_the_title($product_id)); ?> 
					</a>	
				</h3>
				<div class="author-area">
					<?php echo get_the_excerpt($product_id); ?>
				</div>


				<div class="course-price-item">
					<?php if ( $product->get_price_html() ){ ?>
						<span class="course-price">							
							<?php echo qoxag_kses($product->get_price_html()); ?>
						</span>
					<?php } else{ ?>
					<span class="course-price"> <?php echo esc_html__('Free','qoxag'); ?> </span> 
					<?php } ?>
				</div><!-- ./ price -->
			</div>
		</div>
	</div>
	<?php
}