<?php if (!defined('ABSPATH')) die('Direct access forbidden.');
/**
 * register required plugins
 */

function qoxag_register_required_plugins() {
	$plugins	 = array(
		array(
			'name'		 => esc_html__( 'Elementor', 'qoxag' ),
			'slug'		 => 'elementor',
			'required'	 => true,
        ),
		array(
			'name'		 => esc_html__( 'Elementskit Lite', 'qoxag' ),
			'slug'		 => 'elementskit-lite',
			'required'	 => true,
        ),
		
		array(
			'name'		 => esc_html__( 'Devmonsta', 'qoxag' ),
			'slug'		 => 'devmonsta',
			'required'	 => true,
        ),
		array(
			'name'		 => esc_html__( 'Wp Social', 'qoxag' ),
			'slug'		 => 'wp-social',
        ),
		
		array(
			'name'		 => esc_html__( 'One Click Demo Import', 'qoxag' ),
			'slug'		 => 'one-click-demo-import',
			'required'	 => true,
		),

		array(
			'name'		 => esc_html__( 'Mailchimp', 'qoxag' ),
			'slug'		 => 'mailchimp-for-wp',
		),

		array(
			'name'		 => esc_html__( 'Wp Ultimate Review', 'qoxag' ),
			'slug'		 => 'wp-ultimate-review',
		),

		array(
			'name'		 => esc_html__( 'Qoxag Essential', 'qoxag' ),
			'slug'		 => 'qoxag-essential',
			'required'	 => true,
			'version'	 => '2.0.0',
            'source'	 => 'https://demo.themewinter.com/wp/plugins/qoxag/qoxag-essential.zip',
		),
	);


	$config = array(
		'id'			 => 'qoxag', // Unique ID for hashing notices for multiple instances of TGMPA.
		'default_path'	 => '', // Default absolute path to bundled plugins.
		'menu'			 => 'qoxag-install-plugins', // Menu slug.
		'parent_slug'	 => 'themes.php', // Parent menu slug.
		'capability'	 => 'edit_theme_options', // Capability needed to view plugin install page, should be a capability associated with the parent menu used.
		'has_notices'	 => true, // Show admin notices or not.
		'dismissable'	 => true, // If false, a user cannot dismiss the nag message.
		'dismiss_msg'	 => '', // If 'dismissable' is false, this message will be output at top of nag.
		'is_automatic'	 => false, // Automatically activate plugins after installation or not.
		'message'		 => '', // Message to output right before the plugins table.
	);

	tgmpa( $plugins, $config );
}

add_action( 'tgmpa_register', 'qoxag_register_required_plugins' );