<?php if (!defined('ABSPATH')) die('Direct access forbidden.');
/**
 * dynamic css, generated by customizer options
 */

// display navigation to the next/previous set of posts
// ----------------------------------------------------------------------------------------
function qoxag_post_nav()
{
// Don't print empty markup if there's nowhere to navigate.
    $next_post = get_next_post();
    $pre_post = get_previous_post();
    if (!$next_post && !$pre_post) {
        return;
    }
    ?>
    <nav class="post-navigation">
        <div class="post-previous">
            <?php if (!empty($pre_post)): ?>
                <a href="<?php echo get_the_permalink($pre_post->ID); ?>" class="post-navigation-item">
                    <i class="xts-icon xts-arrow-left"></i>
                    <span><?php esc_html_e('Previous post', 'qoxag') ?></span>
                </a>
            <?php endif; ?>
        </div>
        <div class="post-next">
            <?php if (!empty($next_post)): ?>
                <a href="<?php echo get_the_permalink($next_post->ID); ?>" class="post-navigation-item">
                    <span><?php esc_html_e('Next post', 'qoxag') ?></span>
                    <i class="xts-icon xts-arrow-right"></i>
                </a>
            <?php endif; ?>
        </div>
    </nav>
<?php }


// display meta information for a specific post
// ----------------------------------------------------------------------------------------
if (!function_exists('qoxag_get_breadcrumbs')) {
    function qoxag_get_breadcrumbs($seperator = '', $word = '')
    {
        global $post;
        $speaker_category = get_queried_object();
        echo '<ol class="breadcrumb">';
        if (!is_home()) {
            echo '<li><a href="';
            echo esc_url(get_home_url('/'));
            echo '">';
            echo esc_html__('Home', 'qoxag');
            echo "</a></li> " . esc_attr($seperator);
            if (is_category() || is_single()) {

                if(is_single()){
                    $category = get_the_category()[0];
                 }else{
                    $category = get_category( get_query_var( 'cat' ) );
                 }
                 if(!empty( $category )){
                    echo '<li> <a href='.get_category_link($category->term_id). '>';
                 }
                 
                 $post		 = get_queried_object();
                 $postType	 = get_post_type_object( get_post_type( $post ) );
                 if ( !empty( $category ) ) {
                    echo esc_html( $category->cat_name ) . '</a> </li>';
                 } else if ( $postType ) {
                    echo esc_html( $postType->labels->singular_name ) . '</a></li>';
                 }
                 
                 if ( is_single() ) {
                    echo '<li>'.qoxag_kses( $seperator );
                    echo esc_html( $word ) != '' ? wp_trim_words( get_the_title(), $word ) : get_the_title();
                    echo '</li>';
                    
                 }
            } elseif ( is_page() && !$post->post_parent ) {
				echo '<li>';
				echo esc_html( $word ) != '' ? wp_trim_words( get_the_title(), $word ) : get_the_title();
				echo '</li>';
			} elseif ( is_page() && $post->post_parent ) {
				$parent_id = $post->post_parent;
				$breadcrumb_page = array();
				while($parent_id){
					$page = get_page($parent_id);
					$breadcrumb_page[] = '<li><a href="'.esc_url(get_permalink($page->ID)).'">'.get_the_title($page->ID).'</a></li>';
					$parent_id = $page->post_parent;
				}
				$breadcrumb_page = array_reverse($breadcrumb_page);
				for($i = 0; $i < count($breadcrumb_page); $i++){				
					echo qoxag_kses($breadcrumb_page[$i]);
					echo esc_html( $seperator );
				}			
				echo '<li>';
				echo esc_html( $word ) != '' ? wp_trim_words( get_the_title(), $word ) : get_the_title();
				echo '</li>';
			}
        }
        if (isset($speaker_category->taxonomy)) {
            if ($speaker_category->taxonomy == 'speaker-category') {
                echo esc_html($speaker_category->name);
            }
        }
        if (is_tag()) {
           ?>
           <li> <?php single_tag_title(); ?></li>
           <?php
        } elseif (is_day()) {
            echo "<li>" . esc_html__('Blogs for', 'qoxag') . " ";
            the_time('F jS, Y');
            echo '</li>';
        } elseif (is_month()) {
            echo "<li>" . esc_html__('Blogs for', 'qoxag') . " ";
            the_time('F, Y');
            echo '</li>';
        } elseif (is_post_type_archive('xs-speaker')) {
            $postType = get_post_type_object(get_post_type());
            echo "<li>" . esc_html($postType->labels->name);
            echo '</li>';
        } elseif (is_year()) {
            echo "<li>" . esc_html__('Blogs for', 'qoxag') . " ";
            the_time('Y');
            echo '</li>';
        } elseif (is_author()) {
            echo "<li>" . esc_html__('Author Blogs', 'qoxag');
            echo '</li>';
        } elseif (isset($_GET['paged']) && !empty($_GET['paged'])) {
            echo "<li>" . esc_html__('Blogs', 'qoxag');
            echo '</li>';
        } elseif (is_search()) {
            echo "<li>" . esc_html__('Search Result', 'qoxag');
            echo '</li>';
        } elseif (is_404()) {
            echo "<li>" . esc_html__('404 Not Found', 'qoxag');
            echo '</li>';
        }
        echo '</ol>';
    }
}


// display meta information for a specific post
// ----------------------------------------------------------------------------------------
function qoxag_post_meta()
{
    ?>
    <div class="post-meta">
        <?php

        $blog_author_show = qoxag_option('blog_author_show', 'yes');
        $blog_date_show = qoxag_option('blog_date_show', 'yes');
        $blog_category_show = qoxag_option('blog_category_show', 'yes');

        if ($blog_author_show == 'yes') :
            printf(
                '<span class="post-author"><i class="xts-icon xts-author"></i> <a href="%2$s">%3$s</a></span>',
                get_avatar(get_the_author_meta('ID'), 55),
                esc_url(get_author_posts_url(get_the_author_meta('ID'))),
                get_the_author()
            );
        endif;

        if (get_post_type() === 'post' && $blog_date_show == 'yes') {
            echo '<span class="post-meta-date">
					<i class="xts-icon xts-date"></i>
						' . get_the_date() .
                '</span>';
        }


        $category_list = get_the_category_list(', ');
        if ($category_list && $blog_category_show == 'yes') {
            echo '<span class="meta-categories post-cat">
					<i class="xts-icon xts-category"></i>
						' . $category_list . '
					</span>';
        }

        if (is_single()):
            ?>
            <span class="post-comment"><i class="xts-icon xts-comment"></i><a href="#commentform"
                                                                               class="comments-link"><?php echo get_comments_number(get_the_ID());
                    echo get_comments_number(get_the_ID()) > 1 ?
                        esc_html__(' Comments ', 'qoxag') : esc_html__(' Comment ', 'qoxag'); ?></a></span>
        <?php
        endif;
        ?>
    </div>
<?php }

// display meta information for a specific post
// ----------------------------------------------------------------------------------------
function qoxag_post_details_meta()
{
    ?>
    <div class="post-meta">
        <?php

        $blog_author_show = qoxag_option('blog_details_author_show', 'yes');
        $blog_date_show = qoxag_option('blog_details_date_show', 'yes');
        $blog_details_Comments_show = qoxag_option('blog_details_Comments_show', 'no');
        $category_on_top = qoxag_option(get_the_ID(), 'category_on_top', 'no');
        $blog_category_show = qoxag_option('blog_details_category_show', 'yes');

        if ($blog_author_show == 'yes') :
            printf(
                '<span class="post-author"><i class="xts-icon xts-author"></i> <a href="%2$s">%3$s</a></span>',
                get_avatar(get_the_author_meta('ID'), 55),
                esc_url(get_author_posts_url(get_the_author_meta('ID'))),
                get_the_author()
            );
        endif;

        if (get_post_type() === 'post' && $blog_date_show == 'yes') {
            echo '<span class="post-meta-date">
					<i class="xts-icon xts-date"></i>
						' . get_the_date() .
                '</span>';
        }

        if($category_on_top != 'yes'){
            $category_list = get_the_category_list(', ');
            if ($category_list && $blog_category_show == 'yes') {
                echo '<span class="meta-categories post-cat">
                        <i class="xts-icon xts-category"></i>
                            ' . $category_list . '
                        </span>';
            }
        }

        if (is_single() && $blog_details_Comments_show == 'yes'):
            ?>
            <span class="post-comment"><i class="xts-icon xts-comment"></i><a href="#commentform" class="comments-link"><?php echo get_comments_number(get_the_ID());
            echo get_comments_number(get_the_ID()) > 1 ?
            esc_html__(' Comments ', 'qoxag') : esc_html__(' Comment ', 'qoxag'); ?></a></span>
        <?php
        endif;
        ?>
    </div>
<?php }


// display meta date for a specific post
// ----------------------------------------------------------------------------------------
function qoxag_post_meta_date()
{
    if (get_post_type() === 'post') {
        echo '<span class="post-meta-date meta-date">' . get_the_date('m F Y') . '</span>';
    }
}

if (!function_exists('qoxag_font_zoom')) {
    function qoxag_font_zoom(){
        ?>
        <div class="font-zoom">
            <p><?php echo esc_html__('AA','qoxag'); ?></p>
            <div class="hover-zoom">
                <button class="zoomout"><?php echo esc_html__('A','qoxag'); ?></button>
                <button class="zoomin"><?php echo esc_html__('A','qoxag'); ?></button>
            </div>
        </div>
        <?php
    }
}

if (!function_exists('qoxag_print')) {
    function qoxag_print(){
        ?>
        <div class="print">
            <a href="#" class="print-btn" onclick="window.print();"><i class="xts-icon xts-printer"></i></a>
        </div>
        <?php
    }
}


// comment walker
// ----------------------------------------------------------------------------------------
function qoxag_comment_style($comment, $args, $depth)
{
    if ('div' === $args['style']) {
        $tag = 'div';
        $add_below = 'comment';
    } else {
        $tag = 'li ';
        $add_below = 'div-comment';
    }
    ?>
    <?php
    if ($args['avatar_size'] != 0) {
        echo get_avatar($comment, $args['avatar_size'], '', '', array('class' => 'comment-avatar pull-left'));
    }
    ?>
    <<?php
    echo qoxag_kses($tag);
    comment_class(empty($args['has_children']) ? '' : 'parent');
    ?> id="comment-<?php comment_ID() ?>"><?php if ('div' != $args['style']) { ?>
    <div id="div-comment-<?php comment_ID() ?>" class="comment-body"><?php }
    ?>
    <div class="meta-data">
			<span class="comment-author vcard"><?php
                printf(qoxag_kses('<cite class="fn">%s</cite> <span class="says">%s</span>', 'qoxag'), get_comment_author_link(), esc_html__('says:', 'qoxag'));
                ?>
			</span>
        <?php if ($comment->comment_approved == '0') { ?>
            <em class="comment-awaiting-moderation"><?php esc_html_e('Your comment is awaiting moderation.', 'qoxag'); ?></em>
            <br/><?php }
        ?>

        <div class="comment-meta commentmetadata comment-date">
            <?php
            // translators: 1: date, 2: time
            printf(
                esc_html__('%1$s at %2$s', 'qoxag'), get_comment_date(), get_comment_time()
            );
            ?>
            <?php edit_comment_link(esc_html__('(Edit)', 'qoxag'), '  ', ''); ?>
        </div>
    </div>
    <div class="comment-content">
        <?php comment_text(); ?>
    </div>
    <div class="reply"><?php
        comment_reply_link(
            array_merge(
                $args, array(
                'add_below' => $add_below,
                'depth' => $depth,
                'max_depth' => $args['max_depth']
            )));
        ?>
    </div>
    <?php if ('div' != $args['style']) : ?>
    </div><?php
endif;
}


// pagination within pages or posts if it has a long content
// ----------------------------------------------------------------------------------------
function qoxag_link_pages()
{
    $args = array(
        'before' => '<div class="page-links"><span class="page-link-text">' . esc_html__('More pages: ', 'qoxag') . '</span>',
        'after' => '</div>',
        'link_before' => '<span class="page-link">',
        'link_after' => '</span>',
        'next_or_number' => 'number',
        'separator' => '  ',
        'nextpagelink' => esc_html__('Next ', 'qoxag') . '<I class="xts-icon xts-chevron-left"></i>',
        'previouspagelink' => '<I class="xts-icon xts-chevron-right"></i>' . esc_html__(' Previous', 'qoxag'),
    );
    wp_link_pages($args);
}


//  related post by categry
function qoxag_related_posts_by_category($post_id, $related_count = 4, $feature_image = true)
{
    try {

        if ($post_id == '') {
            $post_id = get_the_ID();
        }

        $terms = get_the_terms($post_id, 'category');

        if (empty($terms)) $terms = array();

        $term_list = wp_list_pluck($terms, 'slug');

        $related_args = array(
            'post_type' => 'post',
            'posts_per_page' => $related_count,
            'post_status' => 'publish',
            'post__not_in' => array($post_id),
            'orderby' => 'rand',
            'ignore_sticky_posts' => 1,
            'tax_query' => array(
                array(
                    'taxonomy' => 'category',
                    'field' => 'slug',
                    'terms' => $term_list
                )
            )
        );
        if ($feature_image) {
            $related_args["meta_query"] = array(
                array(
                    'key' => '_thumbnail_id',
                    'compare' => 'EXISTS'
                ),
            );
        }

        return new WP_Query($related_args);

    } catch (Exception $e) {

        return new WP_Query([]);

    }
//  wp_reset_postdata() already used in post query

}

//  related post by tags
function qoxag_related_posts_by_tags($post_id = '', $related_count = 4, $feature_image = true)
{

    try {
        if ($post_id == '') {
            $post_id = get_the_ID();
        }
        $tags = wp_get_post_tags($post_id);
        $term_tags = wp_list_pluck($tags, 'term_id');
        $args = array(

            'tag__in' => $term_tags,
            'post__not_in' => array($post_id),
            'posts_per_page' => $related_count,
            'ignore_sticky_posts' => 1,
        );
        if ($feature_image) {
            $args["meta_query"] = array(
                array(
                    'key' => '_thumbnail_id',
                    'compare' => 'EXISTS'
                ),
            );
        }

        return new WP_Query($args);

    } catch (Exception $e) {

        return new WP_Query([]);

    }
//  wp_reset_postdata() already used in post query

}

/*
*
* Tag list
**/

function qoxag_tag_list()
{
    $tag_list = get_the_tag_list('', ' ');
    if ($tag_list) {
        echo '<div class="post-tag-container">';
        echo '<div class="tag-lists">';
        echo '<span>' . esc_html__('Tags: ', 'qoxag') . '</span>';
        echo qoxag_kses($tag_list);
        echo '</div>';
        echo '</div>';
    }
}

/*
*
* Widget title
**/
function qoxag_post_title($post_id, $post_title_crop)
{ ?>
    <h3 class="post-heading">
        <?php do_action('qoxag_before_post_title'); ?>
        <a href="<?php echo esc_url(get_permalink($post_id)); ?>" title="<?php echo get_the_title($post_id); ?>">
            <?php
            echo esc_html(wp_trim_words(get_the_title($post_id), $post_title_crop, ''));
            ?>
        </a>
        <?php do_action('qoxag_after_post_title'); ?>
    </h3>
<?php }


/*
*
* Widget thumbnail
**/
function qoxag_post_thumbnail($post_id, $layout_thumbnail_img_size, $video_icon = 'no', $show_review_rating = 'no')
{
    if (has_post_thumbnail($post_id)) { ?>
        <div class="post-thumbnail">
            <?php do_action('qoxag_before_post_thumbnail'); ?>
            <a href="<?php echo esc_url(get_permalink($post_id)); ?>" title="<?php echo get_the_title($post_id); ?>">
                <?php echo get_the_post_thumbnail($post_id, $layout_thumbnail_img_size); ?>
            </a>
            <?php if(get_post_format($post_id) == 'video' || get_post_format($post_id) == 'audio'){ ?>
                <div class="format-icons">
                    <?php if(get_post_format($post_id) == 'video'){ ?>
                        <i class="xts-icon xts-play_icon"></i>
                    <?php } elseif(get_post_format($post_id) == 'audio'){ ?>
                        <i class="xts-icon xts-audio_icon"></i>
                    <?php } ?>
                </div>
            <?php } ?>
            <?php
            if ($video_icon == 'yes') {
                if (function_exists('qoxag_meta_option')) {
                    $video_url = qoxag_meta_option($post_id, 'featured_video', '');
                    if ($video_url != '') { ?>
                        <div class="post-video-icon">
                            <a href="<?php echo esc_url($video_url); ?>" class="xts-icon xts-play_icon" title="<?php echo esc_attr__('Video play popup', 'qoxag'); ?>">
                            </a>
                        </div>
                        <?php
                    }
                }
            }
            ?>
            <?php
            if ($show_review_rating == 'yes') {
               qoxag_review_rating( [ 'post-id' => $post_id, 'ratting-show' => 'no', 'count-show' => 'yes', 'vote-show' => 'no', 'vote-text' => 'yes', 'ratting-style' => 'star' ]);
            }
            ?>
            <?php do_action('qoxag_after_post_thumbnail'); ?>
        </div>
    <?php }
}


/*
*
* Widget description
**/
function qoxag_post_excerpt($post_id, $post_content_crop)
{ ?>
    <p class="post-excerpt">
        <?php do_action('qoxag_before_post_excerpt'); ?>
        <?php echo wp_trim_words(get_the_excerpt($post_id), $post_content_crop, ''); ?>
        <?php do_action('qoxag_after_post_excerpt'); ?>
    </p>
<?php }


/*
*
* Widget categories
**/
function qoxag_post_categories($post_id, $number_of_categories, $category_position, $category_style = 'default')
{
    $cat = get_the_category($post_id);
    $separator = ' ';
    if (!empty($cat)) { ?>
        <div class="category-wrapper category-layout position-<?php echo esc_attr($category_position); ?>">
            <?php
            $styles = '';
            $span_styles = '';
            foreach ($cat as $key => $single_cat) {
                if ($key == $number_of_categories) {
                    break;
                }

                if (function_exists('qoxag_cat_style')) {
                    if($category_style == 'left-background'){
                        $styles = 'style=' . esc_attr(qoxag_cat_style($single_cat->term_id, 'category_bg_color', 'color'));
                        $span_styles = 'style=' . esc_attr(qoxag_cat_style($single_cat->term_id, 'category_bg_color', 'bg'));
                    } elseif($category_style == 'no-background'){
                        $styles = 'style=' . esc_attr(qoxag_cat_style($single_cat->term_id, 'category_bg_color', 'color'));
                    } else{
                        $styles = 'style=' . esc_attr(qoxag_cat_style($single_cat->term_id, 'category_bg_color', 'bg')) . esc_attr(qoxag_cat_style($single_cat->term_id, 'category_color', 'color')); 
                    }
                }
                ?>

                <a class="post-cat <?php echo esc_attr($category_style); ?>"
                   href="<?php echo esc_url(get_category_link($single_cat->term_id)); ?>" <?php echo esc_attr($styles); ?>>
                   <span class="cat-background-span" <?php echo esc_attr($span_styles); ?>></span>
					<span class="before">
						<?php echo esc_html($single_cat->name); ?>
					</span>
                </a>
                <?php
            }
            ?>
        </div>
        <?php
    }
}

// for widget control terms value
if (!function_exists("qoxag_get_post_terms")) {
    function qoxag_get_post_terms($taxonomy)
    {
        $terms = get_terms(array(
            'taxonomy' => $taxonomy,
            'hide_empty' => false,
            'posts_per_page' => -1,
        ));

        $term_list = [];
        foreach ($terms as $post) {
            $term_list[$post->term_id] = [$post->name];
        }
        return $term_list;
    }
}

/*
    Post meta
*/
function qoxag_post_meta_info($post_id, $show_author, $show_date, $show_count, $show_read_time, $show_review_rating, $blog_details_Comments_show = 'no')
{ ?>
    <?php if ($show_author == 'yes' || $show_date == 'yes') { ?>
    <div class="post-meta">
        <?php if ($show_author == 'yes') { ?>
            <?php $post_author_id = get_post_field( 'post_author', $post_id ); ?>
            <span class="post-author">
                <span><?php echo esc_html__('by', 'qoxag'); ?></span>
                <a href="<?php echo esc_url(get_author_posts_url(get_the_author_meta('ID', $post_author_id))); ?>">
                    <?php echo esc_html(get_the_author_meta('display_name', $post_author_id)); ?>
                </a>
            </span>
        <?php } ?>
        <?php if ($show_date == 'yes') { ?>
            <span class="post-date">
                <i class="xts-icon xts-date"></i>
                <?php echo get_the_date(get_option('date_format'), $post_id); ?>
            </span>
            <?php } ?>
            <?php if($show_count == 'yes'){?>
                <span>
					<i class="xts-icon xts-fire"></i>
                    <?php echo qoxag_get_postview($post_id); ?>
                </span>
        <?php }
        
        if ($blog_details_Comments_show == 'yes'){
            ?>
            <span class="post-comment"><i class="xts-icon xts-comment"></i>
            <a href="#commentform" class="comments-link">
                <?php echo get_comments_number($post_id); 
                echo get_comments_number($post_id) > 1 ? esc_html__(' Comments ', 'qoxag') : esc_html__(' Comment ', 'qoxag'); ?>
            </a>
            </span>
        <?php
        }
        ?>

        <?php
        if ($show_read_time == 'yes') {
            echo qoxag_content_estimated_reading_time(get_the_content('', '', $post_id));
        }

        if ($show_review_rating == 'yes') {
            qoxag_review_rating( [ 'post-id' => $post_id, 'count-show' => 'no', 'vote-show' => 'no', 'vote-text' => 'no', 'ratting-style' => 'star' ]);
        }

        ?>
    </div>
    <?php
}
}

// Ajax Load More
function qoxag_post_ajax_loading_cb(){   
	$settings =  $_POST['ajax_json_data'];
	$args = [
		'post_type'   		=>  'post',
		'post_status' 		=> 'publish',
		'order'       		=> $settings['query_order'],
		'posts_per_page' 	=> $settings['query_posts_per_page'],
		'paged'             => $_POST['paged'],
		'suppress_filters' 	=> false,
	];

	if(!empty($settings['query_post_categories'])){
		$args['tax_query'] = array(
			array(
				'taxonomy'  => 'category',
				'terms'     => $settings['query_post_categories'],
				'field'     => 'id'
			),
		);
	}

	if(!empty($settings['query_post_tags'])){
		$args['tax_query'] = array(
			array(
				'taxonomy'  => 'post_tag',
				'terms'     => $settings['query_post_tags'],
				'field'     => 'id'
			),
		);
	}

	$allpostloding = new WP_Query($args);
	$index = 0;

    $style_class = $settings['layout_layout_style'];
    $show_thumbnail = $settings['layout_show_thumbnail'];
    $show_category = $settings['layout_show_category'];
    $number_of_categories = $settings['layout_number_of_categories'];
    $show_date = $settings['layout_show_date'];
    $post_title_crop = $settings['layout_post_title_crop'];
    $show_author = $settings['layout_show_author'];
    $show_view_count = $settings['layout_show_view_count'];
    $show_read_time = $settings['layout_show_read_time'];
    $show_readmore = $settings['layout_show_read_more_link'];
    $readmore_text = $settings['layout_readmore_text'];
    $read_more_icon = $settings['layout_read_more_icon'];
    $show_content = $settings['layout_show_content'];
    $post_content_crop = $settings['layout_post_content_crop'];
    $category_position = $settings['layout_category_position'];
    $layout_thumbnail_img_size = $settings['layout_thumbnail_img_size_size'];
    $thumbnail_image_aspect_ratio = $settings['layout_thumbnail_image_aspect_ratio_size'];
    $video_icon = 'no';
    $category_style = $settings['layout_category_style'];

    $column_desktop = $settings['layout_column_number'];
    $column_tablet = $settings['layout_column_number_tablet'];
    $column_mobile = $settings['layout_column_number_mobile'];

    $show_review_rating_style1 = $settings['show_review_rating_style1'];
    $show_review_rating_style2 = $settings['show_review_rating_style2'];
	?>
	<?php
	while($allpostloding->have_posts()){ $allpostloding->the_post(); ?>
        <?php ?>
		<div class="rest-grids grid-item col-lg-<?php echo esc_attr($column_desktop); ?> col-md-<?php echo esc_attr($column_tablet); ?> col-sm-<?php echo esc_attr($column_mobile); ?>">
            <?php
            $postid = get_the_ID();
            include QOXAG_CORE . "/elementor/content-parts/content-loadmore.php"; ?>
		</div>
	<?php
	$index ++;
	}
	?>
	<?php
	wp_reset_postdata();
	wp_die();  
}

add_action( 'wp_ajax_nopriv_qoxag_post_ajax_loading', 'qoxag_post_ajax_loading_cb' );
add_action( 'wp_ajax_qoxag_post_ajax_loading', 'qoxag_post_ajax_loading_cb' );


// food recipe meta field in post details page
function get_recipe_field(){

    $recipe_meta = qoxag_meta_option(get_the_ID(),'recipe_switch', 'no'); 
    $prep_time = qoxag_meta_option(get_the_ID(), 'prep_time', '');
    $cook_time = qoxag_meta_option(get_the_ID(), 'cook_time', '');
    $total_time = qoxag_meta_option(get_the_ID(), 'total_time', '');
    $serving_time = qoxag_meta_option(get_the_ID(), 'serving_time', '');

    if($recipe_meta == 'yes'){
    
       ?>
       <div class="recipe-meta-wrapper row">
          <div class="recipe-meta col-lg-8">
             <div class="row">
                <?php if($prep_time !=''): ?>
                    <div class="meta-item col-lg-6 col-md-6">
                    <div class="icon">
                        <i class="xts-icon xts-clock"></i>
                    </div>
                    <div class="content">
                        <p><strong><?php echo esc_html__('Prep time:','qoxag'); ?></strong></p>
                        <p><?php echo esc_html($prep_time); ?></p>
                    </div>
                    </div>
                <?php endif; ?>
                <?php if($cook_time !=''): ?>
                    <div class="meta-item col-lg-6 col-md-6">
                    <div class="icon">
                        <i class="xts-icon xts-clock"></i>
                    </div>
                    <div class="content">
                        <p><strong><?php echo esc_html__('Cook time:','qoxag'); ?></strong></p>
                        <p><?php echo esc_html($cook_time); ?></p>
                    </div>
                    </div>
                <?php endif; ?>
                <?php if($total_time !=''): ?>
                    <div class="meta-item col-lg-6 col-md-6">
                    <div class="icon">
                        <i class="xts-icon xts-clock"></i>
                    </div>
                    <div class="content">
                        <p><strong><?php echo esc_html__('Total time:','qoxag'); ?></strong></p>
                        <p><?php echo esc_html($total_time); ?></p>
                    </div>
                    </div>
                <?php endif; ?>
                <?php if($serving_time !=''): ?>
                    <div class="meta-item col-lg-6 col-md-6">
                    <div class="icon">
                        <i class="xts-icon xts-peoples"></i>
                    </div>
                    <div class="content">
                        <p><strong><?php echo esc_html__('Serving time:','qoxag'); ?></strong></p>
                        <p><?php echo esc_html($serving_time); ?></p>
                    </div>
                    </div>
                <?php endif; ?>
             </div>
          </div>
          <div class="print-share-btns col-lg-4">
             <a href="" class="print-btn"><?php echo esc_html__('Print Recipe','qoxag'); ?><i class="xts-icon xts-printer"></i></a>
             <div class="share-btn-wrapper">
                <a class="share-btn"><?php echo esc_html__('Share Recipe','qoxag') ?> <i class="xts-icon xts-share"></i></a>
                <div class="social-share-meta">
                   <?php 
                      if (shortcode_exists( 'xs_social_share')) {
                         echo do_shortcode('[xs_social_share]');
                      }
                   ?>
                </div>
             </div>
          </div>
       </div>

 <?php } 
}


