<?php 
namespace Qoxag\Core\Helpers\Classes;

use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Typography;

defined( 'ABSPATH' ) || exit;
add_action('elementskit_lite/after_loaded', function(){

    class Qoxag_Controls_Ajax_Select2_Api extends \ElementsKit_Lite\Core\Handler_Api {
        public function config(){
            $this->prefix = 'qoxagselect2';
        }

        // brands
        public function get_post_tags(){
            $query_args = [
                'taxonomy'      => 'post_tag', // taxonomy name
                'orderby'       => 'name', 
                'order'         => 'DESC',
                'hide_empty'    => false,
                'number'        => 30
            ];

            if(isset($this->request['ids'])){
                $ids = explode(',', $this->request['ids']);
                $query_args['include'] = $ids;
            }
            if(isset($this->request['s'])){
                $query_args['name__like'] = $this->request['s'];
            }

            $terms = get_terms( $query_args );

            $options = [];
            $count = count($terms);
            if($count > 0):
                foreach ($terms as $term) {
                    $options[] = [ 'id' => $term->term_id, 'text' => $term->name ];
                }
            endif;      
            return ['results' => $options];
        }

        
    }
    new Qoxag_Controls_Ajax_Select2_Api();
});