<?php

namespace Elementor;

if (!defined('ABSPATH')) exit;


class Qoxag_Site_Logo extends Widget_Base
{


    public $base;

    public function get_name()
    {
        return 'site-logo';
    }

    public function get_title()
    {

        return esc_html__('Site Logo', 'qoxag');

    }

    public function get_icon()
    {
        return 'eicon-image';
    }

    public function get_categories()
    {
        return ['elementskit'];
    }

    protected function _register_controls()
    {

        $this->start_controls_section(
            'section_tab',
            [
                'label' => esc_html__('Logo settings', 'qoxag'),
            ]
        );

        $this->add_control(
            'site_logo',
            [
                'label' => esc_html__('Dark Logo', 'qoxag'),
                'type' => Controls_Manager::MEDIA,

            ]
        );
        $this->add_control(
            'light_logo',
            [
                'label' => esc_html__('Light Logo', 'qoxag'),
                'type' => Controls_Manager::MEDIA,
            ]
        );

        $this->add_responsive_control(
            'logo_size_width',
            [
                'label' => esc_html__('Logo Width', 'qoxag'),
                'type' => Controls_Manager::NUMBER,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .qoxag-widget-logo img' => 'max-width: {{VALUE}}px;',
                ],
            ]
        );
        $this->add_responsive_control(
            'logo_size_height',
            [
                'label' => esc_html__('Logo Height', 'qoxag'),
                'type' => Controls_Manager::NUMBER,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .qoxag-widget-logo img' => 'max-height: {{VALUE}}px;',
                    '{{WRAPPER}} .qoxag-widget-logo a' => 'line-height: {{VALUE}}px;',
                ],
            ]
        );
        $this->add_responsive_control(
            'date_text_align', [
                'label' => esc_html__('Alignment', 'qoxag'),
                'type' => Controls_Manager::CHOOSE,
                'options' => [

                    'left' => [
                        'title' => esc_html__('Left', 'qoxag'),
                        'icon' => 'fa fa-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__('Center', 'qoxag'),
                        'icon' => 'fa fa-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__('Right', 'qoxag'),
                        'icon' => 'fa fa-align-right',
                    ],
                ],
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .qoxag-widget-logo' => 'text-align: {{VALUE}};'
                ],
            ]
        );


        $this->add_responsive_control(
            'logo_padding',
            [
                'label' => esc_html__('Padding', 'qoxag'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .qoxag-widget-logo' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();

        $site_logo = $settings['site_logo'];
        $light_logo = $settings['light_logo'];

        $tpl = get_widget_template($this->get_name());
        include $tpl;
    }


    protected function content_template()
    {
    }
}