<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit;

class Qoxag_Products_Slider extends Widget_Base {

  public $base;

    public function get_name() {
        return 'products-slider';
    }

    public function get_title() {
        return esc_html__( 'Product Slider', 'qoxag' );
    }

    public function get_icon() { 
        return 'eicon-nav-menu';
    }

    public function get_categories() {
        return [ 'qoxag-elements' ];
    }

    protected function _register_controls() {

        $this->start_controls_section(
            'section_tab',
            [
                'label' => esc_html__('Post', 'qoxag'),
            ]
        );

        $this->add_control(
          'post_count',
          [
            'label'         => esc_html__( 'slider count', 'qoxag' ),
            'type'          => Controls_Manager::NUMBER,
            'default'       => 4,
          ]
        );

        $this->add_control(
          'post_per_page',
          [
            'label'         => esc_html__( 'Total Post count', 'qoxag' ),
            'type'          => Controls_Manager::NUMBER,
            'default'       => 12,
          ]
        );    

        $this->add_control(
            'post_cats',
            [
                'label' =>esc_html__('Select Categories', 'qoxag'),
                'type'      => Controls_Manager::SELECT2,
                'options'   => $this->post_category(),
                'label_block' => true,
                'multiple'  => true,
            ]
        );
   
     

        $this->add_control(
            'post_sortby',
            [
                'label'     =>esc_html__( 'Post sort by', 'qoxag' ),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'latestpost',
                'options'   => [
                        'latestpost'      =>esc_html__( 'Latest posts', 'qoxag' ),
                        'mostdiscussed'    =>esc_html__( 'Most discussed', 'qoxag' ),
                    ],
            ]
        );
        
        $this->add_control(
            'post_order',
            [
                'label'     =>esc_html__( 'Post order', 'qoxag' ),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'DESC',
                'options'   => [
                        'DESC'      =>esc_html__( 'Descending', 'qoxag' ),
                        'ASC'       =>esc_html__( 'Ascending', 'qoxag' ),
                    ],
            ]
        );
        $this->add_control('show_navigation',
        [
        'label'       => esc_html__('Show Navigation', 'qoxag'),
        'type'        => Controls_Manager::SWITCHER,
        'label_on'    => esc_html__('Yes', 'qoxag'),
        'label_off'   => esc_html__('No', 'qoxag'),
        'default'     => 'yes',

        ]
    ); 

    $this->add_control('auto_play',
        [
        'label'       => esc_html__('Auto play', 'qoxag'),
        'type'        => Controls_Manager::SWITCHER,
        'label_on'    => esc_html__('Yes', 'qoxag'),
        'label_off'   => esc_html__('No', 'qoxag'),
        'default'     => 'no',

        ]
    ); 
    
   

        $this->end_controls_section();

        $this->start_controls_section('qoxag_style_block_section',
        [
           'label' => esc_html__( ' Post', 'qoxag' ),
           'tab' => Controls_Manager::TAB_STYLE,
        ]
       );
       $this->add_control(
			'title_settings',
			[
				'label' => __( 'Title Style', 'qoxag' ),
				'type' => \Elementor\Controls_Manager::HEADING,
            'separator' => 'before',
			]
		);
  
       $this->add_control(
           'block_title_color',
           [
              'label' => esc_html__('Title color', 'qoxag'),
              'type' => Controls_Manager::COLOR,
              'default' => '',
            
              'selectors' => [
                 '{{WRAPPER}} .products-slider .ts-course-el-title' => 'color: {{VALUE}};',
                 '{{WRAPPER}} .products-slider .ts-course-el-title a' => 'color: {{VALUE}};',
              ],
           ]
        );
       $this->add_control(
           'block_title_hover_color',
           [
              'label' => esc_html__('Title hover color', 'qoxag'),
              'type' => Controls_Manager::COLOR,
              'default' => '',
            
              'selectors' => [
               '{{WRAPPER}} .products-slider .ts-course-el-title' => 'color: {{VALUE}};',
               '{{WRAPPER}} .products-slider .ts-course-el-title:hover a' => 'color: {{VALUE}};',
              ],
           ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
               'name' => 'post_title_typography',
               'label' => esc_html__( 'Title Typography', 'qoxag' ),
               'scheme' => \Elementor\Core\Schemes\Typography::TYPOGRAPHY_1,
               'selector' => '{{WRAPPER}} .products-slider .ts-course-el-title a, 
               {{WRAPPER}} .products-slider .ts-course-el-title a',
            ]
         );

         $this->add_control(
            'desc_style',
            [
               'label' => __( 'Description Style', 'qoxag' ),
               'type' => \Elementor\Controls_Manager::HEADING,
               'separator' => 'before',
            ]
         );
  
        $this->add_control(
           'content_color',
           [
              'label' => esc_html__('Description color', 'qoxag'),
              'type' => Controls_Manager::COLOR,
              'default' => '',
            
              'selectors' => [
                 '{{WRAPPER}} .ts-product-single-item p' => 'color: {{VALUE}};',
                 '{{WRAPPER}} .ts-product-single-item3 p' => 'color: {{VALUE}};',
              ],
           ]
        );
        $this->add_control(
           'content_hover_color',
           [
              'label' => esc_html__('Hover Description color', 'qoxag'),
              'type' => Controls_Manager::COLOR,
              'default' => '',
            
              'selectors' => [
                 '{{WRAPPER}} .ts-product-single-item:hover p' => 'color: {{VALUE}};',
                 '{{WRAPPER}} .ts-product-single-item3:hover p' => 'color: {{VALUE}};',
              ],
           ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
               'name' => 'post_content_typography',
               'label' => esc_html__( 'Description Typography', 'qoxag' ),
               'scheme' => \Elementor\Core\Schemes\Typography::TYPOGRAPHY_1,
               'selector' => '{{WRAPPER}} .ts-product-single-item p, {{WRAPPER}} .ts-product-single-item3 p',
            ]
         );
         $this->add_control(
            'price_style',
            [
               'label' => __( 'Price Style', 'qoxag' ),
               'type' => \Elementor\Controls_Manager::HEADING,
               'separator' => 'before',
            ]
         );
        $this->add_control(
           'price_color',
           [
              'label' => esc_html__('Price color', 'qoxag'),
              'type' => Controls_Manager::COLOR,
              'default' => '',
            
              'selectors' => [
                 '{{WRAPPER}} .products-slider .content-area .course-price-item .course-price' => 'color: {{VALUE}};',
                 '{{WRAPPER}} .products-slider .content-area .course-price-item .course-price' => 'color: {{VALUE}};',
              ],
           ]
        );
        $this->add_control(
           'discount_price_color',
           [
              'label' => esc_html__('Discount Price color', 'qoxag'),
              'type' => Controls_Manager::COLOR,
              'default' => '',
            
              'selectors' => [
                 '{{WRAPPER}} .products-slider .content-area .course-price-item .course-price del span' => 'color: {{VALUE}};',
                 '{{WRAPPER}} .products-slider .content-area .course-price-item .course-price del span' => 'color: {{VALUE}};',
              ],
           ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
               'name' => 'price_typography',
               'label' => esc_html__( 'Price Typography', 'qoxag' ),
               'scheme' => \Elementor\Core\Schemes\Typography::TYPOGRAPHY_1,
               'selector' => '{{WRAPPER}} .products-slider .content-area .course-price-item .course-price',
            ]
         );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
               'name' => 'discount_price_typography',
               'label' => esc_html__( 'Discount Price Typography', 'qoxag' ),
               'scheme' => \Elementor\Core\Schemes\Typography::TYPOGRAPHY_1,
               'selector' => '{{WRAPPER}} .products-slider .content-area .course-price-item .course-price del span',
            ]
         );
         $this->add_control(
            'btn_style',
            [
               'label' => __( 'Button Style', 'qoxag' ),
               'type' => \Elementor\Controls_Manager::HEADING,
               'separator' => 'before',
            ]
         );
         $this->add_control(
            'btn_color',
            [
               'label' => esc_html__('Btn color', 'qoxag'),
               'type' => Controls_Manager::COLOR,
               'default' => '',
             
               'selectors' => [
                  '{{WRAPPER}}  .woocommerce table.cart td.actions button.button, .woocommerce a.button, .woocommerce button.button.alt' => 'color: {{VALUE}};',
               ],
            ]
         );
         $this->add_control(
            'btn_bg_color',
            [
               'label' => esc_html__('Btn background color', 'qoxag'),
               'type' => Controls_Manager::COLOR,
               'default' => '',
             
               'selectors' => [
                  '{{WRAPPER}} .woocommerce table.cart td.actions button.button, .woocommerce a.button, .woocommerce button.button.alt' => 'background-color: {{VALUE}};',
               ],
            ]
         );

        $this->add_control(
           'btn_hover',
           [
              'label' => esc_html__('Btn hover color', 'qoxag'),
              'type' => Controls_Manager::COLOR,
              'default' => '',
            
              'selectors' => [
                 '{{WRAPPER}} .woocommerce table.cart td.actions button.button, .woocommerce a.button, .woocommerce button.button.alt' => 'color: {{VALUE}};',
                 '{{WRAPPER}} .woocommerce table.cart td.actions button.button, .woocommerce a.button, .woocommerce button.button.alt' => 'color: {{VALUE}};',
              ],
           ]
        );
        $this->add_control(
           'btn_hover_bg',
           [
              'label' => esc_html__('Btn hover bg color', 'qoxag'),
              'type' => Controls_Manager::COLOR,
              'default' => '',
            
              'selectors' => [
                 '{{WRAPPER}} .woocommerce #respond input#submit:hover, .woocommerce a.button:hover, .woocommerce button.button:hover, .woocommerce input.button:hover',
                 '{{WRAPPER}} .woocommerce #respond input#submit:hover, .woocommerce a.button:hover, .woocommerce button.button:hover, .woocommerce input.button:hover {{VALUE}};',
              ],
           ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
               'name' => 'btn_typography',
               'label' => esc_html__( 'Button Typography', 'qoxag' ),
               'scheme' => \Elementor\Core\Schemes\Typography::TYPOGRAPHY_1,
               'selector' => '{{WRAPPER}} .product-btn .btn',
            ]
         );
         $this->add_control(
            'advance_style',
            [
               'label' => __( 'Advance Style', 'qoxag' ),
               'type' => \Elementor\Controls_Manager::HEADING,
               'separator' => 'before',
            ]
         );
         $this->add_control(
            'box_hover',
            [
               'label' => esc_html__('Content Box hover bg color', 'qoxag'),
               'type' => Controls_Manager::COLOR,
               'selectors' => [
                  '{{WRAPPER}} .ts-product-single-item:hover' => 'background-color: {{VALUE}};',
                  '{{WRAPPER}} .ts-product-item.style2 .product-shape-hover-img' => 'fill: {{VALUE}};',
               ],
            ]
         );    
  
      $this->end_controls_section();
   }

   protected function render( ) {
      $settings = $this->get_settings_for_display();

      $tpl = get_widget_template($this->get_name());
      include $tpl;
  
   }

   protected function content_template() { }

   public function post_category() {

      $terms = get_terms( array(
         'taxonomy'    => 'product_cat',
         'hide_empty'  => false,
         'posts_per_page' => -1, 
      ) );

      $cat_list = [];
      if(!empty($terms) && ! is_wp_error( $terms )){
         foreach($terms as $post) {
            $cat_list[$post->term_id] = [$post->name];
         }
      }
      return $cat_list;

   }    

}