<?php

namespace Elementor;
if (!defined('ABSPATH')) exit;

use Qoxag\Core\Elementor\Controls\Qoxag_Layout;
use Qoxag\Core\Elementor\Controls\Qoxag_Post_Query;
use \ElementsKit_Lite\Modules\Controls\Controls_Manager as ElementsKit_Controls_Manager;

class Qoxag_Post_Block extends Widget_Base
{
    use \Qoxag\Core\Elementor\Traits\Grid_Controls;

    public $base;

    public function get_name()
    {
        return 'post-block';
    }

    public function get_title()
    {

        return esc_html__('Qoxag Post Block', 'qoxag');

    }

    public function get_icon()
    {
        return 'eicon-gallery-grid';
    }

    public function get_categories()
    {
        return ['qoxag-elements'];
    }

    protected function register_controls()
    {

        /*
         * Post Block Settings
         */
        $this->start_controls_section(
            'postgrid_section',
            [
                'label' => esc_html__('Post Block Settings', 'qoxag'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_group_control(
            Qoxag_Post_Query::get_type(),
            [
                'name' => 'query',
                'exclude' => ['posts_per_page_slider_note', 'slides_to_show', 'post_tabs']
            ]
        );

        $this->end_controls_section();

        /*
         * Layout Settings
         */

        $this->start_controls_section(
            'layout_section',
            [
                'label' => esc_html__('Layout', 'qoxag'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        if(class_exists('ElementsKit_Lite')){
        $this->add_control(
            'block_style',
            [
                'label' => esc_html__('Block Style', 'qoxag'),
                'type' => ElementsKit_Controls_Manager::IMAGECHOOSE,
                'default' => 'block-1',
                'options' => [
                    'block-1' => [
                        'title' => esc_html__('Style 1', 'qoxag'),
                        'imagelarge' => QOXAG_IMG . '/style/post-block/block1.png',
                        'imagesmall' => QOXAG_IMG . '/style/post-block/block1.png',
                        'width' => '30%',
                    ],
                    'block-2' => [
                        'title' => esc_html__('Style 2', 'qoxag'),
                        'imagelarge' => QOXAG_IMG . '/style/post-block/block2.png',
                        'imagesmall' => QOXAG_IMG . '/style/post-block/block2.png',
                        'width' => '30%',
                    ],
                    'block-3' => [
                        'title' => esc_html__('Style 3', 'qoxag'),
                        'imagelarge' => QOXAG_IMG . '/style/post-block/block3.png',
                        'imagesmall' => QOXAG_IMG . '/style/post-block/block3.png',
                        'width' => '30%',
                    ],
                    'block-4' => [
                        'title' => esc_html__('Style 4', 'qoxag'),
                        'imagelarge' => QOXAG_IMG . '/style/post-block/block4.png',
                        'imagesmall' => QOXAG_IMG . '/style/post-block/block4.png',
                        'width' => '30%',
                    ],
                    'block-5' => [
                        'title' => esc_html__('Style 5', 'qoxag'),
                        'imagelarge' => QOXAG_IMG . '/style/post-block/block5.png',
                        'imagesmall' => QOXAG_IMG . '/style/post-block/block5.png',
                        'width' => '30%',
                    ],
                    'block-6' => [
                        'title' => esc_html__('Style 6', 'qoxag'),
                        'imagelarge' => QOXAG_IMG . '/style/post-block/block2.png',
                        'imagesmall' => QOXAG_IMG . '/style/post-block/block2.png',
                        'width' => '30%',
                    ],
                    'block-7' => [
                        'title' => esc_html__('Style 7', 'qoxag'),
                        'imagelarge' => QOXAG_IMG . '/style/post-block/block7.png',
                        'imagesmall' => QOXAG_IMG . '/style/post-block/block7.png',
                        'width' => '30%',
                    ],
                    'block-8' => [
                        'title' => esc_html__('Style 8', 'qoxag'),
                        'imagelarge' => QOXAG_IMG . '/style/post-block/block8.png',
                        'imagesmall' => QOXAG_IMG . '/style/post-block/block8.png',
                        'width' => '30%',
                    ],
                    'block-9' => [
                        'title' => esc_html__('Style 9', 'qoxag'),
                        'imagelarge' => QOXAG_IMG . '/style/post-block/block9.png',
                        'imagesmall' => QOXAG_IMG . '/style/post-block/block9.png',
                        'width' => '30%',
                    ],
                ],
            ]
        );
        } else{
            $this->add_control(
                'block_style',
                [
                    'label' => esc_html__('Block Style', 'qoxag'),
                    'type' => \Elementor\Controls_Manager::SELECT,
                    'default' => 'block-1',
                    'options' => [
                        'block-1' => esc_html__('Style 1', 'qoxag'),
                        'block-2' => esc_html__('Style 2', 'qoxag'),
                        'block-3' => esc_html__('Style 3', 'qoxag'),
                        'block-4' => esc_html__('Style 4', 'qoxag'),
                        'block-5' => esc_html__('Style 5', 'qoxag'),
                        'block-6' => esc_html__('Style 6', 'qoxag'),
                        'block-7' => esc_html__('Style 7', 'qoxag'),
                        'block-8' => esc_html__('Style 8', 'qoxag'),
                        'block-9' => esc_html__('Style 9', 'qoxag'),
                    ],
                ]
            );
        }

        $this->add_group_control(
            Qoxag_Layout::get_type(),
            [
                'name' => 'layout',
                'exclude'   => ['layout_style'],
                'fields_options' => [
                    'column_number' => [
                        'default' => '2'
                    ],
                    'show_author' => [
                        'default' => 'yes',
                    ],
                    'thumbnail_image_aspect_ratio' => [
                        'selectors' => [
                            '{{WRAPPER}} .qoxag-grid-single .post-thumbnail' => 'padding-bottom: calc( {{size}} * 100% );',
                        ],
                    ],
                ],
            ]
        );

        $this->end_controls_section();

        /*
         * Featured Layout Settings
         */

        $this->start_controls_section(
            'featured_layout_section',
            [
                'label' => esc_html__('Featured Post', 'qoxag'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_group_control(
            Qoxag_Layout::get_type(),
            [
                'name' => 'featured',
                'exclude' => ['layout_style', 'column_number', 'content_align', 'category_style'],
                'fields_options' => [
                    'show_content' => [
                        'default' => 'yes',
                    ],
                ],
            ]
        );

        $this->add_control(
            'featured_category_style',
            [
                'label' => esc_html__('Category Style', 'qoxag'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'default',
                'options' => [
                    'default' => esc_html__('Style 1', 'qoxag'),
                    'left-background' => esc_html__('Style 2', 'qoxag'),
                    'no-background' => esc_html__('Style 3', 'qoxag'),
                ],
                'condition' => ['block_style' => ['block-6', 'block-9']],
            ]
        );

        $this->add_control(
            'reverse_featured_column',
            [
                'label' => esc_html__('Reverse Featured Column', 'qoxag'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'qoxag'),
                'label_off' => esc_html__('No', 'qoxag'),
                'default' => false,
                'return_value' => true,
                'condition' => ['block_style' => ['block-2', 'block-6']],
                'selectors' => [
                    '{{WRAPPER}} .qoxag-post-block .first-block' => 'order: 1',
                ],
            ]
        );

        $this->add_control(
            'featured_content_align',
            [
                'label' => esc_html__('Content Alignment', 'qoxag'),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__('Left', 'qoxag'),
                        'icon' => 'fas fa-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__('Center', 'qoxag'),
                        'icon' => 'fas fa-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__('Right', 'qoxag'),
                        'icon' => 'fas fa-align-right',
                    ],
                ],
                'condition' => ['block_style' => ['block-6']],
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .first-block .post-content' => 'text-align: {{VALUE}};'
                ],
            ]
        );

        $this->add_control(
            'featured_skip_post',
            [
                'label' => esc_html__('Skip Featured Post', 'qoxag'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'qoxag'),
                'label_off' => esc_html__('No', 'qoxag'),
                'default' => 'yes',
                'condition' => ['block_style' => ['block-7', 'block-8']],
            ]
        );

        $this->end_controls_section();

        /*
         * Advanced Ordering Settings
         */

        $this->advance_ordering_controls();

        /*
         * Title Style
         */
        $this->title_style_controls();

        /*
         * Image Style
         */
        $this->image_style_controls();

        /*
         * Meta and Category Style
         */
        $this->meta_style_controls();


        /*
         * Content Style
         */
        $this->description_style_controls();

        /*
         * Feature Style
         */

        $this->start_controls_section(
            'section_featured_style', [
                'label' => esc_html__('Featured', 'qoxag'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'featured_post_title_typography',
                'label' => esc_html__('Title Typography', 'qoxag'),
                'scheme' => Core\Schemes\Typography::TYPOGRAPHY_1,
                'selector' => '{{WRAPPER}} .first-block .qoxag-grid-single .post-heading a',
                'fields_options' => [
                    'typography' => [
                        'default' => 'custom',
                    ],
                    'font_weight' => [
                        'default' => '600',
                    ],
                    'font_size' => [
                        'default' => [
                            'size' => '18',
                            'unit' => 'px'
                        ],
                        'size_units' => ['px']
                    ],
                    'line_height' => [
                        'default' => [
                            'size' => '25',
                            'unit' => 'px'
                        ],
                        'size_units' => ['px']
                    ],
                ],
            ]
        );

        $this->add_control(
            'featured_title_color', [
                'label'		 => esc_html__( 'Title color', 'qoxag' ),
                'type'		 => Controls_Manager::COLOR,
                'default'    => '#041a57',
                'selectors'	 => [
                    '{{WRAPPER}} .first-block .qoxag-grid-single .post-heading a ' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .first-block .qoxag-grid-single .post-heading a:hover' => 'background-image: linear-gradient(to bottom, {{VALUE}} 0%, {{VALUE}} 98%);',
                ],
            ]
        );

        $this->add_responsive_control(
            'featured_thumbnail_image_aspect_ratio',
            [
                'label' => esc_html__('Image Aspect Ratio', 'qoxag'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'condition' => ['featured_show_thumbnail' => ['yes']],
                'size_units' => ['%'],
                'range' => [
                    '%' => [
                        'min' => 0.01,
                        'max' => 3.0,
                        'step' => 0.01,
                    ],
                ],
                'default' => [
                    'unit' => '%',
                    'size' => 0.5,
                ],
                'tablet_default' => [
                    'unit' => '%',
                    'size' => 0.3,
                ],
                'mobile_default' => [
                    'unit' => '%',
                    'size' => 0.5,
                ],
                'selectors' => [
                    '{{WRAPPER}} .first-block .qoxag-grid-single .post-thumbnail' => 'padding-bottom: calc( {{size}} * 100% );',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Image_Size::get_type(),
            [
                'name' => 'featured_thumbnail_img_size',
                'condition' => ['featured_show_thumbnail' => ['yes']],
                'exclude' => [ 'custom' ],
                'include' => [],
                'default' => 'large',
            ]
        );

        $this->add_responsive_control(
            'featured_content_padding',
            [
                'label' => esc_html__('Content Padding', 'qoxag'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px'],
                'default' => [
                    'top' => '0',
                    'right' => '0',
                    'bottom' => '0',
                    'left' => '0',
                    'unit' => 'px',
                    'isLinked' => false,
                ],
                'selectors' => [
                    '{{WRAPPER}} .first-block .qoxag-grid-single .post-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'featured_meta_color', [
                'label'		 => esc_html__( 'Meta color', 'qoxag' ),
                'type'		 => Controls_Manager::COLOR,
                'default'    => '#404040',
                'selectors'	 => [
                    '{{WRAPPER}} .first-block .qoxag-grid-single .post-meta span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'featured_description_color', [
                'label'		 => esc_html__( 'Description color', 'qoxag' ),
                'type'		 => Controls_Manager::COLOR,
                'default'    => '#404040',
                'selectors'	 => [
                    '{{WRAPPER}} .first-block .qoxag-grid-single .post-excerpt' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'featured_content_margin',
            [
                'label' => esc_html__('Content Margin', 'qoxag'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .first-block .qoxag-grid-single .post-content' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' => ['block_style' => ['block-6']],
            ]
        );

        $this->add_responsive_control(
            'featured_content_border_radius',
            [
                'label' => esc_html__('Content Border Radius', 'qoxag'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .first-block .qoxag-grid-single .post-content' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' => ['block_style' => ['block-6']],
            ]
        );

        $this->add_responsive_control(
            'featured_category_position_vertical',
            [
                'label' => esc_html__('Category Vertical Position', 'qoxag'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'separator' => 'before',
                'size_units' => ['px', '%'],
                'condition' => ['block_style' => ['block-6', 'block-9']],
                'range' => [
                    'px' => [
                        'min' => -500,
                        'max' => 500,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => -100,
                        'max' => 100,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => '%',
                    'size' => 0,
                ],
                'selectors' => [
                    '{{WRAPPER}} .first-block .category-wrapper' => 'top: {{SIZE}}{{UNIT}}; position: relative;',
                ],
                'separator' => 'before',
            ]
        );

        $this->add_responsive_control(
            'featured_category_padding',
            [
                'label' => esc_html__('Category Padding', 'qoxag'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px'],
                'condition' => ['block_style' => ['block-9']],
                'default' => [
                    'top' => '0',
                    'right' => '0',
                    'bottom' => '0',
                    'left' => '0',
                    'unit' => 'px',
                    'isLinked' => false,
                ],
                'selectors' => [
                    '{{WRAPPER}} .first-block .qoxag-grid-single .post-cat' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'featured_content_background',
                'types' => [ 'classic', 'gradient'],
                'selector' => '{{WRAPPER}} .first-block .qoxag-grid-single .post-content',
                'description' => esc_html__('Background for the inner contents', 'qoxag'),
                'fields_options' => [
                    'background'     => [
                        'label'   => esc_html__('Content Background', 'qoxag'),
                    ],
                ],
            ]
        );

        $this->end_controls_section();

        /*
         * Advanced style Style
         */
        $this->start_controls_section(
            'section_wrapper_style', [
                'label' => esc_html__('Wrapper Style', 'qoxag'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->advanced_style_controls();

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();

        switch ($settings['block_style']) {
            case 'block-1':
                $block_style_values = array(
                    'column'=>'2',
                    'default_layout'=>'thumb-left',
                    'featured_layout'=>'thumb-left'
                );
            break;
            case 'block-2':
                $block_style_values = array(
                    'column'    => '2',
                    'default_layout'    => 'thumb-top',
                    'featured_layout'    => 'thumb-bg',
                );
            break;
            case 'block-3':
                $block_style_values = array(
                    'column'    => '1',
                    'default_layout'    => 'thumb-left',
                    'featured_layout'    => 'thumb-bg',
                );
            break;
            case 'block-4':
                $block_style_values = array(
                    'column'    => '1',
                    'default_layout'    => 'thumb-left',
                    'featured_layout'    => 'thumb-top',
                );
            break;
            case 'block-5':
                $block_style_values = array(
                    'column'    => '2',
                    'default_layout'    => 'thumb-top',
                    'featured_layout'    => 'thumb-bg',
                );
            break;
            case 'block-6':
                $block_style_values = array(
                    'column'    => '1',
                    'default_layout'    => 'thumb-top',
                    'featured_layout'    => 'thumb-bg',
                );
            break;
            case 'block-7':
                $block_style_values = array(
                    'column'    => '1',
                    'default_layout'    => 'thumb-left',
                    'featured_layout'    => 'thumb-bg',
                );
            break;
            case 'block-8':
                $block_style_values = array(
                    'column'    => '1',
                    'default_layout'    => 'thumb-left',
                    'featured_layout'    => 'thumb-bg',
                );
            break;
            case 'block-9':
                $block_style_values = array(
                    'column'    => '1',
                    'default_layout'    => 'thumb-left',
                    'featured_layout'    => 'thumb-top',
                );
            break;            
            default:
                $block_style_values = array(
                    'column'=>'2',
                    'default_layout'=>'thumb-left',
                    'featured_layout'=>'thumb-left'
                );
            break;
        }

        $tpl = get_widget_template($this->get_name());
        include $tpl;
    }

    protected function content_template()
    {
    }
}