<?php

namespace Elementor;

if (!defined('ABSPATH')) exit;


class Qoxag_News_Ticker extends Widget_Base
{

    use \Qoxag\Core\Elementor\Traits\Grid_Controls;
    use \Qoxag\Core\Elementor\Traits\Slider_Controls;

    public $base;

    public function get_name()
    {
        return 'news-ticker';
    }

    public function get_title()
    {

        return esc_html__('News Ticker', 'qoxag');

    }

    public function get_icon()
    {
        return 'eicon-image';
    }

    public function get_categories()
    {
        return ['qoxag-elements'];
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'section_tab',
            [
                'label' => esc_html__('News Ticket Content', 'qoxag'),
            ]
        );

        $this->add_control(
            'slide_arrows',
            [
                'label' => esc_html__('Show Navigation', 'qoxag'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'qoxag'),
                'label_off' => esc_html__('No', 'qoxag'),
                'default' => 'no',

            ]
        );

        $this->add_control(
            'slide_dots',
            [
                'label' => esc_html__('Show Dots', 'qoxag'),
                'type' => \Elementor\Controls_Manager::HIDDEN,
                'default' => 'no',

            ]
        );

        $this->add_control(
            'title', [
                'label' => esc_html__('Title', 'qoxag'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'placeholder' => esc_html__('News ticker title', 'qoxag'),
                'default' => esc_html__('Trending', 'qoxag'),

            ]
        );

        $this->add_control(
            'orderby',
            [
                'label' => esc_html__('Posts Select By', 'qoxag'),
                'type' => Controls_Manager::SELECT,
                'default' => 'date',
                'options' => [
                    'date' => esc_html__('Date', 'qoxag'),
                    'ID' => esc_html__('ID', 'qoxag'),
                    'title' => esc_html__('Title', 'qoxag'),
                    'comment_count' => esc_html__('Comment Count', 'qoxag'),
                    'name' => esc_html__('Name', 'qoxag'),
                    'rand' => esc_html__('Random', 'qoxag'),
                    'menu_order' => esc_html__('Menu Order', 'qoxag'),
                ],
            ]
        );

        $this->add_control(
            'order',
            [
                'label' => esc_html__('Post Order', 'qoxag'),
                'type' => Controls_Manager::SELECT,
                'default' => 'DESC',
                'options' => [
                    'DESC' => esc_html__('Descending', 'qoxag'),
                    'ASC' => esc_html__('Ascending', 'qoxag'),
                ],
            ]
        );

        $this->add_control(
            'posts_per_page',
            [
                'label' => esc_html__('Post Count', 'qoxag'),
                'type' => Controls_Manager::NUMBER,
                'default' => '5',
            ]
        );

        $this->add_control(
            'post_cats',
            [
                'label' => esc_html__('Select Categories', 'qoxag'),
                'type' => Controls_Manager::SELECT2,
                'options' => $this->post_category(),
                'label_block' => true,
                'multiple' => true,
            ]
        );

        $this->add_control('title_crop',
        [
            'label' => esc_html__('Title Word Limit', 'qoxag'),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'range' => [
                'px' => [
                    'min' => 1,
                    'max' => 100,
                ],
            ],
            'default' => [
                'unit' => 'px',
                'size' => 35,
            ],
        ]);

        $this->add_responsive_control(
            'text_align', [
                'label' => esc_html__('Alignment', 'qoxag'),
                'type' => Controls_Manager::CHOOSE,
                'options' => [

                    'left' => [
                        'title' => esc_html__('Left', 'qoxag'),
                        'ts-icon' => 'fa fa-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__('Center', 'qoxag'),
                        'ts-icon' => 'fa fa-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__('Right', 'qoxag'),
                        'ts-icon' => 'fa fa-align-right',
                    ],
                ],
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .tranding-bg-white' => 'text-align: {{VALUE}};'
                ],
            ]
        );

        $this->add_responsive_control(
            'ticker_padding',
            [
                'label' => esc_html__('Padding', 'qoxag'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .tranding-bg-white' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section('qoxag_style_block_section',
            [
                'label' => esc_html__(' Post', 'qoxag'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => esc_html__('Title color', 'qoxag'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tranding-bar .trending-slide .trending-title, .tranding-bar .trending-slide .trending-title i' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'post_title_typography',
                'label' => esc_html__('Title Typography', 'qoxag'),
                'scheme' => Core\Schemes\Typography::TYPOGRAPHY_1,
                'selector' => '{{WRAPPER}} .tranding-bar .trending-slide .trending-title',
            ]
        );

        $this->add_control(
            'news_color',
            [
                'label' => esc_html__('News Color', 'qoxag'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tranding-bar .swiper-slide .post-title a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'news_title_typography',
                'label' => esc_html__('News Typography', 'qoxag'),
                'scheme' => Core\Schemes\Typography::TYPOGRAPHY_1,
                'selector' => '{{WRAPPER}} .tranding-bar .swiper-slide .post-title a',
            ]
        );

        $this->end_controls_section();

        /*
           Slider Navigation Style
        */
        $this->slider_navigation_style_controls();


    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();

        $title = $settings['title'];
        $newsticker_nav_enable = $settings['slide_arrows'];
        $post_title_crop = isset($settings['title_crop']) ? $settings['title_crop']['size'] : '35';


        $args = array(
            'orderby' => $settings['orderby'],
            'order' => $settings['order'],
            'posts_per_page' => $settings['posts_per_page'],
        );

        if (!empty($settings['post_cats'])) {
            $args['tax_query'] = array(
                array(
                    'taxonomy' => 'category',
                    'field' => 'id',
                    'terms' => $settings['post_cats']
                )
            );
        }

        $posts = get_posts($args);

        $tpl = get_widget_template($this->get_name());
        include $tpl;

        ?>
        <?php
    }

    protected function content_template()
    {
    }

    public function post_category()
    {

        $terms = get_terms(array(
            'taxonomy' => 'category',
            'hide_empty' => false,
            'posts_per_page' => -1,
        ));

        $cat_list = [];
        if(!empty($terms)){
            foreach ($terms as $post) {
                $cat_list[$post->term_id] = [$post->name];
            }
        }
        return $cat_list;
    }
}