<?php

namespace Elementor;

use Qoxag\Core\Elementor\Controls\Qoxag_Layout;
use \Qoxag\Core\Elementor\Controls\Qoxag_Post_Query;
use \ElementsKit_Lite\Modules\Controls\Controls_Manager as ElementsKit_Controls_Manager;

if (!defined('ABSPATH')) exit;


class Qoxag_Main_Slider extends Widget_Base
{
    use \Qoxag\Core\Elementor\Traits\Grid_Controls;
    use \Qoxag\Core\Elementor\Traits\Slider_Controls;

    public $base;

    public function get_name()
    {
        return 'main-slider';
    }

    public function get_title()
    {

        return esc_html__('Qoxag Main Slider', 'qoxag');

    }

    public function get_icon()
    {
        return 'eicon-slider-album';
    }

    public function get_categories()
    {
        return ['qoxag-elements'];
    }

    protected function register_controls()
    {

        /*
         * Post Grid Settings
         */
        $this->start_controls_section(
            'postgrid_section',
            [
                'label' => esc_html__('Post Slider Settings', 'qoxag'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_group_control(
            Qoxag_Post_Query::get_type(),
            [
                'name' => 'query',
                'exclude' => ['post_tabs'],
                'fields_options' => [
                    'slides_to_show' => [
                        'default' => '3'
                    ],
                ],
            ]
        );

        $this->end_controls_section();

        /*
         * Layout Settings
         */

        $this->start_controls_section(
            'layout_section',
            [
                'label' => esc_html__('Layout', 'qoxag'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        if(class_exists('ElementsKit_Lite')){
        $this->add_control('layout_layout_style', [
            'label' => esc_html__('Style', 'qoxag'),
            'type' => ElementsKit_Controls_Manager::IMAGECHOOSE,
            'default' => 'thumb-bg',
            'options' => [
                'thumb-bg' => [
                    'title' => esc_html__('Thumbnail Background', 'qoxag'),
                    'imagelarge' => QOXAG_IMG . '/style/main-slider/main-slider-1.png',
                    'imagesmall' => QOXAG_IMG . '/style/main-slider/main-slider-1.png',
                    'width' => '30%',
                ],
                'thumb-top' => [
                    'title' => esc_html__('Thumbnail Right', 'qoxag'),
                    'imagelarge' => QOXAG_IMG . '/style/main-slider/main-slider-1.png',
                    'imagesmall' => QOXAG_IMG . '/style/main-slider/main-slider-1.png',
                    'width' => '30%',
                ]
            ],
        ]);
        } else{
            $this->add_control('layout_layout_style', [
                'label' => esc_html__('Style', 'qoxag'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'thumb-bg',
                'options' => [
                    'thumb-bg' => esc_html__('Thumbnail Background', 'qoxag'),
                    'thumb-top' => esc_html__('Thumbnail Right', 'qoxag'),
                ],
            ]);
        }

        $this->add_group_control(
            Qoxag_Layout::get_type(),
            [
                'name' => 'layout',
                'exclude' => ['layout_style', 'column_number'],
                'fields_options' => [
                    'category_position' => [
                        'default' => 'onimage'
                    ],
                ],
            ]
        );

        $this->add_control( 'layout_show_video_popup_icon', [
            'label' => esc_html__( 'Show Video Popup Icon', 'qoxag' ),
            'type' => Controls_Manager::SWITCHER,
            'default' => 'yes',
            'condition' => ['layout_layout_style' => ['thumb-top']],
        ]);

        $this->end_controls_section();

        /*
         * Slider Settings
         */
        $this->slider_controls([
            'defaults' =>[
                'slide_dots' => 'no'
            ]
        ]);

        /*
         * Advanced Ordering Settings
         */

        $this->advance_ordering_controls();

        /*
         * Title Style
         */
        $this->title_style_controls();

        /*
         * Image Style
         */
        $this->image_style_controls([
            'defaults' => [
                'layout_thumbnail_image_aspect_ratio'    => [
                    'default' => 0.77,
                    'tablet_default' => 0.3,
                    'mobile_default' => 0.5,
                ]
            ]
        ]);

        /*
         * Meta and Category Style
         */
        $this->meta_style_controls();

        /*
         * Content Style
         */
        $this->description_style_controls();

        /*
        * Slider Style
        */
        $this->slider_style_controls([
            'defaults' => [
                'bottom_spacing'    => [
                    'unit' => 'px',
                    'size' => '-100'
                ],
                'main_slider_image_aspect_ratio'    => [
                    'default' => 0.527,
                    'tablet_default' => 0.527,
                    'mobile_default' => 0.527,
                ]
            ]
        ]);

        /*
         * Slider Navigation Style
         */
        $this->slider_navigation_style_controls();


        /*
         * Advanced style Style
         */
        $this->start_controls_section(
            'section_wrapper_style', [
                'label' => esc_html__('Wrapper Style', 'qoxag'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'content_width',
            [
                'label' => esc_html__('Content Width', 'qoxag'),
                'type' => Controls_Manager::SLIDER,
                'condition' => ['layout_layout_style' => ['thumb-top']],
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 12,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 1,
                ],
                'selectors' => [
                    '{{WRAPPER}} .swiper-slide-active .qoxag-grid-single.thumb-right .post-thumbnail' => 'flex-grow: {{SIZE}};',
                ],
            ]
        );

        $this->advanced_style_controls([
            'exclude'    => [
                'wrapper_margin',
                'wrapper_padding',
                'wrapper_border'
            ]
        ]);

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();

        switch ($settings['layout_layout_style']) {
            case 'thumb-bg':
                $block_style_values = array(
                    'main_layout'=>'thumb-bg',
                    'thumb_layout'=>'thumb-bg'
                );
                break;
            case 'thumb-top':
                $block_style_values = array(
                    'main_layout'=>'thumb-right',
                    'thumb_layout'=>'thumb-top'
                );
                break;           
            default:
                $block_style_values = array(
                    'main_layout'=>'thumb-bg',
                    'thumb_layout'=>'thumb-bg'
                );
                break;
        }

        $tpl = get_widget_template($this->get_name());
        include $tpl;
    }

    protected function content_template()
    {
    }

    public function get_value($control){
        return $control;
    }
}