<?php

namespace Elementor;

if (!defined('ABSPATH')) exit;


class Qoxag_Back_To_Top extends Widget_Base
{


    public $base;

    public function get_name()
    {
        return 'back-to-top';
    }

    public function get_title()
    {

        return esc_html__('Qoxag Back To Top', 'qoxag');

    }

    public function get_icon()
    {
        return 'eicon-spacer';
    }

    public function get_categories()
    {
        return ['qoxag-elements'];
    }

    protected function _register_controls()
    {

        $this->start_controls_section(
            'section_tab',
            [
                'label' => esc_html__('back to top settings', 'qoxag'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'backto_button_icon',
            [
                'label' => esc_html__('Select Icon', 'qoxag'),
                'type' => Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-sort-up',
                ]
            ]
        );


        $this->start_controls_tabs('qoxag_tabs_styled');

        $this->start_controls_tab(
            'tab_style_normal',
            [
                'label' => esc_html__('Button Normal', 'qoxag'),
            ]
        );

        $this->add_control(
            'backto_button_color',
            [
                'label' => esc_html__('Button color', 'qoxag'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .qoxag-back-top' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'backto_button_bg_color',
                'label' => esc_html__('Backto BG color', 'qoxag'),
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .qoxag-back-top',
            ]
        );

        $this->add_responsive_control(
            'backto_border_radius',
            [
                'label' => esc_html__('Border Radius', 'qoxag'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .qoxag-back-top' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'backto_font_size',
            [
                'label' => esc_html__('Icon Size', 'qoxag'),
                'type' => Controls_Manager::SLIDER,
                'selectors' => [
                    '{{WRAPPER}} .qoxag-back-top i' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'backto_border_normal',
                'label' => esc_html__('Border', 'qoxag'),
                'selector' => '{{WRAPPER}} .qoxag-back-top',
            ]
        );

        $this->add_responsive_control(
            'backto_border_padding',
            [
                'label' => esc_html__('Button Padding', 'qoxag'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .qoxag-back-top i' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'tab_style_active',
            [
                'label' => esc_html__('Button Hover', 'qoxag'),
            ]
        );

        $this->add_control(
            'backto_button_hov_color',
            [
                'label' => esc_html__('Backto Hover color', 'qoxag'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .qoxag-back-top:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'backto_button_hov_bg_color',
                'label' => esc_html__('Backto Button Hover BG color', 'qoxag'),
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .qoxag-back-top:hover',
            ]
        );

        $this->add_responsive_control(
            'backto_hov_border_radius',
            [
                'label' => esc_html__('Border Radius', 'qoxag'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .qoxag-back-top:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'backto_border_hover',
                'label' => esc_html__('Border', 'qoxag'),
                'selector' => '{{WRAPPER}} .qoxag-back-top:hover',
            ]
        );


        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();

        $tpl = get_widget_template($this->get_name());
        include $tpl;
    }

    protected function content_template()
    {
    }
}