<?php
$post_order         = $settings['post_order'];
$post_sortby        = $settings['post_sortby'];
$post_number        = $settings['post_count'];
$show_navigation    = $settings['show_navigation'];
$auto_play          = $settings['auto_play'];
$post_per_page      = $settings['post_per_page'];


$arg = [
    'post_type'   =>  'product',
    'post_status' => 'publish',
    'order' => $settings['post_order'],
    'posts_per_page' => $post_per_page,

];

if(!empty($settings['post_cats'])){
   $arg['tax_query']  = 
   [
      array(
      'taxonomy'  => 'product_cat',
      'field'     => 'term_id',
      'terms'     => $settings['post_cats'],
      'operator'  => 'IN',
      )
   ];
}


switch($settings['post_sortby']){
 case 'mostdiscussed':
     $arg['orderby'] = 'comment_count';
 break;
 default:
     $arg['orderby'] = 'date';
 break;
}

$controls = [
   'nav'          => $show_navigation,
   'auto_play'    => $auto_play,
   'post_count'   =>  $post_number
];
$controls = json_encode($controls);

$query = get_posts($arg);

if ($query) { ?>
    <div class="products-slider woocommerce" data-controls="<?php echo esc_attr($controls); ?>">
        <div class="swiper-container">
            <div class="swiper-wrapper">
                <?php
                foreach ($query as $key => $post) {
                    ?>
                    <div class="swiper-slide">
                        <?php
                        $postid = $post->ID;
                        qoxag_woocommerce_template_loop_product($post->ID);
                        ?>
                    </div>
                    <?php
                }
                ?>
            </div>
        </div>

        <?php if ("yes" == $show_navigation){ ?>
         <div class="swiper-button-prev swiper-prev-<?php echo esc_attr($this->get_id()); ?>">
            <i class="xts-icon xts-chevron-left"></i>
         </div>
         <div class="swiper-button-next swiper-next-<?php echo esc_attr($this->get_id()); ?>">
            <i class="xts-icon xts-chevron-right"></i>
         </div>
        <?php } ?>
    </div>
<?php } ?>