<?php
    $category_limit = $qoxag_category_settings['category-options']['category_limit'];
    $categories_id  = $qoxag_category_settings['category-options']['categories_id'];
    $post_sort_by   = $qoxag_category_settings['category-options']['post_sort_by'];
    $hide_empty     = $qoxag_category_settings['hide_empty']=='yes'?'1':'0';
    $taxonomy       = 'category';

    if(!empty($categories_id)){
        $cats = $categories_id;
    }else{
        $args_cat = array(
            'taxonomy'     => $taxonomy,
            'number' => $category_limit,
            'hide_empty' => $hide_empty,
            'orderby'    => 'post_date',
            'order'    => $post_sort_by,
        );
        $cats = get_categories( $args_cat );
    }
  
   
    ?>
    <section class="category-style">
        <div class="row">
            <div class="col-12">
                <div class="ts-event-category">
                    <?php  
                        foreach($cats as $value){ 

                        $term = get_term($value,$taxonomy); 
                        $img_id = get_term_meta($term->term_id, 'devmonsta_category_image', true);
                        $img_url = wp_get_attachment_image_url($img_id, 'full');
                        $term_link = get_term_link($term->slug, $taxonomy);
                        $category_desc = category_description( $term->term_id );
                    
                    ?>
                        <div class="cat-item">
                            <?php if($img_url !=''):  ?>
                                <div class="cat-bg" style="background-image: url('<?php echo  esc_url($img_url) ?>');">
                                    <a class="cat-link" href="<?php echo esc_url($term_link); ?>"></a>
                                </div>
                            <?php endif; ?>

                            <div class="cat-content">
                                
                                <h3 class="ts-title"> <a href="<?php echo esc_url($term_link); ?>"><?php echo esc_html($term->name); ?></a>  </h3>
                                <p class="cat-count"> 
                                    <?php
                                        printf( _nx( '%s category', '%s categories', $term->count, 'Categories', 'qoxag' ), number_format_i18n( $term->count ) );
                                    ?> 
                                </p>
                            <div class="description">
                                    <?php
                                    echo qoxag_kses($category_desc);
                                    ?>
                                    <a class="btn" href="<?php echo esc_url($term_link); ?>"><?php echo esc_html__('Read More','qoxag'); ?></a>
                            </div>
                            </div>
                        </div> 
                    <?php } ?>
                </div>
            </div>
        </div>
    </section>
  
   <?php 