<?php

namespace Qoxag\Core\Elementor\Controls;
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

use Elementor\Group_Control_Base;
use \ElementsKit_Lite\Modules\Controls\Controls_Manager as ElementsKit_Controls_Manager;

/**
 * Elementor choose control.
 *
 * A base control for creating choose control. Displays radio buttons styled as
 * groups of buttons with icons for each option.
 *
 * @since 1.0.0
 */
class Qoxag_Layout extends Group_Control_Base
{

    protected static $fields;

    public static function get_type()
    {
        return 'postlayout';
    }

    protected function init_fields()
    {
        $fields = [];

        if(class_exists('ElementsKit_Lite')){
        $fields['layout_style'] = [ 
            'label' => esc_html__('Style', 'qoxag'),
            'type' => ElementsKit_Controls_Manager::IMAGECHOOSE,
            'default' => 'thumb-top',
            'options' => [
                'thumb-top' => [
                    'title' => esc_html__('Thumbnail on Top', 'qoxag'),
                    'imagelarge' => QOXAG_IMG . '/style/layout/layout1.png',
                    'imagesmall' => QOXAG_IMG . '/style/layout/layout1.png',
                    'width' => '30%',
                ],
                'thumb-bg' => [
                    'title' => esc_html__('Thumbnail Background', 'qoxag'),
                    'imagelarge' => QOXAG_IMG . '/style/layout/layout2.png',
                    'imagesmall' => QOXAG_IMG . '/style/layout/layout2.png',
                    'width' => '30%',
                ],
                'thumb-left' => [
                    'title' => esc_html__('Thumbnail Left', 'qoxag'),
                    'imagelarge' => QOXAG_IMG . '/style/layout/layout3.png',
                    'imagesmall' => QOXAG_IMG . '/style/layout/layout3.png',
                    'width' => '30%',
                ],
                'thumb-right' => [
                    'title' => esc_html__('Thumbnail Right', 'qoxag'),
                    'imagelarge' => QOXAG_IMG . '/style/layout/layout4.png',
                    'imagesmall' => QOXAG_IMG . '/style/layout/layout4.png',
                    'width' => '30%',
                ],
            ],
        ];
        } else{
            $fields['layout_style'] = [ 
                'label' => esc_html__('Style', 'qoxag'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'thumb-top',
                'options' => [
                    'thumb-top' => esc_html__('Thumbnail on Top', 'qoxag'),
                    'thumb-bg' =>  esc_html__('Thumbnail Background', 'qoxag'),                        
                    'thumb-left' => esc_html__('Thumbnail Left', 'qoxag'),                       
                    'thumb-right' =>esc_html__('Thumbnail Right', 'qoxag'),
                ],
            ];
        }

        $fields['column_number'] = [
            'label' => esc_html__('Column', 'qoxag'),
            'type' => \Elementor\Controls_Manager::SELECT,
            'default' => '3',
            'tablet_default' => '2',
            'mobile_default' => '1',
            'options' => [
                '1' => esc_html__('Column 1', 'qoxag'),
                '2' => esc_html__('Column 2', 'qoxag'),
                '3' => esc_html__('Column 3', 'qoxag'),
                '4' => esc_html__('Column 4', 'qoxag'),
                '6' => esc_html__('Column 6', 'qoxag'),
            ],
            'responsive' => true
        ]; 

        $fields['show_thumbnail'] = [
            'label' => esc_html__('Show Image', 'qoxag'),
            'type' => \Elementor\Controls_Manager::SWITCHER,
            'label_on' => esc_html__('Yes', 'qoxag'),
            'label_off' => esc_html__('No', 'qoxag'),
            'default' => 'yes',
        ];

        $fields['show_category'] = [
            'label' => esc_html__('Show Category', 'qoxag'),
            'type' => \Elementor\Controls_Manager::SWITCHER,
            'label_on' => esc_html__('Yes', 'qoxag'),
            'label_off' => esc_html__('No', 'qoxag'),
            'default' => 'yes',
        ];

        $fields['category_style'] = [
            'label' => esc_html__('Category Style', 'qoxag'),
            'type' => \Elementor\Controls_Manager::SELECT,
            'default' => 'default',
            'options' => [
                'default' => esc_html__('Style 1', 'qoxag'),
                'left-background' => esc_html__('Style 2', 'qoxag'),
                'no-background' => esc_html__('Style 3', 'qoxag'),
            ],
            'condition' => [
                'show_category' => ['yes'],
            ],
        ];

        $fields['number_of_categories'] = [
            'label' => esc_html__('Number of Categories', 'qoxag'),
            'type' => \Elementor\Controls_Manager::NUMBER,
            'default' => '1',
            'min' => 1,
            'max' => 20,
            'condition' => ['show_category' => ['yes']],
        ];

        $fields['category_position'] = [
            'label' => esc_html__('Category Position', 'qoxag'),
            'type' => \Elementor\Controls_Manager::SELECT,
            'default' => 'contentpart',
            'options' => [
                'contentpart' => esc_html__('Content Part', 'qoxag'),
                'onimage' => esc_html__('On Image', 'qoxag'),
            ],
            'condition' => [
                'show_category' => ['yes'],
                'show_thumbnail' => ['yes'],
                'layout_style' => ['thumb-top', 'thumb-bg', 'featured-slider thumb-top'],
            ],
        ];

        $fields['post_title_crop'] = [
            'label' => esc_html__('Title Word Limit', 'qoxag'),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'range' => [
                'px' => [
                    'min' => 1,
                    'max' => 100,
                ],
            ],
            'default' => [
                'unit' => 'px',
                'size' => 35,
            ],
        ];

        $fields['show_content'] = [
            'label' => esc_html__('Show Description', 'qoxag'),
            'type' => \Elementor\Controls_Manager::SWITCHER,
            'label_on' => esc_html__('Yes', 'qoxag'),
            'label_off' => esc_html__('No', 'qoxag'),
            'default' => 'no',
        ];

        $fields['post_content_crop'] = [
            'label' => esc_html__('Description Word Limit', 'qoxag'),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'condition' => ['show_content' => ['yes']],
            'range' => [
                'px' => [
                    'min' => 1,
                    'max' => 100,
                ],
            ],
            'default' => [
                'unit' => 'px',
                'size' => 20,
            ],
        ];

        $fields['show_date'] = [
            'label' => esc_html__('Show Date', 'qoxag'),
            'type' => \Elementor\Controls_Manager::SWITCHER,
            'label_on' => esc_html__('Yes', 'qoxag'),
            'label_off' => esc_html__('No', 'qoxag'),
            'default' => 'yes',
        ];

        $fields['show_author'] = [
            'label' => esc_html__('Show Author', 'qoxag'),
            'type' => \Elementor\Controls_Manager::SWITCHER,
            'label_on' => esc_html__('Yes', 'qoxag'),
            'label_off' => esc_html__('No', 'qoxag'),
            'default' => 'yes',
        ];

        $fields['show_view_count'] = [
            'label' => esc_html__('Show View Count', 'qoxag'),
            'type' => \Elementor\Controls_Manager::SWITCHER,
            'label_on' => esc_html__('Yes', 'qoxag'),
            'label_off' => esc_html__('No', 'qoxag'),
            'default' => 'no',
        ];

        $fields['show_read_time'] = [
            'label' => esc_html__('Show Reading Time', 'qoxag'),
            'type' => \Elementor\Controls_Manager::SWITCHER,
            'label_on' => esc_html__('Yes', 'qoxag'),
            'label_off' => esc_html__('No', 'qoxag'),
            'default' => 'no',
        ];

        $fields['show_review_rating'] = [
            'label' => esc_html__('Show Review Rating', 'qoxag'),
            'type' => \Elementor\Controls_Manager::SWITCHER,
            'label_on' => esc_html__('Yes', 'qoxag'),
            'label_off' => esc_html__('No', 'qoxag'),
            'default' => 'no',
        ];

        $fields['review_style'] = [
            'label' => esc_html__('Review Style', 'qoxag'),
            'type' => \Elementor\Controls_Manager::SELECT,
            'default' => 'style1',
            'options' => [
                'style1' => esc_html__('Style 1', 'qoxag'),
                'style2' => esc_html__('Style 2', 'qoxag'),
            ],
            'condition' => [
                'show_review_rating' => ['yes'],
            ],
        ];

        $fields['show_read_more_link'] = [
            'label' => esc_html__('Show Read More Link', 'qoxag'),
            'type' => \Elementor\Controls_Manager::SWITCHER,
            'label_on' => esc_html__('Yes', 'qoxag'),
            'label_off' => esc_html__('No', 'qoxag'),
            'default' => 'no',
        ];

        $fields['read_more_text'] = [
            'label' => esc_html__('Read More Text', 'qoxag'),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => esc_html__('Read Story', 'qoxag'),
            'condition' => [
                'show_read_more_link' => ['yes'],
            ],
        ];

        $fields['read_more_icon'] = [
            'label' => esc_html__('Left Arrow', 'qoxag'),
            'type' => \Elementor\Controls_Manager::ICONS,
            'condition' => [
                'slide_arrows' => 'yes'
            ],
            'default' => [
                'value' => 'xts-icon xts-chevron-right',
                'library' => 'solid',
            ],
            'condition' => [
                'show_read_more_link' => ['yes'],
            ],
        ];

        $fields['content_align'] = [
            'label' => esc_html__('Content Alignment', 'qoxag'),
            'type' => \Elementor\Controls_Manager::CHOOSE,
            'options' => [
                'left' => [
                    'title' => esc_html__('Left', 'qoxag'),
                    'icon' => 'fas fa-align-left',
                ],
                'center' => [
                    'title' => esc_html__('Center', 'qoxag'),
                    'icon' => 'fas fa-align-center',
                ],
                'right' => [
                    'title' => esc_html__('Right', 'qoxag'),
                    'icon' => 'fas fa-align-right',
                ],
            ],
            'default' => '',
            'responsive' => true,
            'selectors' => [
                '{{WRAPPER}} .post-content' => 'text-align: {{VALUE}};'
            ],
        ];

        return $fields;
    }

    protected function get_default_options()
    {
        return [
            'popover' => false,
        ];
    }
}
