<?php
/**
 * Single view template.
 *
 * 🚫🚫🚫
 * DO NOT EDIT THIS FILE WHILE INSIDE THE PLUGIN! Changes You make will be lost when a new version
 * of the AMP plugin is released. You need to copy this file out of the plugin and put it into your
 * custom theme, for example. To learn about how to customize these Reader-mode AMP templates, please
 * see: https://amp-wp.org/documentation/how-the-plugin-works/classic-templates/
 * 🚫🚫🚫
 *
 * @package AMP
 */

/**
 * Context.
 *
 * @var AMP_Post_Template $this
 */

$blog_author_show = qoxag_option( 'blog_author_show', 'yes');
$blog_date_show = qoxag_option( 'blog_date_show', 'yes');
$blog_view_count_show = qoxag_option( 'blog_view_count_show', 'no');
$blog_reading_time_show = qoxag_option( 'blog_reading_time_show', 'no');
$blog_details_Comments_show = qoxag_option('blog_details_Comments_show', 'no');
$this->load_parts( [ 'html-start' ] );
?>

<?php $this->load_parts( [ 'header' ] ); ?>

<article class="amp-wp-article">
	<?php qoxag_get_breadcrumbs(); ?>
	<header class="single-post-header amp-wp-article-header">
		<?php qoxag_post_categories(get_the_ID(), 100, 'contentpart', 'left-background'); ?>
		<h1 class="amp-wp-title"><?php echo esc_html($this->get( 'post_title' )); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?></h1>
		<?php
		/**
		 * Filters the template parts loaded in the header area of the AMP legacy post template.
		 *
		 * @since 0.4
		 * @param string[] Templates to load.
		 */
		qoxag_post_meta_info(get_the_ID(), $blog_author_show, $blog_date_show, $blog_view_count_show, $blog_reading_time_show, $show_review_rating = 'no', $blog_details_Comments_show); 
		?>
	</header>

	<?php $this->load_parts( [ 'featured-image' ] ); ?>

	<div class="amp-wp-article-content">
		<?php echo qoxag_kses($this->get('post_amp_content')); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
	</div>

	<footer class="amp-wp-article-footer">
		<?php
		/**
		 * Filters the template parts to load in the footer area of the AMP legacy post template.
		 *
		 * @since 0.4
		 * @param string[] Templates to load.
		 */
		$this->load_parts( apply_filters( 'amp_post_article_footer_meta', [ 'meta-taxonomy', 'meta-comments-link' ] ) );

		comments_template();
		
		?>
	</footer>
</article>

<?php $this->load_parts( [ 'footer' ] ); ?>

<?php
$this->load_parts( [ 'html-end' ] );
