<?php
$qoxag_main_logo_url = "";
?>


<header class="primary-menu-wraper">
	<div class="container">
      <div class="header-row">
         <div class="site-branding">
            <?php
               $qoxag_main_logo_url = qoxag_option('main_logo');
               if(!empty($qoxag_main_logo_url)){
                   $qoxag_main_logo_url = wp_get_attachment_image_src($qoxag_main_logo_url,'full');
                   if($qoxag_main_logo_url['0'] != ''){
                       $qoxag_main_logo_url = $qoxag_main_logo_url['0'];       
                   }
               }
               $qoxag_main_logo_url = $qoxag_main_logo_url;
            ?>

            <a class="logo" href="<?php echo esc_url(home_url('/')); ?>">
               <?php if($qoxag_main_logo_url !=''): ?>
                  <img width="286" height="115" class="img-fluid" src="<?php echo esc_url($qoxag_main_logo_url); ?>" alt="<?php echo get_bloginfo('name') ?>">
               <?php else: ?>
                  <img width="286" height="115" class="img-fluid" src="<?php echo esc_url( qoxag_src( 'main_logo', QOXAG_IMG . '/logo.png') ) ?>" srcset="<?php echo esc_url( qoxag_src( 'custom-logo', QOXAG_IMG . '/logo.png') ) ?> 1x, <?php echo esc_url( qoxag_src( 'custom-logo', QOXAG_IMG . '/logo.png') ); ?> 2x" alt="<?php bloginfo('name'); ?>"  >
               <?php endif; ?>
            </a>
            <div class="menu-button-container">
               <button class="nav-toggle-button nav-menu-toggle" aria-controls="primary-navigation" aria-expanded="false">
                 <i class="xts-icon xts-bars"></i>
               </button><!-- #primary-mobile-menu -->
            </div><!-- .menu-button-container -->
         </div>
         
         <?php
         //header ads
         $header_ads = qoxag_option('header_ads');
         if($header_ads != ''){ ?> 
            <div class="header-advertisment">
               <?php echo do_shortcode($header_ads); ?>
            </div>
         <?php } ?>

         <?php if ( has_nav_menu( 'primary' ) ) { ?>
         <div id="primary-navigation" class="primary-navigation-wraper" role="navigation" aria-label="<?php esc_attr_e( 'Primary menu', 'qoxag' ); ?>">
            <div class="primary-navigation">
               <div class="mobile-branding">
                  <div class="site-branding">
                     <a class="logo" href="<?php echo esc_url(home_url('/')); ?>">
                        <img width="286" height="115" class="img-fluid" src="<?php echo esc_url( qoxag_src( 'custom-logo', QOXAG_IMG . '/logo.png') ) ?>" srcset="<?php echo esc_url( qoxag_src( 'custom-logo', QOXAG_IMG . '/logo.png') ) ?> 1x, <?php echo esc_url( qoxag_src( 'custom-logo', QOXAG_IMG . '/logo.png') ); ?> 2x" alt="<?php bloginfo('name'); ?>"  >
                     </a>
                     <div class="menu-button-container">
                        <button class="nav-toggle-button nav-menu-toggle toggle" aria-controls="primary-navigation" aria-expanded="false">
                          <?php echo esc_html__(' X','qoxag'); ?>
                        </button><!-- #primary-mobile-menu -->
                     </div><!-- .menu-button-container -->
                  </div>
               </div>
               
               <?php
               wp_nav_menu(
                  array(
                     'theme_location'  => 'primary',
                     'menu_class'      => 'menu-wrapper',
                     'container_class' => 'primary-menu-container',
                     'items_wrap'      => '<ul id="primary-menu-list" class="%2$s">%3$s</ul>',
                     'fallback_cb'     => false,
                  )
               );
               ?>
            </div>
            <div class="nav-menu-backdrop" aria-controls="primary-navigation"></div>
         </div><!-- #site-navigation -->
         <?php }; ?>
      </div>
   </div>
</header>

