<?php

use Devmonsta\Libs\Posts;

class Page extends Posts
{

    public function register_controls()
    {
        $this->add_box([
            'id' => 'page_post_meta',
            'post_type' => 'page',
            'title' => esc_html__('Page Settings', 'qoxag'),
        ]);
        /**
         * control for text input
         */

        $this->add_control( [
            'box_id' => 'page_post_meta',
            'type'   => 'switcher',
            'name'   => 'page_meta_show_banner',
            'value'  => 'yes',
            'label'  => esc_html__('Show banner?', 'qoxag'),
            'desc'   => esc_html__('Show or hide the banner', 'qoxag'),
            'left-choice'  => [
                'no' => esc_html__('No', 'qoxag'),
            ],
            'right-choice' => [
                'yes' => esc_html__('Yes', 'qoxag'),
            ],
        ]);

        $this->add_control( [
            'box_id' => 'page_post_meta',
            'type'   => 'switcher',
            'name'   => 'page_meta_show_breadcumb',
            'value'  => 'yes',
            'label'  => esc_html__('Show Breadcumb?', 'qoxag'),
            'desc'   => esc_html__('Show or hide the breadcumb', 'qoxag'),
            'left-choice'  => [
                'no' => esc_html__('No', 'qoxag'),
            ],
            'right-choice' => [
                'yes' => esc_html__('Yes', 'qoxag'),
            ],
        ]);

        $this->add_control([
            'box_id' => 'page_post_meta',
            'type'   => 'text',
            'name'   => 'header_title',
            'desc'   => esc_html__('Add your Page hero title', 'qoxag'),
            'label'  => esc_html__('Banner Title', 'qoxag'),
        ]);

        $this->add_control([
            'box_id' => 'page_post_meta',
            'type'   => 'upload',
            'name'   => 'header_image',
            'desc'   => esc_html__('Upload a page header image', 'qoxag'),
            'label'  => esc_html__('Banner image', 'qoxag'),
        ]);

        /*$this->add_control( [
            'box_id' => 'page_post_meta',
            'type'   => 'switcher',
            'name'   => 'page_body_box_layout',
            'value'  => 'no',
            'label'  => esc_html__('Box Layout?', 'qoxag'),
            'desc'   => esc_html__('Enable box layout', 'qoxag'),
            'left-choice'  => [
                'no' => esc_html__('No', 'qoxag'),
            ],
            'right-choice' => [
                'yes' => esc_html__('Yes', 'qoxag'),
            ],
        ]);*/
    }
}
