<?php

function qoxag_import_files() {
	$demo_content_installer	 = QOXAG_REMOTE_CONTENT;
	return array(
	  array(
		'import_file_name'           => 'Default Home (1-6)',
		'categories'                 => array( 'Multipage' ),
		'import_file_url'            => $demo_content_installer . '/default/default.xml',
		'import_customizer_file_url' => $demo_content_installer . '/default/customizer.dat',
		'import_widget_file_url'     => $demo_content_installer . '/default/widgets.wie',
		'import_preview_image_url'   => $demo_content_installer . '/default/screenshot.png',
		'preview_url'                => QOXAG_LIVE_URL,
	  ),
	  array(
		'import_file_name'           => 'RTL Demo',
		'categories'                 => array( 'Multipage' ),
		'import_file_url'            => $demo_content_installer . '/rtl/main.xml',
		'import_customizer_file_url' => $demo_content_installer . '/rtl/customizer.dat',
		'import_widget_file_url'     => $demo_content_installer . '/rtl/widgets.wie',
		'import_preview_image_url'   => $demo_content_installer . '/rtl/screenshot.png',
		'preview_url'                => QOXAG_LIVE_URL . 'rtl'
	  ),
	  array(
		'import_file_name'           => 'Gadget Demo',
		'categories'                 => array( 'Multipage' ),
		'import_file_url'            => $demo_content_installer . '/gadget/main.xml',
		'import_customizer_file_url' => $demo_content_installer . '/gadget/customizer.dat',
		'import_widget_file_url'     => $demo_content_installer . '/gadget/widgets.wie',
		'import_preview_image_url'   => $demo_content_installer . '/gadget/screenshot.png',
		'preview_url'                => QOXAG_LIVE_URL . 'gadget'
	  ),
	  array(
		'import_file_name'           => 'Food Review',
		'categories'                 => array( 'Multipage' ),
		'import_file_url'            => $demo_content_installer . '/food-review/main.xml',
		'import_customizer_file_url' => $demo_content_installer . '/food-review/customizer.dat',
		'import_widget_file_url'     => $demo_content_installer . '/food-review/widgets.wie',
		'import_preview_image_url'   => $demo_content_installer . '/food-review/screenshot.png',
		'preview_url'                => QOXAG_LIVE_URL . 'food-review'
	  ),
	  array(
		'import_file_name'           => 'Newspaper Demo',
		'categories'                 => array( 'Multipage' ),
		'import_file_url'            => $demo_content_installer . '/newspaper/main.xml',
		'import_customizer_file_url' => $demo_content_installer . '/newspaper/customizer.dat',
		'import_widget_file_url'     => $demo_content_installer . '/newspaper/widgets.wie',
		'import_preview_image_url'   => $demo_content_installer . '/newspaper/screenshot.png',
		'preview_url'                => QOXAG_LIVE_URL . 'newspaper'
	  ),
	  array(
		'import_file_name'           => 'Personal Blog Home (1-2)',
		'categories'                 => array( 'Multipage' ),
		'import_file_url'            => $demo_content_installer . '/personal/main.xml',
		'import_customizer_file_url' => $demo_content_installer . '/personal/customizer.dat',
		'import_widget_file_url'     => $demo_content_installer . '/personal/widgets.wie',
		'import_preview_image_url'   => $demo_content_installer . '/personal/screenshot.png',
		'preview_url'                => QOXAG_LIVE_URL . 'personal-blog'
	  ),
	  array(
		'import_file_name'           => 'Gutenberg Demo',
		'categories'                 => array( 'Multipage' ),
		'import_file_url'            => $demo_content_installer . '/gutenberg/main.xml',
		'import_customizer_file_url' => $demo_content_installer . '/gutenberg/customizer.dat',
		'import_widget_file_url'     => $demo_content_installer . '/gutenberg/widgets.wie',
		'import_preview_image_url'   => $demo_content_installer . '/gutenberg/screenshot.png',
		'preview_url'                => QOXAG_LIVE_URL . 'gutenberg'
	  ),
	  array(
		'import_file_name'           => 'WooCommerce Demo',
		'categories'                 => array( 'Multipage' ),
		'import_file_url'            => $demo_content_installer . '/woocommerce/main.xml',
		'import_customizer_file_url' => $demo_content_installer . '/woocommerce/customizer.dat',
		'import_widget_file_url'     => $demo_content_installer . '/woocommerce/widgets.wie',
		'import_preview_image_url'   => $demo_content_installer . '/woocommerce/screenshot.png',
		'preview_url'                => QOXAG_LIVE_URL . 'woo-commerce'
	  ),
	  array(
		'import_file_name'           => 'Travel Demo',
		'categories'                 => array( 'Multipage' ),
		'import_file_url'            => $demo_content_installer . '/travel/main.xml',
		'import_customizer_file_url' => $demo_content_installer . '/travel/customizer.dat',
		'import_widget_file_url'     => $demo_content_installer . '/travel/widgets.wie',
		'import_preview_image_url'   => $demo_content_installer . '/travel/screenshot.png',
		'preview_url'                => QOXAG_LIVE_URL . 'travel'
	  ),
	  array(
		'import_file_name'           => 'Health Magazine',
		'categories'                 => array( 'Multipage' ),
		'import_file_url'            => $demo_content_installer . '/health-magazine/main.xml',
		'import_customizer_file_url' => $demo_content_installer . '/health-magazine/customizer.dat',
		'import_widget_file_url'     => $demo_content_installer . '/health-magazine/widgets.wie',
		'import_preview_image_url'   => $demo_content_installer . '/health-magazine/screenshot.png',
		'preview_url'                => QOXAG_LIVE_URL . 'health-magazine'
	  ),
	  array(
		'import_file_name'           => 'Magazine',
		'categories'                 => array( 'Multipage' ),
		'import_file_url'            => $demo_content_installer . '/magazine/main.xml',
		'import_customizer_file_url' => $demo_content_installer . '/magazine/customizer.dat',
		'import_widget_file_url'     => $demo_content_installer . '/magazine/widgets.wie',
		'import_preview_image_url'   => $demo_content_installer . '/magazine/screenshot.png',
		'preview_url'                => QOXAG_LIVE_URL . 'magazine'
	  )
	);
}
add_filter( 'pt-ocdi/import_files', 'qoxag_import_files' );

function qoxag_after_import( $selected_import ) {

	$slider_array = array(
		"Default Home (1-6)" => [
			"slug" => "Home",
		],
		"RTL Demo" => [
			"slug" => "Home",
		],
		"Gadget Demo" => [
			"slug" => "Home",
		],
		"Food Review" => [
			"slug" => "Home",
		],
		"Personal Blog" => [
			"slug" => "Home",
		],
		"Guttenburg Demo" => [
			"slug" => "Home",
		],
		"WooCommerce Demo" => [
			"slug" => "Home",
		],
		"Travel Demo" => [
			"slug" => "Home",
		],
		"Health Magazine" => [
			"slug" => "Home",
		],
		"Magazine" => [
			"slug" => "Home",
		],
	);
	if( is_array( $slider_array ) ){
		foreach ($slider_array as $i => $values) {
			if ( $i === $selected_import['import_file_name'] ) {
				foreach ($values as $key => $value) {
					//Set Front page
					$page = get_page_by_title( $values['slug'] );
					if ( isset( $page->ID ) ) {
						update_option( 'page_on_front', $page->ID );
						update_option( 'show_on_front', 'page' );
					}
				}
			}
		}
	}
}
add_action( 'pt-ocdi/after_import', 'qoxag_after_import' );