<?php if (!defined('ABSPATH')) die('Direct access forbidden.');
/**
 * enqueue all theme scripts and styles
 */


// stylesheets
// ----------------------------------------------------------------------------------------
if ( !is_admin() ) {
	// wp_enqueue_style() $handle, $src, $deps, $version
	
	if (! defined( 'DEVM' ) ) {
		wp_enqueue_style( 'fonts', 'https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800;900&family=Zilla Slab:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&Roboto:ital,wght@0,100;0,300;0,400;0,500;0,700;0,900;1,100;1,300;1,400;1,500;1,700;1,900&display=swap', [], null );
	}

	wp_enqueue_style( 'qoxag-icon', QOXAG_CSS . '/public/icon.css', null, QOXAG_VERSION );
	wp_enqueue_style( 'qoxag-print', QOXAG_CSS . '/public/print.css', null, QOXAG_VERSION );
	wp_enqueue_style( 'qoxag-style', QOXAG_CSS . '/public/style.css', null, QOXAG_VERSION );

	if(class_exists('woocommerce')){
		wp_enqueue_style( 'qoxag-woocommerce', QOXAG_CSS . '/public/woocommerce.css', null, QOXAG_VERSION );
	}
	
	if( qoxag_option('style_theme_setting') == 'yes' || qoxag_option('style_darklight_mode') == 'yes' ){
		wp_enqueue_style( 'qoxag-dark', QOXAG_CSS . '/public/dark.css', null, QOXAG_VERSION );
	}	

}

// javascripts
// ----------------------------------------------------------------------------------------
if ( !is_admin() ) {
	wp_enqueue_script( 'theia-sticky-sidebar', QOXAG_JS  . '/public/theia-sticky-sidebar.js',  ['jquery'], QOXAG_VERSION, true );

	wp_enqueue_script( 'fontfaceobserver',  QOXAG_JS . '/public/fontfaceobserver.js', array( ), true, true );

	// Load WordPress Comment js
	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}
