<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit;

class Qoxag_Products_Tab extends Widget_Base {


    public $base;

    public function get_name() {
        return 'products-tab';
    }

    public function get_title() {
        return esc_html__( 'Qoxag Product Tab', 'qoxag' );
    }

    public function get_icon() { 
        return 'fas fa-layer-group';
    }

    public function get_categories() {
        return [ 'qoxag-elements' ];
    }

   protected function _register_controls() {
      $this->start_controls_section(
         'content',
         [
            'label' => esc_html__( 'Products', 'qoxag' )
         ]
      );

      $this->add_control(
        'item_show_by',
        [
              'label'   => esc_html__( 'Select Items Type', 'qoxag' ),
              'type'    => Controls_Manager::SELECT,
              'options' => [
                 'product'   => esc_html__( 'Products', 'qoxag' ),
              ],
              'default' => 'product',
        ]
     );

     $this->add_control(
      'item_show_style',
      [
            'label'   => esc_html__( 'Select Items Style', 'qoxag' ),
            'type'    => Controls_Manager::SELECT,
            'options' => [
              'content-tab'   => esc_html__( 'Tabs Layout', 'qoxag' ),
               'content-toltip-tabs'   => esc_html__( 'Toltip Tabs', 'qoxag' ),               
            ],
            'default' => 'content-tab',
      ]
      );
  
      $this->add_control(
         'order',
         [
               'label'   => esc_html__( 'Order By', 'qoxag' ),
               'type'    => Controls_Manager::SELECT,
               'options' => [
                  'popular'  => esc_html__( 'Popular', 'qoxag' ),
                  'latest'   => esc_html__( 'Latest', 'qoxag' ),
               ],
               'default' => 'latest',
               'condition' => array(
                'item_show_by' => [ 'lp_course']
             )
         ]
      );
    
      $this->add_control(
         'limit',
         [
            'label'   => esc_html__( 'Limit Number Product', 'qoxag' ),
            'type'    => Controls_Manager::NUMBER,
            'default' => 8,
            'min'     => 1,
            'step'    => 1,
         ]
      );

   $this->add_control(
      'featured',
      [
         'label'        => esc_html__( 'Display Featured Courses?', 'qoxag' ),
         'type'         => Controls_Manager::SWITCHER,
         'label_on'     => esc_html__( 'Yes', 'qoxag' ),
         'label_off'    => esc_html__( 'No', 'qoxag' ),
         'return_value' => 'yes',
         'default'      => '',
         'condition' => array(
          'item_show_by' => [ 'lp_course']
       )
      ]
   );

   $this->end_controls_section();

      $this->start_controls_section(
         'tab-options',
         [
            'label'     => esc_html__( 'Tab Options', 'qoxag' ),
         ]
      );

      $this->add_control(
         'limit_tab',
         [
            'label'   => esc_html__( 'Limit of Tabs', 'qoxag' ),
            'type'    => Controls_Manager::NUMBER,
            'default' => 4,
            'min'     => 1,
            'step'    => 1
         ]
      );
  
      $this->add_control(
         'cat_id_tab_course',
         [
            'label'       => esc_html__( 'Select Category Tabs', 'qoxag' ),
            'label_block' => true,
            'type'        => Controls_Manager::SELECT2,
            'options'     => qoxag_all_taxonomy('course_category'),
            'multiple'    => true,
            'default'     => '',
            'condition' => array(
              'item_show_by' => [ 'lp_course']
           )
         ]
      );

      $this->add_control(
        'cat_id_tab_product',
        [
           'label'       => esc_html__( 'Select Category Tabs', 'qoxag' ),
           'label_block' => true,
           'type'        => Controls_Manager::SELECT2,
           'options'     => qoxag_all_taxonomy('product_cat'),
           'multiple'    => true,
           'default'     => '',
           'condition' => array(
            'item_show_by' => [ 'product']
         )
        ]
     );
  
      $this->end_controls_section();

      $this->start_controls_section(
        'tab_menu_style', [
            'label'	 => esc_html__( 'Tab Menu', 'qoxag' ),
            'tab'	 => Controls_Manager::TAB_STYLE,
         ]
      );

      $this->add_control(
        'tab_menu_bg', [
            'label'		 => esc_html__( 'Tab menu BG', 'qoxag' ),
            'type'		 => Controls_Manager::COLOR,
            'selectors'	 => [
               '{{WRAPPER}} .tab-course-category ul' => 'background: {{VALUE}};',
            ],
         ]
      );

      $this->add_control(
         'tab_menu_color', [
            'label'		 => esc_html__( 'color', 'qoxag' ),
            'type'		 => Controls_Manager::COLOR,
            'selectors'	 => [
               '{{WRAPPER}} .product-tabs .tab-product-category .nav-tabs li.nav-item .product-tab-a' => 'color: {{VALUE}};',
            ],
         ]
      );

      $this->add_control(
        'tab_menu_active_color', [
            'label'		 => esc_html__( 'Tab menu active color', 'qoxag' ),
            'type'		 => Controls_Manager::COLOR,
            'selectors'	 => [
               '{{WRAPPER}} .product-tabs .tab-product-category .nav-tabs li.nav-item .product-tab-a.active' => 'color: {{VALUE}};',
               '{{WRAPPER}} .product-tabs .tab-product-category .nav-tabs li.nav-item .product-tab-a:hover' => 'color: {{VALUE}};',
               '{{WRAPPER}} .product-tabs .tab-product-category .nav-tabs li.nav-item .product-tab-a:before' => 'background: {{VALUE}};',
            ],
         ]
      );

      $this->add_control(
        'tab_menu_active_bg', [
            'label'		 => esc_html__( 'Tab menu active BG', 'qoxag' ),
            'type'		 => Controls_Manager::COLOR,
            'selectors'	 => [
               '{{WRAPPER}} .tab-course-category ul li .active, {{WRAPPER}} .tab-course-category ul li .course-tab-a:hover' => 'background: {{VALUE}};',
            ],
         ]
      );
  
         
      $this->add_group_control(
        Group_Control_Typography::get_type(), [
            'name'		 => 'tab_menu_typography',
            'selector'	 => '{{WRAPPER}} .tab-course-category ul li .course-tab-a',
         ]
      );
        
      $this->add_responsive_control(
          'tab_menu_margin',
          [
            'label' => esc_html__( 'Tab Menu margin', 'qoxag' ),
            'type' => Controls_Manager::DIMENSIONS,
            'allowed_dimensions' => [ 'bottom' ],
            'size_units' => [ 'px', '%', 'em' ],
            'selectors' => [
              '{{WRAPPER}} ..product-tabs .tab-product-category .nav-tabs li.nav-item' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
          ]
        );

        $this->add_responsive_control(
          'tab_menu_ul_padding',
          [
            'label' => esc_html__( 'Tab Menu padding', 'qoxag' ),
            'type' => Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%', 'em' ],
            'selectors' => [
              '{{WRAPPER}} .product-tabs .tab-product-category .nav-tabs' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
          ]
        );

        $this->add_responsive_control(
          'tab_menu_padding',
          [
            'label' => esc_html__( 'Tab Menu Item padding', 'qoxag' ),
            'type' => Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%', 'em' ],
            'selectors' => [
              '{{WRAPPER}} .product-tabs .tab-product-category .nav-tabs li.nav-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
          ]
        );
        $this->add_responsive_control(
          'tab_menu_border_radius',
          [
            'label' => esc_html__( 'Border Radius', 'qoxag' ),
            'type' => Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%', 'em' ],
            'selectors' => [
              '{{WRAPPER}} .product-tabs .tab-product-category .nav-tabs ' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
          ]
        );

 
      $this->end_controls_section();

      $this->start_controls_section(
        'title_style', [
          'label'	 => esc_html__( 'Title', 'qoxag' ),
          'tab'	 => Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'title_color', [
          'label'		 => esc_html__( 'Title color', 'qoxag' ),
          'type'		 => Controls_Manager::COLOR,
          'selectors'	 => [
            '{{WRAPPER}} .product-tabs .tab-content .content-area .ts-course-el-title a' => 'color: {{VALUE}};',
          ],
        ]
        );

      $this->add_control(
        'title_hover_color', [
          'label'		 => esc_html__( 'Title hover color', 'qoxag' ),
          'type'		 => Controls_Manager::COLOR,
          'selectors'	 => [
            '{{WRAPPER}} .product-tabs .tab-content .content-area .ts-course-el-title:hover a' => 'color: {{VALUE}};',
          ],
        ]
      );
  
      $this->add_group_control(
         Group_Control_Typography::get_type(), [
         'name'		 => 'title_typography',
         'selector'	 => '{{WRAPPER}} .product-tabs .tab-content .content-area .ts-course-el-title a',
         ]
      );
        
        $this->add_responsive_control(
          'title_margin',
          [
            'label' => esc_html__( 'Tilte margin', 'qoxag' ),
            'type' => Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%', 'em' ],
            'selectors' => [
              '{{WRAPPER}} .product-tabs .tab-content .content-area .ts-course-el-title a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
          ]
        );
      
      $this->end_controls_section();

      $this->start_controls_section(
        'category_meta_style', [
          'label'	 => esc_html__( 'Meta Style', 'qoxag' ),
          'tab'	 => Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'meta_color', [
          'label'		 => esc_html__( 'color', 'qoxag' ),
          'type'		 => Controls_Manager::COLOR,
          'selectors'	 => [
            '{{WRAPPER}} .single-course .course-category a' => 'color: {{VALUE}};',
            '{{WRAPPER}} .single-course .course-enrole-list li' => 'color: {{VALUE}};',
          ],
        ]
        );

      $this->add_control(
        'meta_hover_color', [
          'label'		 => esc_html__( 'Meta  color', 'qoxag' ),
          'type'		 => Controls_Manager::COLOR,
          'selectors'	 => [
            '{{WRAPPER}} .single-course:hover .course-category a' => 'color: {{VALUE}};',
            '{{WRAPPER}} .single-course:hover .course-enrole-list li' => 'color: {{VALUE}};',
          ],
        ]
        );
  
         
        $this->add_group_control(
        Group_Control_Typography::get_type(), [
        'name'		 => 'meta_title_typography',
        'selector'	 => '{{WRAPPER}} .single-course .course-category a, {{WRAPPER}} .single-course .course-enrole-list li',
        ]
        );
      $this->end_controls_section();
     
      $this->start_controls_section(
        'instructor_style', [
          'label'	 => esc_html__( 'Instructor Style', 'qoxag' ),
          'tab'	 => Controls_Manager::TAB_STYLE,
        ]
      );

      $this->add_control(
        'instructor_hover_color', [
          'label'		 => esc_html__( 'Instructor color', 'qoxag' ),
          'type'		 => Controls_Manager::COLOR,
          'selectors'	 => [
            '{{WRAPPER}} .single-course .instructor a' => 'color: {{VALUE}};',
          ],
        ]
        );
  
         
        $this->add_group_control(
        Group_Control_Typography::get_type(), [
        'name'		 => 'instructor_title_typography',
        'selector'	 => '{{WRAPPER}} .single-course .instructor a',
        ]
        );
      $this->end_controls_section();

      $this->start_controls_section(
        'price_style', [
          'label'	 => esc_html__( 'Price Style', 'qoxag' ),
          'tab'	 => Controls_Manager::TAB_STYLE,
        ]
      );

      $this->add_control(
        'price_bg_color', [
          'label'		 => esc_html__( 'Background color', 'qoxag' ),
          'type'		 => Controls_Manager::COLOR,
          'selectors'	 => [
            '{{WRAPPER}} .single-course .course-thumb .course-price-item .course-price' => 'background-color: {{VALUE}};',
          ],
        ]
      );
     
      $this->add_control(
        'price_color', [
          'label'		 => esc_html__( 'Color', 'qoxag' ),
          'type'		 => Controls_Manager::COLOR,
          'selectors'	 => [
            '{{WRAPPER}} .single-course .course-thumb .course-price-item .course-price' => 'color: {{VALUE}};',
          ],
        ]
      );
  
         
        $this->add_group_control(
        Group_Control_Typography::get_type(), [
        'name'		 => 'price_title_typography',
        'selector'	 => '{{WRAPPER}} .single-course .course-thumb .course-price-item .course-price',
        ]
        );
      $this->end_controls_section();

      $this->start_controls_section(
        'advance_style', [
          'label'	 => esc_html__( 'Advance Style', 'qoxag' ),
          'tab'	 => Controls_Manager::TAB_STYLE,
        ]
      );

      $this->add_control(
        'box_bg_color', [
          'label'		 => esc_html__( 'Box background color', 'qoxag' ),
          'type'		 => Controls_Manager::COLOR,
          'selectors'	 => [
            '{{WRAPPER}} .single-course' => 'background-color: {{VALUE}};',
          ],
        ]
      );

      $this->add_control(
        'box_bg_color_hover', [
          'label'		 => esc_html__( 'Box background hover color', 'qoxag' ),
          'type'		 => Controls_Manager::COLOR,
          'selectors'	 => [
            '{{WRAPPER}} .single-course:hover' => 'background-color: {{VALUE}};',
          ],
        ]
      );
      
      $this->add_control(
        'box_shape_hover_color1', [
          'label'		 => esc_html__( 'Box hover shape 1 color', 'qoxag' ),
          'type'		 => Controls_Manager::COLOR,
          'selectors'	 => [
            '{{WRAPPER}} .single-course:hover .course-shap path:first-of-type' => 'fill: {{VALUE}};',
          ],
        ]
      );

      $this->add_control(
        'box_shape_color2', [
          'label'		 => esc_html__( 'Box  shape 2 color', 'qoxag' ),
          'type'		 => Controls_Manager::COLOR,
          'selectors'	 => [
            '{{WRAPPER}} .single-course .course-shap path:last-of-type' => 'fill: {{VALUE}};',
          ],
        ]
        );
      $this->add_control(
        'box_shape_hover_color2', [
          'label'		 => esc_html__( 'Box hover shape 2 color', 'qoxag' ),
          'type'		 => Controls_Manager::COLOR,
          'selectors'	 => [
            '{{WRAPPER}} .single-course:hover .course-shap path:last-of-type' => 'fill: {{VALUE}};',
          ],
        ]
        );
        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
              'name' => 'course_price_shadow',
              'label' => esc_html__( 'Course price Shadow', 'qoxag' ),
              'selector' => '{{WRAPPER}} .single-course .course-footer .course-price-item .course-price',
            ]
        );

        $this->add_responsive_control(
         'content_margin',
         [
           'label' => esc_html__( 'Box margin', 'qoxag' ),
           'type' => Controls_Manager::DIMENSIONS,
           'size_units' => [ 'px', '%', 'em' ],
           'allowed_dimensions' => [ 'bottom' ],
           'selectors' => [
             '{{WRAPPER}} .single-course' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
           ],
         ]
         );
        $this->add_responsive_control(
         'content_padding',
         [
           'label' => esc_html__( 'Box Padding', 'qoxag' ),
           'type' => Controls_Manager::DIMENSIONS,
           'size_units' => [ 'px', '%', 'em' ],
           'selectors' => [
             '{{WRAPPER}} .single-course' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
           ],
         ]
         );

        $this->add_responsive_control(
          'box_border_radius',
          [
            'label' => esc_html__( 'Box border radius', 'qoxag' ),
            'type' => Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%', 'em' ],
            'selectors' => [
              '{{WRAPPER}} .single-course' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
              '{{WRAPPER}} .course-single-wrap .course-thumbnail img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
              '{{WRAPPER}} .course-single-wrap .course-thumbnail' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
          ]
          );
          $this->start_controls_tabs( 'boxed_border_styled' );

        $this->start_controls_tab(
             'boxed_border_style_normal',
             [
                'label' =>esc_html__( 'Normal', 'qoxag' ),
             ]
        );
   
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'border_noromal',
                'label' => esc_html__( 'Box Border', 'qoxag' ),
                'selector' => '{{WRAPPER}} .single-course',
            ]
        );
        $this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'feature_box_shadow',
				'label' => esc_html__( 'Box Shadow', 'qoxag' ),
				'selector' => '{{WRAPPER}} .single-course',
			]
		);
         
        $this->end_controls_tab();

        $this->start_controls_tab(
        'boxed_border_style_hover',
            [
                'label' =>esc_html__( 'Hover', 'qoxag' ),
            ]
        );
 
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'hover_border',
                'label' => esc_html__( 'Box Border', 'qoxag' ),
                'selector' => '{{WRAPPER}} .single-course:hover',
            ]
        );
        $this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'feature_box_hov_shadow',
                'label' => esc_html__( 'Box hover Shadow', 'qoxag' ),
				'selector' => '{{WRAPPER}} .single-course:hover',
			]
		);

        $this->end_controls_tab();
        $this->end_controls_tabs();
    
      $this->end_controls_section();
     
    }    
    

      protected function render()
      {
        $settings   = $this->get_settings();

      
      
        $item_show_by = $settings['item_show_by'];
        $limit = $settings['limit'];
        if($item_show_by == 'product'){
          $cat_id_tab = $settings['cat_id_tab_product'];
          $taxonomy = 'product_cat';
          $featured = 'no';
          $sort = '';
        }
  
          $tpl = get_widget_template($this->get_name());
          include $tpl;
      }
  
      protected function content_template()
      {
      }
      
    

}