<?php

namespace Elementor;

use Qoxag\Core\Elementor\Controls\Qoxag_Layout;
use Qoxag\Core\Elementor\Controls\Qoxag_Post_Query;

if (!defined('ABSPATH')) exit;


class Qoxag_Post_Videotab extends Widget_Base
{
    use \Qoxag\Core\Elementor\Traits\Grid_Controls;

    public $base;

    public function get_name()
    {
        return 'post-videotab';
    }

    public function get_title()
    {

        return esc_html__('Qoxag Post Video Tab', 'qoxag');

    }

    public function get_icon()
    {
        return 'eicon-youtube';
    }

    public function get_categories()
    {
        return ['qoxag-elements'];
    }

    protected function register_controls()
    {

        /*
         * Post Grid Settings
         */
        $this->start_controls_section(
            'postgrid_section',
            [
                'label' => esc_html__('Post Video Tab Settings', 'qoxag'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_group_control(
            Qoxag_Post_Query::get_type(),
            [
                'name' => 'query',
                'exclude' => ['posts_per_page_slider_note', 'slides_to_show', 'post_tabs', 'post_format']
            ]
        );

        $this->end_controls_section();

        /*
         * Layout Settings
         */

        $this->start_controls_section(
            'layout_section',
            [
                'label' => esc_html__('Layout', 'qoxag'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_group_control(
            Qoxag_Layout::get_type(),
            [
                'name' => 'layout',
                'fields_options' => [
                    'column_number' => [
                        'default' => '1',
                    ],
                    'layout_style' => [
                        'default' => 'thumb-left',
                    ],
                ],
            ]
        );

        /**
         * List Height
         */

        $this->add_responsive_control(
            'tab_list_height',
            [
                'label' => esc_html__('List Height', 'qoxag'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .video-post-tab .video-tab-list' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        /*
         * Featured Layout Settings
         */

        $this->start_controls_section(
            'featured_layout_section',
            [
                'label' => esc_html__('Featured Post', 'qoxag'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_group_control(
            Qoxag_Layout::get_type(),
            [
                'name' => 'featured',
                'exclude' => ['column_number', 'content_align', 'category_style'],
                'fields_options' => [
                    'show_category' => [
                        'default' => 'no',
                    ],
                ],
            ]
        );

        $this->add_control(
            'reverse_featured_column',
            [
                'label' => esc_html__('Reverse Featured Column', 'qoxag'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'qoxag'),
                'label_off' => esc_html__('No', 'qoxag'),
                'default' => 'no',
                'return_value' => 'yes',
                'selectors' => [
                    '{{WRAPPER}} .video-post-tab .first-block' => 'order: 1',
                ],
            ]
        );

        $this->end_controls_section();

        /*
         * Advanced Ordering Settings
         */
        $this->advance_ordering_controls();


        /*
         * Title Style
         */
        $this->title_style_controls();

        /*
         * Image Style
         */
        $this->image_style_controls();


        /*
         * Meta and Category Style
         */
        $this->meta_style_controls();

        /*
         * Content Style
         */
        $this->description_style_controls();

        /*
         * Feature Style
         */

        $this->start_controls_section(
            'section_featured_style', [
                'label' => esc_html__('Featured', 'qoxag'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'featured_post_title_typography',
                'label' => esc_html__('Title Typography', 'qoxag'),
                'scheme' => Core\Schemes\Typography::TYPOGRAPHY_1,
                'selector' => '{{WRAPPER}} .video-post-tab .tab-content .post-heading',
                'fields_options' => [
                    'typography' => [
                        'default' => 'custom',
                    ],
                    'font_weight' => [
                        'default' => '600',
                    ],
                    'font_size' => [
                        'default' => [
                            'size' => '18',
                            'unit' => 'px'
                        ],
                        'size_units' => ['px']
                    ],
                    'line_height' => [
                        'default' => [
                            'size' => '25',
                            'unit' => 'px'
                        ],
                        'size_units' => ['px']
                    ],
                ],
            ]
        );

        $this->add_responsive_control(
            'featured_thumbnail_image_aspect_ratio',
            [
                'label' => esc_html__('Image Aspect Ratio', 'qoxag'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'condition' => ['featured_show_thumbnail' => ['yes']],
                'size_units' => ['%'],
                'range' => [
                    '%' => [
                        'min' => 0.01,
                        'max' => 3.0,
                        'step' => 0.01,
                    ],
                ],
                'default' => [
                    'unit' => '%',
                    'size' => 0.5,
                ],
                'tablet_default' => [
                    'unit' => '%',
                    'size' => 0.3,
                ],
                'mobile_default' => [
                    'unit' => '%',
                    'size' => 0.5,
                ],
                'selectors' => [
                    '{{WRAPPER}} .tab-content .qoxag-grid-single .post-thumbnail' => 'padding-bottom: calc( {{size}} * 100% );',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Image_Size::get_type(),
            [
                'name' => 'featured_thumbnail_img_size',
                'condition' => ['featured_show_thumbnail' => ['yes']],
                'exclude' => [ 'custom' ],
                'include' => [],
                'default' => 'large',
            ]
        );

        $this->add_responsive_control(
            'featured_content_padding',
            [
                'label' => esc_html__('Content Padding', 'qoxag'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px'],
                'default' => [
                    'top' => '0',
                    'right' => '0',
                    'bottom' => '0',
                    'left' => '0',
                    'unit' => 'px',
                    'isLinked' => false,
                ],
                'selectors' => [
                    '{{WRAPPER}} .video-post-tab .tab-content .post-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        /*
         * List title Style
         */
        $this->start_controls_section(
            'list_title_style', [
                'label' => esc_html__('List Title Style', 'qoxag'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'list_title_color',
            [
                'label' => esc_html__('Color', 'qoxag'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#FFFFFF',
                'selectors' => [
                    '{{WRAPPER}} .video-post-tab .list-title h4' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            array(
                'name' => 'list_title_typography',
                'label' => esc_html__('Typography', 'qoxag'),
                'selector' => '{{WRAPPER}} .video-post-tab .list-title h4',
                'fields_options' => [
                    'typography' => [
                        'default' => 'custom',
                    ],
                    'font_weight' => [
                        'default' => '600',
                    ],
                    'font_size' => [
                        'default' => [
                            'size' => '13',
                            'unit' => 'px'
                        ],
                        'size_units' => ['px']
                    ],
                    'text_transform' => [
                        'default' => 'uppercase',
                    ],
                    'line_height' => [
                        'default' => [
                            'size' => '15',
                            'unit' => 'px'
                        ],
                        'size_units' => ['px']
                    ],
                ],
            )
        );

        $this->add_responsive_control(
            'list_title_margin',
            [
                'label' => esc_html__('Margin', 'qoxag'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px'],
                'default' => [
                    'top' => '2',
                    'right' => '10',
                    'bottom' => '2',
                    'left' => '10',
                    'unit' => 'px',
                    'isLinked' => false,
                ],
                'selectors' => [
                    '{{WRAPPER}} .video-post-tab .list-title h4' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        /*
         * Advanced style Style
         */
        $this->start_controls_section(
            'section_wrapper_style', [
                'label' => esc_html__('Wrapper Style', 'qoxag'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'content_width',
            [
                'label' => esc_html__('Content Width', 'qoxag'),
                'type' => Controls_Manager::SLIDER,
                'condition' => ['layout_layout_style' => ['thumb-left', 'thumb-right']],
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 12,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 2,
                ],
                'selectors' => [
                    '{{WRAPPER}} .video-tab-list .qoxag-grid-single.thumb-left .post-content' => 'flex-grow: {{SIZE}};',
                    '{{WRAPPER}} .video-tab-list .qoxag-grid-single.thumb-right .post-content' => 'flex-grow: {{SIZE}};',
                ],
            ]
        );

        $this->advanced_style_controls();

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();

        $tpl = get_widget_template($this->get_name());
        include $tpl;
    }

    protected function content_template()
    {
    }
}