<?php

namespace Elementor;
if (!defined('ABSPATH')) exit;

use \ElementsKit_Lite\Modules\Controls\Controls_Manager as ElementsKit_Controls_Manager;

class Qoxag_Dark_light extends Widget_Base
{

    public $base;

    public function get_name(){
        return 'dark-light';
    }

    public function get_title(){
        return esc_html__('Dark/Light Switcher', 'qoxag');
    }

    public function get_icon(){
        return 'fas fa-toggle-on';
    }

    public function get_categories(){
        return ['qoxag-elements'];
    }

    protected function register_controls() {

        $this->start_controls_section(
            'section_tab',
            [
                'label' => esc_html__('Title settings', 'qoxag'),
            ]
        );
        
        $this->add_control(
            'switcher_bg_color',
            [
                'label' => esc_html__('Switcher Color', 'qoxag'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .qoxag-darklight-widget .color_swicher .switch_container' => 'background: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();

        $tpl = get_widget_template($this->get_name());
        include $tpl;
    }

    protected function content_template()
    {
    }
}