<?php

namespace Elementor;

use Qoxag\Core\Elementor\Controls\Qoxag_Layout;
use \Qoxag\Core\Elementor\Controls\Qoxag_Post_Query;

if (!defined('ABSPATH')) exit;


class Qoxag_Audio_Slider extends Widget_Base
{
    use \Qoxag\Core\Elementor\Traits\Grid_Controls;
    use \Qoxag\Core\Elementor\Traits\Slider_Controls;

    public $base;

    public function get_name()
    {
        return 'audio-slider';
    }

    public function get_title()
    {

        return esc_html__('Qoxag Audio Slider', 'qoxag');

    }

    public function get_icon()
    {
        return 'eicon-post-slider';
    }

    public function get_categories()
    {
        return ['qoxag-elements'];
    }

    protected function register_controls()
    {

        /*
         * Post Grid Settings
         */
        $this->start_controls_section(
            'postgrid_section',
            [
                'label' => esc_html__('Post Slider Settings', 'qoxag'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_group_control(
            Qoxag_Post_Query::get_type(),
            [
                'name' => 'query',
                'exclude' => ['post_tabs', 'post_format'],
            ]
        );

        $this->end_controls_section();

        /*
         * Layout Settings
         */

        $this->start_controls_section(
            'layout_section',
            [
                'label' => esc_html__('Layout', 'qoxag'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_group_control(
            Qoxag_Layout::get_type(),
            [
                'name' => 'layout',
                'exclude' => ['column_number', 'layout_style'],
            ]
        );


        $this->end_controls_section();

        
        $this->start_controls_section(
            'featured_section',
            [
                'label' => esc_html__('Featured post', 'qoxag'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_group_control(
            Qoxag_Layout::get_type(),
            [
                'name' => 'featured'
            ]
        );

        $this->end_controls_section();

        /*
         * Slider Settings
         */
        $this->slider_controls();

        /*
         * Advanced Ordering Settings
         */

        $this->advance_ordering_controls();

        /*
         * Title Style
         */
        $this->title_style_controls();

        /*
         * Image Style
         */
        $this->image_style_controls();

        /*
         * Meta and Category Style
         */
        $this->meta_style_controls();

        /*
         * Content Style
         */
        $this->description_style_controls();

        /*
        * Slider featured area
        */
        $this->start_controls_section(
            'featured_slider_styles', [
                'label' => esc_html__('Featured Slide', 'qoxag'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                'condition' => [
                    'layout_layout_style' => ['featured-slider thumb-top'],
                ],
            ]
        );
        //title
        $this->add_control(
            'featured_title_heading',
            [
                'label' => esc_html__( 'Title', 'qoxag' ),
                'type' => \Elementor\Controls_Manager::HEADING,
            ]
        );

        $this->add_control(
            'featured_title_color',
            [
                'label' => esc_html__('Title Color', 'qoxag'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '(desktop) {{WRAPPER}} .swiper-slide:nth-child(3n+1) .qoxag-grid-single .post-heading a' => 'color: {{VALUE}};',
                    '(tablet) {{WRAPPER}} .swiper-slide:nth-child(2n+1) .qoxag-grid-single .post-heading a:hover' => 'background-image: linear-gradient(to bottom, {{VALUE}} 0%, {{VALUE}} 98%);',
                    '(mobile) {{WRAPPER}} .swiper-slide .qoxag-grid-single .post-heading' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'featured_title_typography',
                'label' => esc_html__('Title Typography', 'qoxag'),
                'scheme' => \Elementor\Core\Schemes\Typography::TYPOGRAPHY_1,
                'selector' => '
                    (desktop) {{WRAPPER}} .swiper-slide:nth-child(3n+1) .qoxag-grid-single .post-heading,
                    (tablet) {{WRAPPER}} .swiper-slide:nth-child(2n+1) .qoxag-grid-single .post-heading,
                    (mobile) {{WRAPPER}} .swiper-slide .qoxag-grid-single .post-heading',
                'fields_options' => [
                    'typography' => [
                        'default' => 'custom',
                    ],
                    'font_weight' => [
                        'default' => '700',
                    ],
                    'font_size' => [
                        'default' => [
                            'size' => '23',
                            'unit' => 'px'
                        ],
                        'size_units' => ['px']
                    ],
                    'line_height' => [
                        'default' => [
                            'size' => '30',
                            'unit' => 'px'
                        ],
                        'size_units' => ['px']
                    ],
                ],
            ]
        );

        //image
        $this->add_control(
            'featured_thumbnail_heading',
            [
                'label' => esc_html__( 'Featured Thumbnail', 'qoxag' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_responsive_control(
            'layout_featured_image_width',
            [
                'label' => esc_html__('Image Width', 'qoxag'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'condition' => ['layout_show_thumbnail' => ['yes']],
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 500,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 255
                ],
                'tablet_default' => [
                    'unit' => 'px',
                    'size' => 230
                ],
                'mobile_default' => [
                    'unit' => 'px',
                    'size' =>  150
                ],
                'selectors' => [
                    '(desktop) {{WRAPPER}} .swiper-slide:nth-child(3n+1) .featured-slider .post-thumbnail' => 'width: {{SIZE}}{{UNIT}};',
                    '(tablet) {{WRAPPER}} .swiper-slide:nth-child(2n+1) .featured-slider .post-thumbnail' => 'width: {{SIZE}}{{UNIT}};',
                    '(mobile) {{WRAPPER}} .swiper-slide .featured-slider .post-thumbnail' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'layout_featured_image_aspect_ratio',
            [
                'label' => esc_html__('Image Aspect Ratio', 'qoxag'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'condition' => ['layout_show_thumbnail' => ['yes']],
                'size_units' => ['%'],
                'range' => [
                    '%' => [
                        'min' => 0.01,
                        'max' => 3.0,
                        'step' => 0.01,
                    ],
                ],
                'default' => [
                    'unit' => '%',
                    'size' => 0.5
                ],
                'tablet_default' => [
                    'unit' => '%',
                    'size' => 1
                ],
                'mobile_default' => [
                    'unit' => '%',
                    'size' => 0.5
                ],
                'selectors' => [
                    '(desktop) {{WRAPPER}} .swiper-slide:nth-child(3n+1) .featured-slider .post-thumbnail' => 'padding-bottom: calc( {{size}} * 100% );',
                    '(tablet) {{WRAPPER}} .swiper-slide:nth-child(2n+1) .featured-slider .post-thumbnail' => 'padding-bottom: calc( {{size}} * 100% );',
                    '(mobile) {{WRAPPER}} .swiper-slide .featured-slider .post-thumbnail' => 'padding-bottom: calc( {{size}} * 100% );',
                ],
            ]
        );

        //meta
        $this->add_control(
            'featured_meta_color',
            [
                'label' => esc_html__('Meta Color', 'qoxag'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#fff',
                'separator' => 'before',
                'selectors' => [
                    '(desktop) {{WRAPPER}} .swiper-slide:nth-child(3n+1) .qoxag-grid-single .post-meta span' => 'color: {{VALUE}};',
                    '(tablet) {{WRAPPER}} .swiper-slide:nth-child(2n+1) .qoxag-grid-single .post-meta span' => 'color: {{VALUE}};',
                    '(mobile) {{WRAPPER}} .swiper-slide .qoxag-grid-single .post-meta span' => 'color: {{VALUE}};',
                ],
            ]
        );

        //container

        $this->add_control(
            'featured_content_bg_color',
            [
                'label' => esc_html__('Content Background', 'qoxag'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#4e65ff',
                'selectors' => [
                    '(desktop) {{WRAPPER}} .swiper-slide:nth-child(3n+1) .qoxag-grid-single' => 'background-color: {{VALUE}};',
                    '(tablet) {{WRAPPER}} .swiper-slide:nth-child(2n+1) .qoxag-grid-single' => 'background-color: {{VALUE}};',
                    '(mobile) {{WRAPPER}} .swiper-slide .qoxag-grid-single' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'layout_featured_container_width',
            [
                'label' => esc_html__('Container Width', 'qoxag'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['%', 'px'],
                'range' => [
                    '%' => [
                        'min' => 1,
                        'max' => 100,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => '%',
                    'size' => 85
                ],
                'tablet_default' => [
                    'unit' => '%',
                    'size' => 86
                ],
                'mobile_default' => [
                    'unit' => '%',
                    'size' => 100
                ],
                'selectors' => [
                    '(desktop) {{WRAPPER}} .swiper-slide:nth-child(3n+1) .featured-slider' => 'max-width: {{SIZE}}{{UNIT}};',
                    '(tablet) {{WRAPPER}} .swiper-slide:nth-child(2n+1) .featured-slider' => 'max-width: {{SIZE}}{{UNIT}};',
                    '(mobile) {{WRAPPER}} .swiper-slide .featured-slider' => 'max-width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'featured_content_padding',
            [
                'label' => esc_html__('Content Padding', 'qoxag'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px'],
                'default' => [
                    'top' => '5',
                    'right' => '5',
                    'bottom' => '5',
                    'left' => '200',
                    'unit' => 'px',
                    'isLinked' => false,
                ],
                'tablet_default' => [
                    'top' => '5',
                    'right' => '5',
                    'bottom' => '5',
                    'left' => '150',
                    'unit' => 'px',
                    'isLinked' => false,
                ],
                'mobile_default' => [
                    'top' => '5',
                    'right' => '5',
                    'bottom' => '5',
                    'left' => '140',
                    'unit' => 'px',
                    'isLinked' => false,
                ],
                'selectors' => [
                    '(desktop) {{WRAPPER}} .swiper-slide:nth-child(3n+1) .qoxag-grid-single' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '(tablet) {{WRAPPER}} .swiper-slide:nth-child(2n+1) .qoxag-grid-single' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '(mobile) {{WRAPPER}} .swiper-slide .qoxag-grid-single' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'featured_content_border_radius',
            [
                'label' => esc_html__('Content Border Radius', 'qoxag'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'default' => [
                    'top' => '5',
                    'right' => '5',
                    'bottom' => '5',
                    'left' => '5',
                    'unit' => 'px',
                    'isLinked' => true,
                ],
                'selectors' => [
                    '(desktop) {{WRAPPER}} .swiper-slide:nth-child(3n+1) .qoxag-grid-single' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '(tablet) {{WRAPPER}} .swiper-slide:nth-child(2n+1) .qoxag-grid-single' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '(mobile) {{WRAPPER}} .swiper-slide .qoxag-grid-single' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );


        $this->end_controls_section();

        /*
         * Slider Navigation Style
         */
        $this->slider_navigation_style_controls();


        /*
         * Advanced style Style
         */
        $this->start_controls_section(
            'section_wrapper_style', [
                'label' => esc_html__('Wrapper Style', 'qoxag'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->advanced_style_controls();

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();

        $tpl = get_widget_template($this->get_name());
        include $tpl;
    }

    protected function content_template()
    {
    }
}